/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul.jf;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainRange;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCstEnum;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.mbsa.translator.simul.SimTrans;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.CompilatorAbstract;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFFlow;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFSim;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFState;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFTrans;
import com.dassault.cecilia.lib.util.compiler.RAMFileManager;
import com.dassault.cecilia.lib.util.io.LimitedWriter;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class CompilatorV4
extends CompilatorAbstract {
    int _cptValueByte = 0;
    int _cptValueInt = 0;
    int _cptValueFloat = 0;
    private static final String NameJFSim = JFSim.class.getSimpleName();
    private static final String NameJFState = JFState.class.getSimpleName();
    private static final String NameJFFlow = JFFlow.class.getSimpleName();
    static int __IDSim = 0;
    int _IDSim = 0;
    RAMFileManager _mfm;
    JavaCompiler _compiler;
    ArrayList<String> _compilerOptions;
    private static boolean __TRACE_SOURCES = Boolean.getBoolean("cecilia.mbsa.translator.simul.jf.trace");
    private static boolean __TRACE_SOURCES_KEEP = Boolean.getBoolean("cecilia.mbsa.translator.simul.jf.traceKeep");
    Writer _logWriter = null;
    final int SPLIT_COMPIL_FLOW = 1000;
    final String FACTORY_FLOW_NAME_CLASS = "FactoFlow";
    final String FACTORY_FLOW_NAME_PACK = "dassault.jfstepper.factoflow";
    final int SPLIT_COMPIL_TR = 1000;
    final String FACTORY_TR_NAME_CLASS = "FactoTr";
    final String FACTORY_TR_NAME_PACK = "dassault.jfstepper.factotr";
    protected Map<Simular, String> _codes = new HashMap<Simular, String>();
    private static final int POS_CODE = "_vF[".indexOf(70);
    private static final int POS_VALUE = "_vF[".indexOf(91);

    public CompilatorV4(Node main, Model architect) {
        super(main, architect);
    }

    JavaFileObject makeSource(String name, String code) {
        JavaFileObject javaFile = RAMFileManager.makeSource(name, code);
        if (this._logWriter != null) {
            try {
                this._logWriter.write(code);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return javaFile;
    }

    private static boolean isBooleanScale(Expr ... args) {
        for (Expr expr : args) {
            if (expr.getScale() == Expr.Scale.Boolean) continue;
            return false;
        }
        return true;
    }

    private static boolean isBooleanMasked(Expr ... args) {
        for (Expr expr : args) {
            if (expr instanceof ExprCst || expr instanceof ExprVar) continue;
            if (expr instanceof ExprOp) {
                ExprOp exprOp = (ExprOp)expr;
                if (exprOp.getType() == ExprOp.Type.ITE && CompilatorV4.isBooleanScale(exprOp.getArg(1), exprOp.getArg(2)) && CompilatorV4.isBooleanMasked(exprOp.getArg(1), exprOp.getArg(2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void printExprBool(Expr expr, Appendable output, boolean ctrl) throws IOException {
        if (expr instanceof ExprCst && expr.getScale() == Expr.Scale.Boolean) {
            output.append(expr.getBool() ? "true" : "false");
            return;
        }
        if (expr instanceof ExprOp) {
            ExprOp exprOp = (ExprOp)expr;
            switch (exprOp.getType()) {
                case EQ: {
                    output.append("(");
                    if (CompilatorV4.isBooleanScale(expr.getArg(0), expr.getArg(1)) && !CompilatorV4.isBooleanMasked(expr.getArg(0), expr.getArg(1))) {
                        this.printExprBool(expr.getArg(0), output, false);
                        output.append("==");
                        this.printExprBool(expr.getArg(1), output, false);
                    } else {
                        this.printExprNum(expr.getArg(0), output, false);
                        output.append("==");
                        this.printExprNum(expr.getArg(1), output, false);
                    }
                    output.append(")");
                    return;
                }
                case NEQ: {
                    output.append("(");
                    if (CompilatorV4.isBooleanScale(expr.getArg(0), expr.getArg(1)) && !CompilatorV4.isBooleanMasked(expr.getArg(0), expr.getArg(1))) {
                        this.printExprBool(expr.getArg(0), output, false);
                        output.append("!=");
                        this.printExprBool(expr.getArg(1), output, false);
                    } else {
                        this.printExprNum(expr.getArg(0), output, false);
                        output.append("!=");
                        this.printExprNum(expr.getArg(1), output, false);
                    }
                    output.append(")");
                    return;
                }
                case LEQ: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append("<=");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case GEQ: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append(">=");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case LT: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append("<");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case GT: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append(">");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case NOT: {
                    output.append("(!");
                    this.printExprBool(expr.getArg(0), output, false);
                    output.append(")");
                    return;
                }
                case IMPLY: {
                    output.append("(!");
                    this.printExprBool(expr.getArg(0), output, false);
                    output.append("||");
                    this.printExprBool(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case OR: 
                case AND: {
                    output.append("(");
                    for (int i = 0; i < expr.getArgCount(); ++i) {
                        if (i > 0) {
                            switch (((ExprOp)expr).getType()) {
                                case OR: {
                                    output.append("||");
                                    break;
                                }
                                case AND: {
                                    output.append("&&");
                                }
                            }
                        }
                        this.printExprBool(expr.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
                case ITE: {
                    if (!CompilatorV4.isBooleanScale(exprOp.getArg(1), exprOp.getArg(2))) break;
                    output.append("(");
                    this.printExprBool(exprOp.getArg(0), output, false);
                    output.append("?");
                    this.printExprBool(exprOp.getArg(1), output, false);
                    output.append(":");
                    this.printExprBool(exprOp.getArg(2), output, false);
                    output.append(")");
                    return;
                }
                case CASE: {
                    int i;
                    boolean isBool = true;
                    for (int i2 = 1; i2 < exprOp.getArgCount() - 1; i2 += 2) {
                        if (exprOp.getScale() == Expr.Scale.Boolean) continue;
                        isBool = false;
                        break;
                    }
                    if (!isBool) break;
                    int nbrArg = exprOp.getArgCount();
                    for (i = 0; i < nbrArg - 1; ++i) {
                        output.append("(");
                        this.printExprBool(exprOp.getArg(i++), output, false);
                        output.append("?");
                        this.printExprBool(exprOp.getArg(i), output, false);
                        output.append(":");
                    }
                    this.printExprBool(exprOp.getArg(nbrArg - 1), output, false);
                    for (i = nbrArg / 2; i > 0; --i) {
                        output.append(")");
                    }
                    return;
                }
            }
        }
        if (ctrl) {
            throw new IOException("Expression error (not compilable in java code) : " + expr.toLL());
        }
        output.append("(");
        this.printExprNum(expr, output, true);
        output.append(" != 0)");
    }

    private void printExprNum(Expr expr, Appendable output, boolean ctrl) throws IOException {
        if (expr instanceof ExprCstEnum) {
            output.append(Integer.toString(((ExprCstEnum)expr).getSymbol()));
            return;
        }
        if (expr instanceof ExprCst) {
            switch (expr.getScale()) {
                case Boolean: {
                    output.append(expr.getBool() ? "1" : "0");
                    break;
                }
                case Integer: {
                    output.append(Long.toString(expr.getInt()));
                    break;
                }
                case Float: {
                    output.append(Double.toString(expr.getFloat()));
                    break;
                }
                case Symbolic: {
                    output.append(Integer.toString(expr.getSymbol()));
                }
            }
            return;
        }
        if (expr instanceof ExprVar) {
            Simular var = ((ExprVar)expr).getVar().getSimular();
            output.append("sim.").append(this._codes.get(var));
            return;
        }
        if (expr instanceof ExprOp) {
            ExprOp exprOp = (ExprOp)expr;
            switch (exprOp.getType()) {
                case CASE: {
                    int i;
                    boolean isBool = true;
                    for (int i2 = 1; i2 < exprOp.getArgCount() - 1; i2 += 2) {
                        if (exprOp.getScale() == Expr.Scale.Boolean) continue;
                        isBool = false;
                        break;
                    }
                    if (isBool) break;
                    int nbrArg = exprOp.getArgCount();
                    for (i = 0; i < nbrArg - 1; ++i) {
                        output.append("(");
                        this.printExprBool(exprOp.getArg(i++), output, false);
                        output.append("?");
                        this.printExprNum(exprOp.getArg(i), output, false);
                        output.append(":");
                    }
                    this.printExprNum(exprOp.getArg(nbrArg - 1), output, false);
                    for (i = nbrArg / 2; i > 0; --i) {
                        output.append(")");
                    }
                    return;
                }
                case XCASE: {
                    int i;
                    int nbrArg = exprOp.getArgCount();
                    output.append("sim.XCase(");
                    this.printExprNum(exprOp.getArg(nbrArg - 1), output, false);
                    output.append(", new boolean[] {");
                    for (i = 0; i < nbrArg - 1; i += 2) {
                        if (i > 0) {
                            output.append(",");
                        }
                        this.printExprBool(exprOp.getArg(i), output, false);
                    }
                    output.append("}, new double[] {");
                    for (i = 1; i < nbrArg; i += 2) {
                        if (i > 1) {
                            output.append(",");
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append("}, \"").append(expr.toString().replaceAll("\"", "'").replaceAll("\n", "\\\\n"));
                    output.append("\")");
                    return;
                }
                case ITE: {
                    if (CompilatorV4.isBooleanScale(exprOp.getArg(1), exprOp.getArg(2))) break;
                    output.append("(");
                    this.printExprBool(exprOp.getArg(0), output, false);
                    output.append("?");
                    this.printExprNum(exprOp.getArg(1), output, false);
                    output.append(":");
                    this.printExprNum(exprOp.getArg(2), output, false);
                    output.append(")");
                    return;
                }
                case CRD: {
                    output.append("(");
                    for (int i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 0) {
                            output.append("+");
                        }
                        output.append("(");
                        this.printExprBool(exprOp.getArg(i), output, false);
                        output.append(" ? 1 : 0)");
                    }
                    output.append(")");
                    return;
                }
                case NEG: {
                    output.append("(-1*");
                    this.printExprNum(exprOp.getArg(0), output, false);
                    output.append(")");
                    return;
                }
                case MIN: 
                case MAX: 
                case DIV: {
                    int i;
                    block32: for (i = 1; i < exprOp.getArgCount(); ++i) {
                        switch (exprOp.getType()) {
                            case MIN: {
                                output.append("sim.Min(");
                                continue block32;
                            }
                            case MAX: {
                                output.append("sim.Max(");
                                continue block32;
                            }
                            case DIV: {
                                output.append("sim.Div(");
                            }
                        }
                    }
                    for (i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 1) {
                            output.append(")");
                        }
                        if (i > 0) {
                            output.append(",");
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
                case MOD: {
                    int i;
                    for (i = 1; i < exprOp.getArgCount(); ++i) {
                        output.append("sim.Mod(");
                    }
                    for (i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 1) {
                            output.append(")");
                        }
                        if (i > 0) {
                            output.append(",");
                        }
                        if (exprOp.getScale() == Expr.Scale.Float) {
                            output.append("(int)");
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
                case ADD: 
                case SUB: 
                case MUL: {
                    output.append("(");
                    for (int i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 0) {
                            switch (exprOp.getType()) {
                                case ADD: {
                                    output.append("+");
                                    break;
                                }
                                case SUB: {
                                    output.append("-");
                                    break;
                                }
                                case MUL: {
                                    output.append("*");
                                }
                            }
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
            }
        }
        if (ctrl) {
            throw new IOException("Expression error (not compilable in java code) : " + expr.toLL());
        }
        output.append("((");
        this.printExprBool(expr, output, true);
        output.append(") ? 1 : 0)");
    }

    private boolean compileFactoryFlows(int idx, int base, int limit) throws IOException {
        String packageFacto = "dassault.jfstepper.factoflow" + idx;
        String nameFacto = packageFacto + "." + "FactoFlow";
        StringBuffer outFacto = new StringBuffer(1024);
        outFacto.append("package ").append(packageFacto).append(";\n");
        outFacto.append("import ").append(JFSim.class.getName()).append(";\n");
        outFacto.append("\npublic class ").append("FactoFlow");
        outFacto.append(" {\n");
        outFacto.append("  public static void defineFlows(JFSim sim) {\n");
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>(limit + 1);
        for (int j = 0; j < limit; ++j) {
            Simular var = (Simular)this._vars.get(base + j);
            String code = this._codes.get(var);
            JFState.Range range = this.getRangeOfCode(code);
            String nameClass = new StringBuffer(128).append("Sim").append(this._IDSim).append("Fl").append(base + j).toString();
            outFacto.append("    sim.addFlow( new ").append(nameClass).append("(sim) );\n");
            StringBuffer output = new StringBuffer(1024);
            output.append("package ").append(packageFacto).append(";\n");
            output.append("import ").append(StepperException.class.getName()).append(";\n");
            output.append("import ").append(JFFlow.class.getName()).append(";\n");
            output.append("import ").append(JFSim.class.getName()).append(";\n");
            output.append("class ").append(nameClass);
            output.append(" extends " + NameJFFlow + ".");
            switch (range) {
                case BYTE: {
                    output.append("Byte");
                    break;
                }
                case INT: {
                    output.append("Int");
                    break;
                }
                case FLOAT: {
                    output.append("Float");
                }
            }
            output.append("{\n");
            output.append("  JFSim sim;\n");
            output.append("  ").append(nameClass).append("(JFSim sim) { this.sim = sim; }\n");
            output.append("  public final boolean evaluate() throws StepperException {\n");
            output.append("    ");
            switch (range) {
                case BYTE: {
                    output.append("byte value = (byte)(");
                    break;
                }
                case INT: {
                    output.append("int value = (int)(");
                    break;
                }
                case FLOAT: {
                    output.append("double value = ");
                }
            }
            this.printExprNum(var.getDefine(), output, false);
            if (range != JFState.Range.FLOAT) {
                output.append(")");
            }
            output.append(";\n");
            output.append("    boolean res = (sim.").append(code).append(" != value);\n");
            output.append("    if (res) sim.").append(code);
            if (var.getDomain() instanceof DomainRange) {
                output.append(" = sim.VerifyDomain(sim._fls[");
                output.append(Integer.toString(var.getIndex()));
                output.append("], value);\n");
            } else {
                output.append(" = value;\n");
            }
            output.append("    return res;\n");
            output.append("  }\n");
            output.append("}");
            JavaFileObject javaFile = this.makeSource(packageFacto + "." + nameClass, output.toString());
            sources.add(javaFile);
        }
        outFacto.append("  }\n");
        outFacto.append("}\n");
        JavaFileObject javaFile = this.makeSource(nameFacto, outFacto.toString());
        sources.add(javaFile);
        StringWriter errWriter = new StringWriter();
        if (!this._compiler.getTask(new LimitedWriter(errWriter, 512), this._mfm, null, this._compilerOptions, null, sources).call().booleanValue()) {
            throw new IOException("Error during compil '" + nameFacto + "'\n" + errWriter.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileFlows() throws IOException {
        long begin = 0L;
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            begin = System.nanoTime();
        }
        int nbrVars = this._vars.size();
        try {
            int idx;
            int i;
            for (i = 0; i < nbrVars; ++i) {
                Simular var = (Simular)this._vars.get(i);
                StringBuffer code = new StringBuffer(128);
                switch (this.getRangeOfDomain(var.getDomain())) {
                    case BYTE: {
                        code.append("_vB[").append(this._cptValueByte++).append("]");
                        break;
                    }
                    case INT: {
                        code.append("_vI[").append(this._cptValueInt++).append("]");
                        break;
                    }
                    case FLOAT: {
                        code.append("_vF[").append(this._cptValueFloat++).append("]");
                    }
                }
                this._codes.put(var, code.toString());
            }
            for (i = 0; i < nbrVars / 1000; ++i) {
                if (this.compileFactoryFlows(i, i * 1000, 1000)) continue;
                boolean bl = false;
                return bl;
            }
            if (nbrVars % 1000 > 0 && !this.compileFactoryFlows(idx = nbrVars / 1000, idx * 1000, nbrVars % 1000)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                long end = System.nanoTime();
                MsgTrans.LOG.finer("Compil Flows(" + nbrVars + ") time : " + (end - begin) / 1000000L);
            }
        }
    }

    private void printCreateTransitionAffect(SimTrans simTr, Appendable output) throws IOException {
        Trans tr = simTr.getTrans();
        LinkedHashMap<String, Integer> code2ID = new LinkedHashMap<String, Integer>();
        int nbrVar = tr.getAffects().size() / 2;
        for (int i = 0; i < nbrVar; ++i) {
            Simular var = ((Var)tr.getAffects().get(i * 2)).getSimular();
            String code = this._codes.get(var);
            JFState.Range range = this.getRangeOfCode(code);
            output.append("    ");
            switch (range) {
                case BYTE: {
                    output.append("byte");
                    break;
                }
                case INT: {
                    output.append("int");
                    break;
                }
                case FLOAT: {
                    output.append("double");
                }
            }
            output.append(" value_");
            output.append(Integer.toString(i));
            output.append(" = ");
            switch (range) {
                case BYTE: {
                    output.append("(byte)(");
                    break;
                }
                case INT: {
                    output.append("(int)(");
                }
            }
            this.printExprNum((Expr)tr.getAffects().get(i * 2 + 1), output, false);
            if (range != JFState.Range.FLOAT) {
                output.append(")");
            }
            output.append(";\n");
            if (code2ID.get(code) != null) {
                int oldIdx = (Integer)code2ID.get(code);
                output.append("    if (");
                output.append("value_");
                output.append(Integer.toString(oldIdx));
                output.append(" != value_");
                output.append(Integer.toString(i));
                output.append(") sim.ThrowTransAffectException(this, sim._sts[");
                output.append(Integer.toString(var.getIndex()));
                output.append("], value_");
                output.append(Integer.toString(oldIdx));
                output.append(", value_");
                output.append(Integer.toString(i));
                output.append(");\n");
                continue;
            }
            code2ID.put(code, i);
        }
        for (Map.Entry entry : code2ID.entrySet()) {
            output.append("    sim.");
            output.append((CharSequence)entry.getKey());
            output.append("=");
            Simular var = ((Var)tr.getAffects().get((Integer)entry.getValue() * 2)).getSimular();
            if (var.getDomain() instanceof DomainRange) {
                output.append("sim.VerifyDomain(sim._sts[");
                output.append(Integer.toString(var.getIndex()));
                output.append("], value_");
                output.append(Integer.toString((Integer)entry.getValue()));
                output.append(");\n");
                continue;
            }
            output.append("value_");
            output.append(Integer.toString((Integer)entry.getValue()));
            output.append(";\n");
        }
    }

    private boolean compileFactoryTrs(int idx, int base, int limit) throws IOException {
        String packageFacto = "dassault.jfstepper.factotr" + idx;
        String nameFacto = packageFacto + "." + "FactoTr";
        StringBuffer outFacto = new StringBuffer(1024);
        outFacto.append("package ").append(packageFacto).append(";\n");
        outFacto.append("import ").append(JFSim.class.getName()).append(";\n");
        outFacto.append("\npublic class ").append("FactoTr");
        outFacto.append(" {\n");
        outFacto.append("  public static void defineTransitions(JFSim sim) {\n");
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>(limit + 1);
        for (int j = 0; j < limit; ++j) {
            SimTrans tr = (SimTrans)this._transs.get(base + j);
            String nameClass = new StringBuffer(128).append("Sim").append(this._IDSim).append("Tr").append(base + j).toString();
            outFacto.append("    sim.addTransition( new ").append(nameClass).append("(sim) );\n");
            StringBuffer output = new StringBuffer(1024);
            output.append("package ").append(packageFacto).append(";\n");
            output.append("import ").append(StepperException.class.getName()).append(";\n");
            output.append("import ").append(JFTrans.class.getName()).append(";\n");
            output.append("import ").append(JFSim.class.getName()).append(";\n");
            output.append("class ").append(nameClass);
            output.append(" extends JFTrans {\n");
            output.append("  JFSim sim;\n");
            output.append("  ").append(nameClass).append("(JFSim sim) { this.sim = sim; }\n");
            output.append("  public final boolean isValid() throws StepperException {\n");
            output.append("    return ");
            this.printExprBool(tr.getTrans().getGuard(), output, false);
            output.append(";\n");
            output.append("  }\n");
            output.append("  public final void affect() throws StepperException {\n");
            this.printCreateTransitionAffect(tr, output);
            output.append("  }\n");
            output.append("}");
            JavaFileObject javaFile = this.makeSource(packageFacto + "." + nameClass, output.toString());
            sources.add(javaFile);
        }
        outFacto.append("  }\n");
        outFacto.append("}\n");
        JavaFileObject javaFile = this.makeSource(nameFacto, outFacto.toString());
        sources.add(javaFile);
        StringWriter errWriter = new StringWriter();
        if (!this._compiler.getTask(new LimitedWriter(errWriter, 512), this._mfm, null, this._compilerOptions, null, sources).call().booleanValue()) {
            throw new IOException("Error during compil '" + nameFacto + "'\n" + errWriter.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileTransitions() throws IOException {
        long begin = 0L;
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            begin = System.nanoTime();
        }
        int nbrTrs = this._transs.size();
        try {
            int idx;
            for (int i = 0; i < nbrTrs / 1000; ++i) {
                if (this.compileFactoryTrs(i, i * 1000, 1000)) continue;
                boolean bl = false;
                return bl;
            }
            if (nbrTrs % 1000 > 0 && !this.compileFactoryTrs(idx = nbrTrs / 1000, idx * 1000, nbrTrs % 1000)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                long end = System.nanoTime();
                MsgTrans.LOG.finer("Compil Transs(" + nbrTrs + ") time : " + (end - begin) / 1000000L);
            }
        }
    }

    private void printEnums(Appendable output) throws IOException {
        output.append("\nprotected void defineEnums() {\n");
        int nbrEnums = this._domains.getEnumSize();
        for (int i = 0; i < nbrEnums; ++i) {
            output.append("  addEnumStr(\"").append(this._domains.getEnumStr(i)).append("\");\n");
        }
        output.append("}\n");
    }

    private void printDomains(Appendable output) throws IOException {
        output.append("\nprotected void defineDomains() {\n");
        int nbrDomains = this._domains.getDomainSize();
        for (int i = 0; i < nbrDomains; ++i) {
            output.append("  addDomain( ");
            Domain dom = this._domains.getDomainFromIndex(i);
            if (dom instanceof DomainRange) {
                output.append("new " + NameJFSim + ".DomainRange(");
                output.append(Integer.toString((int)dom.getDouble(0)));
                output.append(", ");
                output.append(Integer.toString((int)dom.getDouble(dom.getNbrValue() - 1)));
                output.append(")");
            } else {
                output.append("new " + NameJFSim + ".DomainEnum( new int[] {");
                int nbrValues = dom.getNbrValue();
                for (int j = 0; j < nbrValues; ++j) {
                    if (j > 0) {
                        output.append(",");
                    }
                    output.append(Integer.toString((int)dom.getDouble(j)));
                }
                output.append("} )");
            }
            output.append(" );\n");
        }
        output.append("}\n");
    }

    private int getIndexOfDomain(Domain dom) {
        int idx = dom.getIdx();
        if (idx >= 0) {
            return 10 + idx;
        }
        if (dom.equals(this._domains.getBool())) {
            return 0;
        }
        if (dom.equals(this._domains.getInt())) {
            return 1;
        }
        if (dom.equals(this._domains.getFloat())) {
            return 2;
        }
        return -1;
    }

    private JFState.Range getRangeOfDomain(Domain dom) {
        int idx = dom.getIdx();
        if (idx >= 0) {
            int maxValue = -1;
            if (dom instanceof DomainRange) {
                maxValue = (int)dom.getDouble(dom.getNbrValue() - 1);
            } else {
                int nbrValues = dom.getNbrValue();
                for (int j = 0; j < nbrValues; ++j) {
                    int value = (int)dom.getDouble(j);
                    if (maxValue >= value) continue;
                    maxValue = value;
                }
            }
            if (maxValue <= 127) {
                return JFState.Range.BYTE;
            }
            return JFState.Range.INT;
        }
        if (dom.equals(this._domains.getBool())) {
            return JFState.Range.BYTE;
        }
        if (dom.equals(this._domains.getInt())) {
            return JFState.Range.INT;
        }
        return JFState.Range.FLOAT;
    }

    private final JFState.Range getRangeOfCode(String code) {
        switch (code.charAt(POS_CODE)) {
            case 'B': {
                return JFState.Range.BYTE;
            }
            case 'I': {
                return JFState.Range.INT;
            }
        }
        return JFState.Range.FLOAT;
    }

    private final int getIndexValueOfCode(String code) {
        int end = code.indexOf(93);
        return Integer.parseInt(code.substring(POS_VALUE + 1, end));
    }

    private void printStates(Appendable output) throws IOException {
        int i;
        int SPLIT_NBR = 1000;
        int nbrStates = this._states.size();
        int idx = 1;
        for (i = 0; i < nbrStates; ++i) {
            if (i % 1000 == 0) {
                output.append("private void defineStates_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            Simular var = (Simular)this._states.get(i);
            var.setIndex(i);
            Domain dom = var.getDomain();
            int idxValue = 0;
            StringBuffer code = new StringBuffer(128);
            switch (this.getRangeOfDomain(dom)) {
                case BYTE: {
                    idxValue = this._cptValueByte++;
                    output.append("  addState(new " + NameJFState + ".Byte(");
                    code.append("_vB[").append(idxValue).append("]");
                    break;
                }
                case INT: {
                    idxValue = this._cptValueInt++;
                    output.append("  addState(new " + NameJFState + ".Int(");
                    code.append("_vI[").append(idxValue).append("]");
                    break;
                }
                case FLOAT: {
                    idxValue = this._cptValueFloat++;
                    output.append("  addState(new " + NameJFState + ".Float(");
                    code.append("_vF[").append(idxValue).append("]");
                }
            }
            output.append(")");
            output.append(");\n");
            this._codes.put(var, code.toString());
            if ((i + 1) % 1000 != 0) continue;
            output.append("}\n");
        }
        if (nbrStates % 1000 != 0) {
            output.append("}\n");
        }
        output.append("\nprotected void defineStates() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineStates_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printFlows(Appendable output) throws IOException {
        int SPLIT_NBR = 1000;
        int nbrVars = this._vars.size();
        output.append("\n");
        int idx = nbrVars / 1000;
        if (nbrVars % 1000 > 0) {
            ++idx;
        }
        output.append("protected void defineFlows() {\n");
        for (int i = 0; i < idx; ++i) {
            output.append("  ").append("dassault.jfstepper.factoflow");
            output.append(Integer.toString(i));
            output.append(".").append("FactoFlow");
            output.append(".defineFlows(this);\n");
        }
        output.append("}\n");
    }

    private void printTransitions(Appendable output) throws IOException {
        int SPLIT_NBR = 1000;
        int nbrTrs = this._transs.size();
        output.append("\n");
        int idx = nbrTrs / 1000;
        if (nbrTrs % 1000 > 0) {
            ++idx;
        }
        output.append("protected void defineTransitions() {\n");
        for (int i = 0; i < idx; ++i) {
            output.append("  ").append("dassault.jfstepper.factotr");
            output.append(Integer.toString(i));
            output.append(".").append("FactoTr");
            output.append(".defineTransitions(this);\n");
        }
        output.append("}\n");
    }

    private void printConstructor(Appendable output, String name) throws IOException {
        output.append("\npublic ");
        output.append(name);
        output.append("() throws IOException {\n  super(");
        output.append(Integer.toString(this._states.size()));
        output.append(",");
        output.append(Integer.toString(this._vars.size()));
        output.append(",");
        output.append(Integer.toString(this._main.getFlowCount()));
        output.append(",");
        output.append(Integer.toString(this._transs.size()));
        output.append(",");
        output.append(Integer.toString(this._cptValueByte));
        output.append(",");
        output.append(Integer.toString(this._cptValueInt));
        output.append(",");
        output.append(Integer.toString(this._cptValueFloat));
        output.append(");\n}\n");
        output.append("\npublic long getUID() {\n  return ");
        output.append(Long.toString(this.getUID()));
        output.append(";\n}\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printJar(File jarFile, String name) throws IOException {
        long begin = 0L;
        this._IDSim = __IDSim++;
        this._compiler = ToolProvider.getSystemJavaCompiler();
        this._compilerOptions = new ArrayList<String>(Arrays.asList("-nowarn", "-g:none"));
        this._mfm = new RAMFileManager(this._compiler.getStandardFileManager(null, null, null));
        if (__TRACE_SOURCES) {
            File logFile = new File(jarFile.getAbsolutePath() + ".log");
            if (!__TRACE_SOURCES_KEEP) {
                logFile.deleteOnExit();
            }
            this._logWriter = new BufferedWriter(new FileWriter(logFile));
        }
        try {
            long end;
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                begin = System.nanoTime();
            }
            try {
                StringWriter output = new StringWriter();
                output.append("import ").append(IOException.class.getName()).append(";\n");
                output.append("import ").append(StepperException.class.getName()).append(";\n");
                output.append("import ").append(JFFlow.class.getName()).append(";\n");
                output.append("import ").append(JFSim.class.getName()).append(";\n");
                output.append("import ").append(JFState.class.getName()).append(";\n");
                output.append("import ").append(JFTrans.class.getName()).append(";\n");
                output.append("\n");
                output.append("public class ").append(name).append(" extends " + NameJFSim + " {\n");
                this.printEnums(output);
                this.printDomains(output);
                this.printStates(output);
                if (!this.compileFlows()) {
                    throw new IOException("Internal error during compil '" + name + "'");
                }
                this.printFlows(output);
                if (!this.compileTransitions()) {
                    throw new IOException("Internal error during compil '" + name + "'");
                }
                this.printTransitions(output);
                this.printConstructor(output, name);
                output.append("\n}\n");
                output.close();
                JavaFileObject javaFile = this.makeSource(name, output.toString());
                StringWriter errWriter = new StringWriter();
                if (!this._compiler.getTask(new LimitedWriter(errWriter, 512), this._mfm, null, this._compilerOptions, null, Arrays.asList(javaFile)).call().booleanValue()) {
                    throw new IOException("Error during compil '" + name + "'\n" + errWriter.toString());
                }
            }
            finally {
                if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                    end = System.nanoTime();
                    MsgTrans.LOG.finer("Compil time : " + (end - begin) / 1000000L);
                }
            }
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                begin = System.nanoTime();
            }
            ZipOutputStream outZipStream = null;
            try {
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(new Attributes.Name("Built-By"), System.getProperty("user.name"));
                Attributes section = new Attributes();
                manifest.getEntries().put("JStepper", section);
                section.put(new Attributes.Name("JStepper-ClassName"), name);
                section.put(new Attributes.Name("Implementation-Version"), "1.0");
                outZipStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
                JavaFileManager.Location location = new JavaFileManager.Location(){

                    @Override
                    public boolean isOutputLocation() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return "CLASS_PATH";
                    }
                };
                for (String namePackage : this._mfm.listPackage()) {
                    Iterator iter = this._mfm.list(location, namePackage, (Set)Collections.singleton(JavaFileObject.Kind.CLASS), false).iterator();
                    byte[] read = new byte[1024];
                    while (iter.hasNext()) {
                        JavaFileObject jfo = (JavaFileObject)iter.next();
                        InputStream inputStream = jfo.openInputStream();
                        ZipEntry ze = new ZipEntry(jfo.getName().replace(".", "/") + ".class");
                        outZipStream.putNextEntry(ze);
                        int len = 1024;
                        while ((len = inputStream.read(read)) > 0) {
                            outZipStream.write(read, 0, len);
                        }
                        outZipStream.closeEntry();
                    }
                }
                ZipEntry ze = new ZipEntry(name + ".data");
                outZipStream.putNextEntry(ze);
                this.printBinaryInformations(outZipStream);
                outZipStream.closeEntry();
            }
            finally {
                if (outZipStream != null) {
                    outZipStream.close();
                }
                if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                    end = System.nanoTime();
                    MsgTrans.LOG.finer("Jar time : " + (end - begin) / 1000000L);
                    MsgTrans.LOG.finer("Jar size : " + jarFile.length());
                }
            }
        }
        finally {
            this._compiler = null;
            this._mfm.close();
            this._mfm = null;
            if (this._logWriter != null) {
                this._logWriter.close();
            }
        }
    }

    private String getTransDescription(Trans tr) {
        LimitedWriter realWrite;
        StringWriter write;
        block3: {
            write = new StringWriter(128);
            realWrite = new LimitedWriter(write, 256, true);
            IndentWriter out = new IndentWriter(realWrite);
            try {
                tr.printOTools(out, 0);
                out.close(true);
            }
            catch (IOException e) {
                if (realWrite.isFull()) break block3;
                e.printStackTrace();
            }
        }
        if (realWrite.isFull()) {
            write.append("  ...");
        }
        return write.toString();
    }

    public void printBinaryInformations(OutputStream stream) throws IOException {
        Simular var;
        int i;
        DataOutputStream output = new DataOutputStream(stream);
        output.writeInt(0);
        int nbr = this._vars.size();
        output.writeInt(nbr);
        for (i = 0; i < nbr; ++i) {
            var = (Simular)this._vars.get(i);
            output.writeUTF(var.getName());
            output.writeInt(this.getIndexOfDomain(var.getDomain()));
            output.writeInt(this.getIndexValueOfCode(this._codes.get(var)));
            output.writeDouble(var.getValue());
            output.writeDouble(Double.NaN);
            output.writeInt(var.getOrderedParents().size());
            for (Simular parent : var.getOrderedParents()) {
                output.writeInt(parent.getIndex());
            }
        }
        nbr = this._states.size();
        output.writeInt(nbr);
        for (i = 0; i < nbr; ++i) {
            var = (Simular)this._states.get(i);
            output.writeUTF(var.getName());
            output.writeInt(this.getIndexOfDomain(var.getDomain()));
            output.writeInt(this.getIndexValueOfCode(this._codes.get(var)));
            output.writeDouble(var.getValue());
            output.writeInt(var.getOrderedParents().size());
            for (Simular parent : var.getOrderedParents()) {
                output.writeInt(parent.getIndex());
            }
        }
        nbr = this._transs.size();
        output.writeInt(nbr);
        for (i = 0; i < nbr; ++i) {
            SimTrans tr = (SimTrans)this._transs.get(i);
            output.writeUTF(tr.getEvent().getName());
            output.writeUTF(this.getTransDescription(tr.getTrans()));
            boolean bStochastic = tr.getEvent().isStochastic();
            output.writeBoolean(bStochastic);
            if (!bStochastic) {
                output.writeDouble(tr.getEvent().computeDelay(0.0));
                output.writeInt(tr.getEvent().getPriority());
            }
            output.writeInt(tr.getOrderedParents().size());
            for (Simular parent : tr.getOrderedParents()) {
                output.writeInt(parent.getIndex());
            }
        }
        int nbrVars = this._main.getFlowCount();
        output.writeInt(nbrVars);
        for (i = 0; i < nbrVars; ++i) {
            String name = null;
            Var var2 = this._main.getFlow(i);
            if (var2.getSimular().getVar() != var2) {
                name = var2.getName();
            }
            var2 = var2.getSimular().getVar();
            if (name == null) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                output.writeUTF(name);
            }
            if (var2 instanceof State) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
            }
            output.writeInt(var2.getSimular().getIndex());
        }
    }
}

