/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.robot;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.general.robot.CaptureHook;
import com.dassault.cecilia.plugin.general.robot.IHook;
import com.dassault.cecilia.plugin.general.robot.ScenarioFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class PluginCmdCapture
extends AbstractPluginModel
implements PluginMAction {
    protected static final String VERSION = "1.0.00";
    public static final String OPT_DELAY = PluginCmdCapture.class.getName() + "#DelayMouseMove";
    public static final String OPT_KEY_CLOSE = PluginCmdCapture.class.getName() + "#KeyStop";
    public static final String OPT_KEY_RMK = PluginCmdCapture.class.getName() + "#KeyRemark";
    CaptureOptsPanel _opts = null;

    protected String getOptDelay(Plugable launcher) {
        return Long.toString(PlugableUtility.getLongOpt((Plugable)launcher, (String)OPT_DELAY, (long)250L));
    }

    protected String getOptStop(Plugable launcher) {
        String opt = launcher.getOption(OPT_KEY_CLOSE);
        if (opt.length() == 0) {
            opt = "shift F11";
        }
        return opt;
    }

    protected String getOptRmk(Plugable launcher) {
        String opt = launcher.getOption(OPT_KEY_RMK);
        if (opt.length() == 0) {
            opt = "ctrl F11";
        }
        return opt;
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new CaptureOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    public String getInfo(String key) {
        if (key.equals("plugin.version")) {
            return VERSION;
        }
        if (key.equals("plugin.name")) {
            return "Capture of user events";
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return "Capture Mouse & Keyboard event in order to save and replay scenario of test.\n";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public void createSession(Plugable launcher, Object parameters) {
        CapturePanel pPane = new CapturePanel(launcher);
        launcher.addPanel((PlugPanel)pPane, -1L);
    }

    class CapturePanel
    extends JPanel
    implements PlugPanel {
        JTextArea _ctrlTxt;
        IHook _hook;
        JButton _ctrlOpen;

        public CapturePanel(final Plugable launcher) {
            super(new BorderLayout());
            this._hook = new IHook(){
                DecimalFormat _df = new DecimalFormat("0000");

                @Override
                public boolean MouseProc(int action, int button, int x, int y) {
                    CapturePanel.this._ctrlTxt.append("\t<mouse");
                    CapturePanel.this._ctrlTxt.append(" act=\"");
                    switch (action) {
                        case 1: {
                            CapturePanel.this._ctrlTxt.append("press");
                            break;
                        }
                        case 2: {
                            CapturePanel.this._ctrlTxt.append("release");
                            break;
                        }
                        default: {
                            CapturePanel.this._ctrlTxt.append("move");
                            break;
                        }
                        case 4: {
                            CapturePanel.this._ctrlTxt.append("wheel");
                        }
                    }
                    CapturePanel.this._ctrlTxt.append("\"");
                    if (button > 0) {
                        CapturePanel.this._ctrlTxt.append(" but=\"");
                        switch (button) {
                            default: {
                                CapturePanel.this._ctrlTxt.append(Integer.toString(1024));
                                break;
                            }
                            case 2: {
                                CapturePanel.this._ctrlTxt.append(Integer.toString(2048));
                                break;
                            }
                            case 3: {
                                CapturePanel.this._ctrlTxt.append(Integer.toString(4096));
                            }
                        }
                        CapturePanel.this._ctrlTxt.append("\"");
                    }
                    CapturePanel.this._ctrlTxt.append(" x=\"");
                    CapturePanel.this._ctrlTxt.append(Integer.toString(x));
                    CapturePanel.this._ctrlTxt.append("\"");
                    CapturePanel.this._ctrlTxt.append(" y=\"");
                    CapturePanel.this._ctrlTxt.append(Integer.toString(y));
                    CapturePanel.this._ctrlTxt.append("\"");
                    CapturePanel.this._ctrlTxt.append("/>\n");
                    return true;
                }

                @Override
                public boolean KeybdProc(int keyCode, boolean up) {
                    CapturePanel.this._ctrlTxt.append("\t<keybd");
                    CapturePanel.this._ctrlTxt.append(" act=\"");
                    CapturePanel.this._ctrlTxt.append(up ? "release" : "press");
                    CapturePanel.this._ctrlTxt.append("\"");
                    CapturePanel.this._ctrlTxt.append(" key=\"");
                    CapturePanel.this._ctrlTxt.append(Integer.toString(keyCode));
                    CapturePanel.this._ctrlTxt.append("\"");
                    CapturePanel.this._ctrlTxt.append("/>\n");
                    return true;
                }

                @Override
                public boolean SleepProc(long delay) {
                    CapturePanel.this._ctrlTxt.append("\t<sleep");
                    CapturePanel.this._ctrlTxt.append(" delay=\"");
                    CapturePanel.this._ctrlTxt.append(this._df.format(delay));
                    CapturePanel.this._ctrlTxt.append("\"");
                    CapturePanel.this._ctrlTxt.append("/> ");
                    return true;
                }

                @Override
                public boolean RemarkProc(int nbr) {
                    CapturePanel.this._ctrlTxt.append("\t<!-- Remark ");
                    CapturePanel.this._ctrlTxt.append(Integer.toString(nbr));
                    CapturePanel.this._ctrlTxt.append(" -->\n");
                    return true;
                }
            };
            this.add((Component)new JLabel("Trace of capture"), "North");
            this._ctrlTxt = new JTextArea(20, 40);
            this._ctrlTxt.setFont(new Font("Monospaced", 0, 12));
            this.add((Component)new JScrollPane(this._ctrlTxt), "Center");
            JPanel buts = new JPanel(new FlowLayout(1, 5, 5));
            this._ctrlOpen = new JButton("Open Hook");
            this._ctrlOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CaptureHook hook;
                    KeyStroke rmk;
                    long delay = PlugableUtility.getLongOpt((Plugable)launcher, (String)OPT_DELAY, (long)250L);
                    KeyStroke stop = KeyStroke.getKeyStroke(PluginCmdCapture.this.getOptStop(launcher));
                    if (stop == null) {
                        stop = KeyStroke.getKeyStroke(122, 64);
                    }
                    if ((rmk = KeyStroke.getKeyStroke(PluginCmdCapture.this.getOptRmk(launcher))) == null) {
                        rmk = KeyStroke.getKeyStroke(122, 128);
                    }
                    if ((hook = CaptureHook.getInstance()).OpenHook(CapturePanel.this._hook, delay, stop, rmk)) {
                        CapturePanel.this._ctrlOpen.setEnabled(false);
                    }
                }
            });
            buts.add(this._ctrlOpen);
            JButton ctrlClose = new JButton("Close Hook");
            ctrlClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CaptureHook hook = CaptureHook.getInstance();
                    hook.CloseHook(CapturePanel.this._hook);
                    CapturePanel.this._ctrlOpen.setEnabled(true);
                }
            });
            buts.add(ctrlClose);
            JButton ctrlSave = new JButton("Save Scenario");
            ctrlSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser dlg = new JFileChooser(".");
                    dlg.setFileFilter(new ScenarioFileFilter());
                    dlg.setMultiSelectionEnabled(false);
                    if (dlg.showSaveDialog(CapturePanel.this) == 0) {
                        File file = dlg.getSelectedFile();
                        try {
                            FileWriter writer = new FileWriter(file);
                            writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-15\"?>\n");
                            writer.write("<scenario>\n");
                            writer.write(CapturePanel.this._ctrlTxt.getText());
                            writer.write("</scenario>\n");
                            writer.close();
                        }
                        catch (IOException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
            });
            buts.add(ctrlSave);
            this.add((Component)buts, "South");
        }

        public void trash() {
        }

        public Component getPanel() {
            return this;
        }

        public String getInfo(String key) {
            if (key.equals("ppanel.title")) {
                return "Capture Mouse & Keyboard";
            }
            if (key.equals("ppanel.default.width")) {
                return "400";
            }
            if (key.equals("ppanel.default.height")) {
                return "300";
            }
            return PluginCmdCapture.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }

    class CaptureOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JComboBox _ctrlDelay;
        JComboBox _ctrlStop;
        JComboBox _ctrlRmk;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlDelay.setSelectedItem(PluginCmdCapture.this.getOptDelay(launcher));
            this._ctrlStop.setSelectedItem(PluginCmdCapture.this.getOptStop(launcher));
            this._ctrlRmk.setSelectedItem(PluginCmdCapture.this.getOptRmk(launcher));
        }

        public void trash() {
        }

        public CaptureOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createTitledBorder("Capture options"));
            int line = 0;
            root.add((Component)new JCRLabel("Delay Mouse"), new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlDelay = new JComboBox();
            root.add(this._ctrlDelay, new GridBagConstraints(1, line++, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel("Key Stop"), new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlStop = new JComboBox();
            root.add(this._ctrlStop, new GridBagConstraints(1, line++, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel("Key Remark"), new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlRmk = new JComboBox();
            root.add(this._ctrlRmk, new GridBagConstraints(1, line++, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlDelay.addItem("100");
            this._ctrlDelay.addItem("250");
            this._ctrlDelay.addItem("500");
            this._ctrlDelay.addItem("1000");
            this._ctrlDelay.setEditable(true);
            this._ctrlStop.addItem("shift F11");
            this._ctrlStop.addItem("ctrl shift F11");
            this._ctrlStop.addItem("ctrl alt S");
            this._ctrlStop.setEditable(true);
            this._ctrlRmk.addItem("ctrl F11");
            this._ctrlRmk.addItem("ctrl alt R");
            this._ctrlRmk.setEditable(true);
            JButton defVal = new JButton("Default values");
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CaptureOptsPanel.this._ctrlDelay.setSelectedItem("250");
                    CaptureOptsPanel.this._ctrlStop.setSelectedItem("shift F11");
                    CaptureOptsPanel.this._ctrlRmk.setSelectedItem("ctrl F11");
                    CaptureOptsPanel.this._launcher.setOption(OPT_DELAY, (String)CaptureOptsPanel.this._ctrlDelay.getSelectedItem());
                    CaptureOptsPanel.this._launcher.setOption(OPT_KEY_CLOSE, (String)CaptureOptsPanel.this._ctrlStop.getSelectedItem());
                    CaptureOptsPanel.this._launcher.setOption(OPT_KEY_RMK, (String)CaptureOptsPanel.this._ctrlRmk.getSelectedItem());
                }
            });
            root.add((Component)defVal, new GridBagConstraints(0, line, 2, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlDelay.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    String value = (String)CaptureOptsPanel.this._ctrlDelay.getSelectedItem();
                    try {
                        long ival = Long.parseLong(value);
                        if (ival > 0L) {
                            CaptureOptsPanel.this._launcher.setOption(OPT_DELAY, value);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    CaptureOptsPanel.this._ctrlDelay.setSelectedItem(PluginCmdCapture.this.getOptDelay(CaptureOptsPanel.this._launcher));
                }
            });
            this._ctrlStop.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    String value = (String)CaptureOptsPanel.this._ctrlStop.getSelectedItem();
                    KeyStroke keys = KeyStroke.getKeyStroke(value);
                    if (keys != null) {
                        CaptureOptsPanel.this._launcher.setOption(OPT_KEY_CLOSE, value);
                        return;
                    }
                    CaptureOptsPanel.this._ctrlStop.setSelectedItem(PluginCmdCapture.this.getOptStop(CaptureOptsPanel.this._launcher));
                }
            });
            this._ctrlRmk.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    String value = (String)CaptureOptsPanel.this._ctrlRmk.getSelectedItem();
                    KeyStroke keys = KeyStroke.getKeyStroke(value);
                    if (keys != null) {
                        CaptureOptsPanel.this._launcher.setOption(OPT_KEY_RMK, value);
                        return;
                    }
                    CaptureOptsPanel.this._ctrlRmk.setSelectedItem(PluginCmdCapture.this.getOptRmk(CaptureOptsPanel.this._launcher));
                }
            });
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public String getInfo(String key) {
            return PluginCmdCapture.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

