/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.ARALIAComputor;
import com.dassault.cecilia.lib.distrib.compute.CmdLauncher;
import com.dassault.cecilia.lib.distrib.compute.CopyStream;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ACeciliaBDDComputor
extends ARALIAComputor {
    public static final String CECILIABDDMEMORYERR = "Memory exhausted";
    public static final String CECILIABDDTIMEERR = "Time elapsed";
    public static final String CECILIABDDVERSION = "CeciliaBDD version ";

    public ACeciliaBDDComputor() {
        File lowstart = null;
        String propLowstart = System.getProperty("cecilia.jxta.ceciliabdd.lowstart.exec");
        if (propLowstart != null) {
            lowstart = new File(propLowstart);
            if (!lowstart.exists()) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.ceciliabdd.lowstart.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
                return;
            }
            this._bUseLowstart = true;
        } else {
            this._bUseLowstart = false;
        }
        File engine = new File(System.getProperty("cecilia.jxta.ceciliabdd.exec", "ceciliabdd.exe"));
        if (!engine.exists()) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.ceciliabdd.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
            return;
        }
        this._processLaunchArray = new ArrayList();
        if (this._bUseLowstart) {
            this._processLaunchArray.add(lowstart.getAbsolutePath());
            String lowstartOptions = System.getProperty("cecilia.jxta.ceciliabdd.lowstart.options");
            if (lowstartOptions != null) {
                ACeciliaBDDComputor.parseArguments(lowstartOptions, this._processLaunchArray);
            }
        }
        this._processLaunchArray.add(engine.getAbsolutePath());
        File config = new File(System.getProperty("cecilia.jxta.ceciliabdd.config", "ceciliabdd.cfg"));
        if (config.exists()) {
            this._configurationPath = config.getAbsolutePath();
        } else {
            Loggeur.log(this.getClass(), Loggeur.WARNING, "cecilia.jxta.ceciliabdd.config " + ResJXTA.getString("ENGINE_WRONG_PATH"));
        }
    }

    @Override
    protected void initErrorMessage() {
        this.versionMessage = CECILIABDDVERSION;
    }

    @Override
    public int containsErrorDuringTest(String line, boolean out) {
        return 12345;
    }

    @Override
    public int containsErrorDuringComputing(String line, boolean out) {
        if (line.contains(CECILIABDDMEMORYERR)) {
            return -100;
        }
        if (line.contains(CECILIABDDTIMEERR)) {
            return -200;
        }
        return 12345;
    }

    @Override
    public boolean verifyEngine() {
        if (this._processLaunchArray == null) {
            return false;
        }
        this._computingState = 0;
        try {
            String[] cmd = new String[this._processLaunchArray.size() + 1];
            cmd = this._processLaunchArray.toArray(cmd);
            cmd[this._processLaunchArray.size()] = "-v";
            this._proc = CmdLauncher.execute(null, cmd, null, JXTAProperties.getTempDir());
            CopyStream outThread = new CopyStream("ENGINE-OUT-CECILIABDD"){

                @Override
                protected void println(String line) {
                    super.println(line);
                    int err = ACeciliaBDDComputor.this.containsErrorDuringTest(line, true);
                    if (err != 12345) {
                        ACeciliaBDDComputor.this._computingState = err;
                    }
                    if (line.contains(ACeciliaBDDComputor.this.versionMessage)) {
                        ACeciliaBDDComputor.this.version = ACeciliaBDDComputor.this.getVersion(line);
                    }
                }
            };
            outThread.setIn(this._proc.getInputStream());
            outThread.setOut(System.out);
            outThread.start();
            CopyStream errThread = new CopyStream("ENGINE-ERR-CECILIABDD");
            errThread.setIn(this._proc.getErrorStream());
            errThread.setOut(System.err);
            errThread.start();
            this._proc.waitFor();
            Thread.sleep(100L);
            if (this.version.equals("") || !this.version.substring(0, 1).equals("3")) {
                Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_ARALIA_ERROR_VERSION"));
                this._computingState = -500;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_ERROR", ""));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void launchExecutable(Request req) throws IOException {
        String cmdFileName = req.getCmdFileName();
        List<String> neededFiles = req.getNeededFiles();
        int nbrFile = 0;
        if (this._configurationPath != null) {
            ++nbrFile;
        }
        nbrFile += neededFiles.size();
        if (!neededFiles.contains(cmdFileName)) {
            ++nbrFile;
        }
        int idx = this._processLaunchArray.size();
        String[] cmds = new String[nbrFile * 2 + idx + 1];
        cmds = this._processLaunchArray.toArray(cmds);
        cmds[idx++] = "--verify";
        if (this._configurationPath != null) {
            cmds[idx++] = "-c";
            cmds[idx++] = this._configurationPath;
        }
        for (String uniqueFileName : neededFiles) {
            if (uniqueFileName.equals(cmdFileName)) continue;
            File neededFile = new File(JXTAProperties.getTempDir(), uniqueFileName);
            cmds[idx++] = "-f";
            cmds[idx++] = neededFile.getAbsolutePath();
        }
        File cmdFile = new File(JXTAProperties.getTempDir(), cmdFileName);
        cmds[idx++] = "-e";
        cmds[idx++] = cmdFile.getAbsolutePath();
        this._proc = CmdLauncher.execute(req.getShortNumber(), cmds, null, JXTAProperties.getTempDir());
    }

    @Override
    protected String getEndOfSession() {
        return "@Bye@";
    }

    @Override
    protected void launchInputThread(String id) throws IOException {
    }
}

