/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.ARALIAComputor;
import com.dassault.cecilia.lib.distrib.compute.CmdLauncher;
import com.dassault.cecilia.lib.distrib.compute.CopyStream;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;

public class ARALIA2Computor
extends ARALIAComputor {
    public static final String ARALIA2MEMORYERR = "Memory exhausted";
    public static final String ARALIA2TIMEERR = "Time elapsed";
    public static final String ARALIA2LICENSEERR = "Incorrect or absent license key";
    public static final String ARALIA2VERSION = "|Aralia version ";
    public static final String ARALIA2YOURANSWER = "Your answer";
    public static final String ARALIA2QUIT = "(q): Quit.";

    public ARALIA2Computor() {
        File lowstart = null;
        String propLowstart = System.getProperty("cecilia.jxta.aralia2.lowstart.exec");
        if (propLowstart != null) {
            lowstart = new File(propLowstart);
            if (!lowstart.exists()) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.aralia2.lowstart.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
                return;
            }
            this._bUseLowstart = true;
        } else {
            this._bUseLowstart = false;
        }
        File engine = new File(System.getProperty("cecilia.jxta.aralia2.exec", "aralia2.exe"));
        if (!engine.exists()) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "cecilia.jxta.aralia2.exec " + ResJXTA.getString("ENGINE_WRONG_PATH"));
            return;
        }
        this._processLaunchArray = new ArrayList();
        if (this._bUseLowstart) {
            this._processLaunchArray.add(lowstart.getAbsolutePath());
            String lowstartOptions = System.getProperty("cecilia.jxta.aralia2.lowstart.options");
            if (lowstartOptions != null) {
                ARALIA2Computor.parseArguments(lowstartOptions, this._processLaunchArray);
            }
        }
        this._processLaunchArray.add(engine.getAbsolutePath());
        File config = new File(System.getProperty("cecilia.jxta.aralia2.config", "aralia2.cfg"));
        if (config.exists()) {
            this._configurationPath = config.getAbsolutePath();
        } else {
            Loggeur.log(this.getClass(), Loggeur.WARNING, "cecilia.jxta.aralia2.config " + ResJXTA.getString("ENGINE_WRONG_PATH"));
        }
    }

    @Override
    protected void initErrorMessage() {
        this.versionMessage = ARALIA2VERSION;
    }

    @Override
    public int containsErrorDuringTest(String line, boolean out) {
        return 12345;
    }

    @Override
    public int containsErrorDuringComputing(String line, boolean out) {
        if (line.contains(ARALIA2YOURANSWER)) {
            return -600;
        }
        if (line.equals(ARALIA2QUIT)) {
            return -600;
        }
        if (line.contains(ARALIA2MEMORYERR)) {
            return -100;
        }
        if (line.contains(ARALIA2TIMEERR)) {
            return -200;
        }
        if (line.contains(ARALIA2YOURANSWER)) {
            return -600;
        }
        return 12345;
    }

    @Override
    public boolean verifyEngine() {
        if (this._processLaunchArray == null) {
            return false;
        }
        this._computingState = 0;
        try {
            String[] cmds = new String[this._processLaunchArray.size()];
            cmds = this._processLaunchArray.toArray(cmds);
            this._proc = CmdLauncher.execute(null, cmds, null, JXTAProperties.getTempDir());
            CopyStream outThread = new CopyStream("ENGINE-OUT-ARALIA2"){

                @Override
                protected void println(String line) {
                    super.println(line);
                    int err = ARALIA2Computor.this.containsErrorDuringTest(line, true);
                    if (err != 12345) {
                        ARALIA2Computor.this._computingState = err;
                    }
                    if (line.contains(ARALIA2Computor.this.versionMessage)) {
                        ARALIA2Computor.this.version = ARALIA2Computor.this.getVersion(line);
                    }
                }
            };
            outThread.setIn(this._proc.getInputStream());
            outThread.setOut(System.out);
            outThread.start();
            CopyStream errThread = new CopyStream("ENGINE-ERR-ARALIA2");
            errThread.setIn(this._proc.getErrorStream());
            errThread.setOut(System.err);
            errThread.start();
            OutputStream entreeStd = this._proc.getOutputStream();
            byte[] loadexit = "exit;\n".getBytes();
            entreeStd.write(loadexit);
            entreeStd.flush();
            entreeStd.close();
            this._proc.waitFor();
            Thread.sleep(100L);
            if (this.version.equals("") || !this.version.substring(0, 1).equals("2")) {
                Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_ARALIA_ERROR_VERSION"));
                this._computingState = -500;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_ERROR", ""));
            e.printStackTrace();
            return false;
        }
    }
}

