/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanLicenseManager;
import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessEvent;
import com.dassault.cecilia.lib.ban.BanProcessListener;
import com.dassault.cecilia.lib.ban.CryptData;
import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.compute.PreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class BANComputor
implements Computor,
PreAndPostProcessor,
BanProcessListener {
    public static final int BAN_ERROR_NO_COMMAND = -100;
    public static final String NUMBER_OF_ERROR = "dban.result";
    public static final String BASE_DIR_PROPERTY = "dban.basedir";
    public static final String BAN_ERRHEADER = "Ban computor Exception : ";
    private boolean _banFinnished = false;
    private boolean _errorInBan = false;
    private BanEntry banProcess = null;

    @Override
    public boolean sendResultIfError() {
        return true;
    }

    public BANComputor() {
        class BanOCASLicenseManager
        extends BanLicenseManager {
            BanOCASLicenseManager() {
            }

            protected void validLicense(BanProcess process) throws BanLicenseException {
            }

            protected byte[] getData(int value) {
                String name = "JXTABAN";
                switch (value) {
                    case 1: {
                        return name.getBytes();
                    }
                    case 2: {
                        return CryptData.cryptData((String)name, (String)"zertyghjklmpqwxc").getBytes();
                    }
                    case 3: {
                        return "zertyghjklmpqwxc".getBytes();
                    }
                }
                return null;
            }
        }
        BanLicenseManager.defineManager((BanLicenseManager)new BanOCASLicenseManager());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean compute(final Request req) {
        StringBuffer sb;
        this._banFinnished = false;
        this._errorInBan = false;
        String banoptions = req.getEngineOptions();
        Loggeur.log(this.getClass(), Loggeur.INFO, "iBAN " + banoptions);
        HashMap<void, String> _optionsMap = new HashMap<void, String>();
        StringTokenizer st = new StringTokenizer(banoptions, ",");
        while (st.hasMoreTokens()) {
            void var7_7;
            String data = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(data, "=");
            Object var7_8 = null;
            Object objet = null;
            if (st2.hasMoreTokens()) {
                String string = st2.nextToken();
            }
            if (st2.hasMoreTokens()) {
                objet = st2.nextToken();
            }
            if (var7_7 != null) {
                if (objet == null) {
                    sb = new StringBuffer();
                    sb.append("Null value for ban option ");
                    sb.append(String.valueOf(var7_7));
                    Loggeur.log(this.getClass(), Loggeur.WARNING, sb.toString());
                    objet = "";
                }
                _optionsMap.put(var7_7, (String)objet);
                continue;
            }
            Loggeur.log(this.getClass(), Loggeur.WARNING, "Null key for ban option");
        }
        String cmdFileName = (String)_optionsMap.get("COMMAND");
        if (cmdFileName == null) {
            req.setInfo(String.valueOf(-100));
            return false;
        }
        final File scriptFile = new File(JXTAProperties.getTempDir(), cmdFileName);
        _optionsMap.remove("COMMAND");
        try {
            this.banProcess = new BanEntry();
            for (Map.Entry entry : _optionsMap.entrySet()) {
                if (((String)entry.getValue()).contains("\n")) {
                    sb = new StringBuffer();
                    sb.append("LineBreak in option ");
                    sb.append((String)entry.getKey());
                    sb.append(" val = ");
                    sb.append((String)entry.getValue());
                    Loggeur.log(this.getClass(), Loggeur.FINE, sb.toString());
                }
                this.banProcess.setUserProperty((String)entry.getKey(), ((String)entry.getValue()).replace("\n", ""));
            }
            this.banProcess.setUserProperty(BASE_DIR_PROPERTY, JXTAProperties.getTempDir().getAbsolutePath());
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        String nbErr;
                        BANComputor.this.banProcess.execute(scriptFile);
                        Object nbErrObj = BANComputor.this.banProcess.getValueOfVariable(BANComputor.NUMBER_OF_ERROR);
                        if (nbErrObj == null) {
                            nbErrObj = BANComputor.this.banProcess.getValueOfVariable("seqgen.result");
                        }
                        if (Integer.parseInt(nbErr = nbErrObj.toString()) > 0) {
                            req.setInfo(String.valueOf(nbErr) + " " + ResJXTA.getString("GLOBAL_ERRORS"));
                            req.setNumberOfErr(Integer.parseInt(nbErr));
                            BANComputor.this._errorInBan = true;
                        }
                    }
                    catch (Exception e1) {
                        BANComputor.this._errorInBan = true;
                        req.setInfo("BAN execute" + e1.getMessage());
                        Loggeur.log(this.getClass(), Loggeur.ERROR, "BAN ->[] " + e1.getMessage());
                        BANComputor.this._banFinnished = true;
                    }
                }
            };
            thread.setPriority(1);
            this.banProcess.addProcessListener((BanProcessListener)this);
            thread.setName("BAN_COMPUTE" + req.getShortNumber());
            thread.start();
            while (!this._banFinnished) {
                Thread.sleep(100L);
            }
            return !this._errorInBan;
        }
        catch (Exception exception) {
            StringBuffer sb2 = new StringBuffer();
            sb2.append(BAN_ERRHEADER);
            sb2.append(exception.getClass().toString());
            sb2.append(" ");
            sb2.append(exception.getMessage());
            req.setInfo(sb2.toString());
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public String createMessage(int err) {
        return "";
    }

    @Override
    public boolean verifyEngine() {
        try {
            Class.forName("com.dassault.cecilia.lib.ban.BanEntry");
            Loggeur.log(this.getClass(), Loggeur.INFO, "iBAN : " + this.getJarVersion());
        }
        catch (Throwable e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.banProcess != null) {
            this.banProcess.requestStop();
        }
        return true;
    }

    @Override
    public boolean manageFinishedRequest(Request req) {
        return true;
    }

    @Override
    public void manageReqError(Request req, InfoServerApp remoteServer, CECILIAClient client) {
        if (!ReqAutomatonClient.isTemporaryErrorState(req.getState())) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "manageReqError");
        }
        client.copyResultFiles(req);
        ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
    }

    @Override
    public boolean preProcess(Request req) {
        return true;
    }

    public static boolean hasRealError(Request req) {
        if (req.getState() == ReqState.FINISHED_SUCCESFULY) {
            return false;
        }
        if (req.getState() == ReqState.TOO_MANY_ERRORS) {
            return !BANComputor.isGoodEngineError(req);
        }
        return true;
    }

    public static boolean hasLoadableResult(Request req) {
        if (req.getState() == ReqState.FINISHED_SUCCESFULY) {
            return true;
        }
        return BANComputor.isGoodEngineError(req);
    }

    private static boolean isGoodEngineError(Request req) {
        if (req.getState() == ReqState.TOO_MANY_ERRORS) {
            int histoSize = req.getHisto().size();
            ReqState prevState = req.getHisto().getIemeState(histoSize - 2);
            if (prevState == ReqState.ENGINE_ERROR) {
                if (req.getInfo().contains(BAN_ERRHEADER)) {
                    return false;
                }
                if (req.getNumberOfErr() > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public void messageLogged(BanProcessEvent event) {
    }

    public void processFinished(BanProcessEvent event) {
        this._banFinnished = true;
        Loggeur.log(this.getClass(), Loggeur.INFO, "BAN ->[] ");
    }

    public void processStarted(BanProcessEvent event) {
    }

    public void unitFinished(BanProcessEvent event) {
    }

    public void unitProgressed(BanProcessEvent event) {
    }

    public void unitStarted(BanProcessEvent event) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJarVersion() {
        String path = String.valueOf(BanEntry.class.getName().replace(".", "/")) + ".class";
        URL url = ClassLoader.getSystemClassLoader().getResource(path);
        if (url == null) {
            return path;
        }
        try {
            path = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return "!!!";
        }
        int index = path.lastIndexOf("/");
        path = path.substring(0, index);
        if (!path.startsWith("jar:file:")) return path;
        index = path.indexOf("!");
        path = path.substring(9, index);
        try {
            File file = new File(path);
            if (!file.exists()) {
                return "0.0.0";
            }
            try (ZipFile jar = null;){
                jar = new JarFile(file);
                Manifest manifest = ((JarFile)jar).getManifest();
                if (manifest == null) {
                    return "No Manifest";
                }
                String result = manifest.getMainAttributes().getValue("Signature-Version");
                if (result == null) {
                    return "No version";
                }
                String string = result;
                return string;
            }
        }
        catch (IOException e) {
            return "!!!";
        }
    }
}

