/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class BANExternalComputorTestLaunch {
    public static void main(String[] args) {
        try {
            Class<?> cl = Class.forName("com.dassault.cecilia.lib.ban.BanEntry");
            System.out.println("Version=" + BANExternalComputorTestLaunch.getJarVersion(cl));
        }
        catch (Throwable th) {
            System.err.println(String.valueOf(th.getClass().getName()) + " : " + th.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarVersion(Class cl) {
        String path = String.valueOf(cl.getName().replace(".", "/")) + ".class";
        URL url = ClassLoader.getSystemClassLoader().getResource(path);
        if (url == null) {
            return path;
        }
        try {
            path = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return "!!!";
        }
        int index = path.lastIndexOf("/");
        path = path.substring(0, index);
        if (!path.startsWith("jar:file:")) return "6.0 ... [DEBUG=" + path + "]";
        index = path.indexOf("!");
        path = path.substring(9, index);
        try {
            File file = new File(path);
            if (!file.exists()) {
                return "0.0.0";
            }
            try (ZipFile jar = null;){
                jar = new JarFile(file);
                Manifest manifest = ((JarFile)jar).getManifest();
                if (manifest == null) {
                    return "No Manifest";
                }
                String result = manifest.getMainAttributes().getValue("Signature-Version");
                if (result == null) {
                    return "No version";
                }
                String string = result;
                return string;
            }
        }
        catch (IOException e) {
            return "!!!";
        }
    }
}

