/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.PreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.compute.ProcessComputor;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.Request;

public class BANExternalPreAndPostProcessor
implements PreAndPostProcessor {
    @Override
    public String createMessage(int err) {
        switch (err) {
            case 11: {
                return ResJXTA.getString("ENGINE_XBAN_ERROR_VERSION");
            }
            case 10: {
                return ResJXTA.getString("ENGINE_XBAN_ERROR_EXCEPTION");
            }
        }
        return ProcessComputor.createErrMessage(err);
    }

    @Override
    public boolean manageFinishedRequest(Request req) {
        return true;
    }

    @Override
    public void manageReqError(Request req, InfoServerApp remoteServer, CECILIAClient client) {
        if (!ReqAutomatonClient.isTemporaryErrorState(req.getState())) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "manageReqError");
        }
        client.copyResultFiles(req);
        ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
    }

    @Override
    public boolean preProcess(Request req) {
        return true;
    }
}

