/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.compute.PreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class CxuComputor
implements Computor,
PreAndPostProcessor {
    private boolean _stop;

    @Override
    public boolean sendResultIfError() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean compute(Request req) {
        this._stop = false;
        File cmdFile = new File(JXTAProperties.getTempDir(), req.getCmdFileName());
        String command = "";
        try {
            FileReader fr = new FileReader(cmdFile);
            char[] chars = new char[(int)cmdFile.length()];
            fr.read(chars);
            fr.close();
            command = new String(chars);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        StringTokenizer st = new StringTokenizer(command, " ");
        st.nextToken();
        String filename = st.nextToken();
        st.nextToken();
        String result = st.nextToken();
        st.nextToken();
        String timeToWait = st.nextToken();
        long sizelong = new File(JXTAProperties.getTempDir(), filename).length();
        String size = sizelong > 3L ? String.valueOf(sizelong) : "";
        try {
            FileWriter fw = new FileWriter(new File(JXTAProperties.getTempDir(), result));
            fw.write(size);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= Integer.parseInt(timeToWait)) {
                    return true;
                }
                Thread.sleep(1000L);
                if (this._stop) {
                    Loggeur.log(this.getClass(), Loggeur.DEBUG, "Test Canceled");
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean preProcess(Request req) {
        req.setParsed(true);
        return true;
    }

    @Override
    public String createMessage(int err) {
        return "";
    }

    @Override
    public void manageReqError(Request req, InfoServerApp remoteServer, CECILIAClient client) {
        ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
    }

    @Override
    public boolean manageFinishedRequest(Request req) {
        return true;
    }

    @Override
    public boolean verifyEngine() {
        return true;
    }

    @Override
    public boolean stop() {
        this._stop = true;
        return true;
    }
}

