/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.entityinfo;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.RemoteServerChangeListener;
import com.dassault.cecilia.lib.distrib.xmlutility.AdvertisementAnalyser;
import java.util.ArrayList;
import java.util.List;

public class InfoServerApp
extends InfoPeerApp {
    protected long _lastInfoTime = 0L;
    protected boolean _toBeUsed = true;
    protected boolean _shutingDown = false;
    protected int engineErrorCount = 0;
    protected int _stockSize = 0;
    protected ArrayList<String> _engines;
    private String _currentReqID = "";
    public ArrayList<RemoteServerChangeListener> _changeListener = new ArrayList();

    public boolean addEngineErrorCount() {
        ++this.engineErrorCount;
        boolean result = true;
        for (RemoteServerChangeListener listener : this._changeListener) {
            result &= listener.engineErrorCountChange(this.getPeerID(), this.engineErrorCount - 1, this.engineErrorCount);
        }
        return result;
    }

    public InfoServerApp(InfoPeerJXTA remoteJXTAPeer) {
        super(remoteJXTAPeer);
        assert (remoteJXTAPeer.getType().equals("SERVER")) : remoteJXTAPeer.getType();
        this._authorized = true;
        this._engines = new ArrayList();
        AdvertisementAnalyser adv = new AdvertisementAnalyser(remoteJXTAPeer.getAdvDesc());
        this.addEngines(adv.findEngines());
    }

    public boolean shouldBeUsed() {
        return this._toBeUsed;
    }

    public boolean canBeUsedForComputation() {
        return this._toBeUsed && this.canTalkWith() && !this._shutingDown;
    }

    public boolean canBeUsedForComputation(String engine) {
        return this.canBeUsedForComputation() && this.hasEngine(engine);
    }

    public void setToBeUSed(boolean toBeUSed) {
        this._toBeUsed = toBeUSed;
    }

    public void setShutingDown() {
        this._shutingDown = true;
    }

    public boolean isShutingDown() {
        return this._shutingDown;
    }

    public String getCurrentReqID() {
        return this._currentReqID;
    }

    public void setCurrentReqID(String reqID) {
        this._currentReqID = reqID;
    }

    public void setStockSize(int size) {
        if (this._stockSize == size) {
            return;
        }
        int old = this._stockSize;
        this._stockSize = size;
        for (RemoteServerChangeListener listener : this._changeListener) {
            listener.stockSizeChange(this.getPeerID(), old, this._stockSize);
        }
    }

    public int getStockSize() {
        return this._stockSize;
    }

    public void setLastInfoTime(long time) {
        this._lastInfoTime = time;
    }

    public long getLastInfoTime() {
        return this._lastInfoTime;
    }

    public String[] getAuthorizedEngines() {
        return this._engines.toArray(new String[0]);
    }

    public boolean hasEngine(String engine) {
        return this._engines.contains(engine);
    }

    public void addEngines(List<String> engines) {
        this._engines.addAll(engines);
    }

    public void addEngine(String engine) {
        this._engines.remove(engine);
    }

    public void removeEngine(String engine) {
        this._engines.remove(engine);
    }

    public void flushEngines() {
        this._engines.clear();
    }

    public String[] getOriginalEngines() {
        AdvertisementAnalyser adv = new AdvertisementAnalyser(this.getPeerJXTA().getAdvDesc());
        return adv.findEngines().toArray(new String[0]);
    }

    public void addChangeListener(RemoteServerChangeListener listener) {
        if (!this._changeListener.contains(listener)) {
            this._changeListener.add(listener);
        }
    }

    public void removeChangeListener(RemoteServerChangeListener listener) {
        this._changeListener.remove(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" ");
        sb.append("{");
        int i = 0;
        while (i < this._engines.size()) {
            sb.append(this._engines.get(i));
            if (i < this._engines.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

