/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.filetransfert;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.filetransfert.CompressingSender;
import com.dassault.cecilia.lib.distrib.filetransfert.ZipUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLMessageCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;

public class ByteFileSender {
    private FileInputStream _reader;
    protected String fileName;
    protected long lastpart;
    protected File _file;
    protected boolean _zipped = false;
    protected String _associatedRequest = "";
    protected InfoPeerJXTA _remotePeer;
    protected String _senderID = "";

    public ByteFileSender(File file, String futurName, String senderID, InfoPeerJXTA remotePeer, String requestID) {
        long fileSize;
        assert (file != null);
        assert (remotePeer != null);
        assert (senderID != null);
        this._senderID = senderID;
        this._file = file;
        this._remotePeer = remotePeer;
        this.fileName = futurName != null && !futurName.equals("") ? futurName : file.getName();
        if (requestID != null) {
            this._associatedRequest = requestID;
        }
        this.lastpart = (fileSize = file.length()) % 63000L == 0L ? fileSize / 63000L : fileSize / 63000L + 1L;
        try {
            this._reader = new FileInputStream(file);
        }
        catch (IOException e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
        }
    }

    public ByteFileSender(File file, String futurName, String senderID, InfoPeerJXTA remotePeer) {
        this(file, futurName, senderID, remotePeer, "");
    }

    public void sendFileIter() throws DistribException {
        if (this._reader == null) {
            DistribException me = new DistribException("Problem while reading file");
            me.setFilename(this._file.getAbsolutePath());
            throw me;
        }
        byte[] begin = new byte[63000];
        int result = 0;
        if (this.lastpart == 0L) {
            MessageElement eltinfo = this.createInfoMessageElement(0);
            ByteArrayMessageElement advancedEltfile = new ByteArrayMessageElement("FILE", null, begin, null);
            Message message = new Message();
            message.addMessageElement(eltinfo);
            message.addMessageElement((MessageElement)advancedEltfile);
            if (!this._remotePeer.sendMessage(message)) {
                DistribException me = new DistribException("Problem while communicating with peer");
                me.setRemotePeer(this._remotePeer.getPeerIDString());
                throw me;
            }
        } else {
            int i = 0;
            while ((long)i < this.lastpart) {
                try {
                    result = this._reader.read(begin);
                }
                catch (Exception e) {
                    DistribException me = new DistribException("Problem while reading file");
                    me.setFilename(this._file.getAbsolutePath());
                    throw me;
                }
                if (result == -1) {
                    Loggeur.log(this.getClass(), Loggeur.INFO, "ByteFileSender : Empty File");
                }
                MessageElement eltinfo = this.createInfoMessageElement(i);
                ByteArrayMessageElement advancedEltfile = new ByteArrayMessageElement("FILE", null, begin, 0, result, null);
                Message message = new Message();
                message.addMessageElement(eltinfo);
                message.addMessageElement((MessageElement)advancedEltfile);
                if (!this._remotePeer.sendMessage(message)) {
                    DistribException me = new DistribException("Problem while communicating with peer");
                    me.setRemotePeer(this._remotePeer.getPeerIDString());
                    throw me;
                }
                ++i;
            }
        }
        try {
            this._reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ResJXTA.getString("FILE_SENT"));
        sb.append(" ");
        sb.append(this.fileName);
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
    }

    protected MessageElement createInfoMessageElement(int partnumber) {
        XMLMessageCreator infoElement = new XMLMessageCreator();
        HashMap<String, String> attMap = new HashMap<String, String>();
        attMap.put("MESSAGETYPE", "FILETRANSFERT");
        attMap.put("SENDERID", this._senderID);
        attMap.put("FILENAME", this.fileName);
        attMap.put("ENGINE", "ENGINEFREE");
        attMap.put("PARTNUMBER", String.valueOf(partnumber));
        attMap.put("NUMBEROFPARTS", String.valueOf(this.lastpart));
        attMap.put("UID", this._associatedRequest);
        if (this._zipped) {
            attMap.put("FILEFORMAT", "ZIPPED");
        } else {
            attMap.put("FILEFORMAT", "NOTZIPPED");
        }
        infoElement.addEntity("INFO", attMap, null);
        return new StringMessageElement("INFO", infoElement.toString(), null);
    }

    public void setZipped(boolean zipped) {
        this._zipped = zipped;
    }

    public static void sendFileTo(File file, String futurName, String senderID, InfoPeerJXTA remotePeer, String reqId) throws DistribException {
        if (file.length() < 126000L || ZipUtility.isZip(file)) {
            ByteFileSender sender = new ByteFileSender(file, futurName, senderID, remotePeer, reqId);
            sender.sendFileIter();
        } else {
            CompressingSender sender = new CompressingSender(file, futurName, senderID, remotePeer, reqId);
            sender.sendFileIter();
        }
    }

    public static void sendFileTo(File file, String futurName, String senderID, InfoPeerJXTA remotePeer) throws DistribException {
        ByteFileSender.sendFileTo(file, futurName, senderID, remotePeer, "");
    }
}

