/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class BoxDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static String ESCAPE = "Distrib.Escape";
    protected JFrame _parentFrame;
    protected Window _parentWin;
    protected JPanel _root;
    protected JButton _buttonOK;
    protected JButton _buttonCANCEL;
    protected boolean _response;
    protected boolean _isCreate = false;

    public BoxDialog() {
        super((Frame)null);
        this.myInit(null, false);
        this.initShortCuts();
    }

    public BoxDialog(JFrame parent) {
        this(parent, true);
    }

    public BoxDialog(JFrame parent, boolean create) {
        super(parent);
        this.myInit(parent, create);
        this.initShortCuts();
    }

    public BoxDialog(JDialog parent) {
        this(parent, true);
    }

    public BoxDialog(JDialog parent, boolean create) {
        super(parent);
        this.myInit(parent, create);
        this.initShortCuts();
    }

    protected void initShortCuts() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), ESCAPE);
    }

    private void myInit(Window parent, boolean create) {
        this._parentWin = parent;
        this._parentFrame = parent instanceof JFrame ? (JFrame)parent : (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, parent);
        this._root = new JPanel(new BorderLayout());
        this.addWindowListener(this);
        if (create) {
            this.create();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this._buttonCANCEL != null) {
            this._buttonCANCEL.doClick();
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    protected boolean create() {
        if (this._isCreate) {
            return false;
        }
        this._isCreate = true;
        return true;
    }

    public boolean doModal() {
        this._response = false;
        if (!this._isCreate) {
            this.create();
        }
        this.copyToCtrl();
        this.setModal(true);
        this.setVisible(true);
        return this._response;
    }

    public void copyToCtrl() {
    }

    protected boolean centerBox() {
        if (this._parentWin == null) {
            return false;
        }
        Dimension dimension = this.getSize();
        Dimension parentDimension = this._parentWin.getSize();
        Point parentLocation = this._parentWin.getLocation();
        this.setLocation(new Point(parentLocation.x + parentDimension.width / 2 - dimension.width / 2, parentLocation.y + parentDimension.height / 2 - dimension.height / 2));
        return true;
    }

    protected void addButtons() {
        this.addButtons(true);
    }

    protected void addButtons(boolean cancelButton) {
        assert (this._root != null);
        JPanel buttons = new JPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._buttonOK = new JButton(ResJXTAIHM.getString("GLOBAL_OK"));
        this._buttonOK.setActionCommand("OK");
        this._buttonOK.addActionListener(this);
        this._buttonOK.setDefaultCapable(true);
        this._buttonOK.setSize(150, this._buttonOK.getHeight());
        buttons.setLayout(new GridBagLayout());
        buttons.add((Component)this._buttonOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (cancelButton) {
            this._buttonCANCEL = new JButton(ResJXTAIHM.getString("GLOBAL_CANCEL"));
            this._buttonCANCEL.setActionCommand("CANCEL");
            this._buttonCANCEL.addActionListener(this);
            this._buttonCANCEL.setSize(70, this._buttonCANCEL.getHeight());
            buttons.add((Component)this._buttonCANCEL, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this._root.add((Component)buttons, "South");
        JRootPane trueRoot = SwingUtilities.getRootPane(this._root);
        if (trueRoot != null) {
            trueRoot.setDefaultButton(this._buttonOK);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event == null) {
            return;
        }
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equals("OK")) {
            this._response = true;
            this.setVisible(false);
        } else if (cmd.equals("CANCEL")) {
            this.setVisible(false);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }
}

