/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoClientApp;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.UtilTableModel;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStock;

public class StockServerTableModel
extends UtilTableModel {
    private RequestStock _stock;
    private CECILIAServer _client;

    public StockServerTableModel(CECILIAServer client, RequestStock stock) {
        this._stock = stock;
        this._client = client;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this._stock.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Request req = this._stock.get(rowIndex);
        if (req == null) {
            return "null";
        }
        switch (columnIndex) {
            case 0: {
                return req.getShortNumber();
            }
            case 1: {
                return req.getState();
            }
            case 2: {
                return String.valueOf(req.getPriority());
            }
            case 3: {
                InfoClientApp client = this._client.getClientsApp().getClient(req.getClientID());
                if (client == null) {
                    return "null";
                }
                return client.getName();
            }
            case 4: {
                return req.getHisto().toStringShort();
            }
        }
        return "err";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResJXTAIHM.getString("GLOBAL_REQ");
            }
            case 1: {
                return ResJXTAIHM.getString("GLOBAL_STATE");
            }
            case 2: {
                return ResJXTAIHM.getString("GLOBAL_PRIO");
            }
            case 3: {
                return ResJXTAIHM.getString("GLOBAL_CLIENT");
            }
            case 4: {
                return ResJXTAIHM.getString("GLOBAL_HISTO");
            }
        }
        return "err";
    }

    @Override
    public int getColumnSize(int column) {
        switch (column) {
            case 0: {
                return 40;
            }
            case 1: {
                return 80;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 60;
            }
            case 4: {
                return 150;
            }
        }
        return 30;
    }

    @Override
    public int getColumnSizeMax(int col) {
        switch (col) {
            case 0: {
                return 40;
            }
            case 3: {
                return 100;
            }
        }
        return super.getColumnSizeMax(col);
    }

    @Override
    public boolean mustBeHighlightedBold(int row) {
        Request req = this._stock.get(row);
        if (req == null) {
            return true;
        }
        return req.getState() != ReqState.RESULT_SENT;
    }
}

