/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.jxtautility;

import com.dassault.cecilia.lib.distrib.jxtautility.StackTracePrinter;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.File;
import java.net.URI;

public class FileDirDeletor
extends File {
    public FileDirDeletor(File parent, String child) {
        super(parent, child);
    }

    public FileDirDeletor(String parent, String child) {
        super(parent, child);
    }

    public FileDirDeletor(String pathname) {
        super(pathname);
    }

    public FileDirDeletor(URI uri) {
        super(uri);
    }

    public boolean deleteAll() throws SecurityException {
        String[] lstFile;
        boolean status;
        block8: {
            status = true;
            lstFile = this.list();
            if (lstFile != null) break block8;
            return false;
        }
        try {
            int idxFile = 0;
            while (idxFile < lstFile.length) {
                FileDirDeletor fileCur = new FileDirDeletor(this, lstFile[idxFile]);
                if (fileCur.isDirectory()) {
                    status = fileCur.deleteAll();
                    if (!status) break;
                    status = fileCur.delete();
                    Loggeur.log(FileDirDeletor.class, Loggeur.INFO, "Deleting :" + fileCur.getAbsolutePath());
                    if (!status) {
                        break;
                    }
                } else {
                    status = fileCur.delete();
                    if (!status) break;
                }
                ++idxFile;
            }
        }
        catch (SecurityException se) {
            throw (SecurityException)se.fillInStackTrace();
        }
        return status;
    }

    public static boolean deleteIfNotDir(File file) {
        return FileDirDeletor.deleteIfNotDir(file, false);
    }

    public static boolean deleteIfNotDir(File file, boolean forceDeleteOnExit) {
        block5: {
            try {
                if (!file.isDirectory()) break block5;
                StringBuffer sb = new StringBuffer(128);
                sb.append("Try to delete dir: ");
                sb.append(file.getAbsolutePath());
                sb.append("\n");
                sb.append(StackTracePrinter.getStackTrace(new Exception()));
                Loggeur.log(FileDirDeletor.class, Loggeur.ERROR, sb.toString());
                return false;
            }
            catch (Exception e) {
                if (forceDeleteOnExit) {
                    file.deleteOnExit();
                }
                return false;
            }
        }
        boolean result = file.delete();
        if (!result && forceDeleteOnExit) {
            file.deleteOnExit();
        }
        return result;
    }

    public static boolean emptyDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    file.delete();
                }
                ++n2;
            }
            return true;
        }
        catch (Exception e) {
            Loggeur.log(FileDirDeletor.class, Loggeur.WARNING, e);
            return false;
        }
    }
}

