/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.jxtautility;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.JOptionPane;

public class LockUtility {
    private static File _lockFile;
    private static FileWriter _lockWriter;

    public static void createLock(boolean withIHM) {
        File distribDir = new File(JXTAProperties.getDistributedDir());
        _lockFile = new File(distribDir, "jxta.lock");
        if (_lockFile.exists()) {
            int res;
            Loggeur.log(LockUtility.class, Loggeur.ERROR, ResJXTA.getString("LOCK_ERROR"));
            if (withIHM && (res = JOptionPane.showConfirmDialog(null, ResJXTA.getString("LOCK_CONFLICT"), ResJXTA.getString("GLOBAL_ERRORS"), 0)) == 1) {
                System.exit(0);
            }
            if (_lockFile.delete()) {
                FileDirDeletor jxta = new FileDirDeletor(distribDir + File.separator + ".jxta");
                jxta.deleteAll();
            } else {
                JOptionPane.showMessageDialog(null, ResJXTA.getString("LOCK_UNWRITABLE"), ResJXTA.getString("GLOBAL_ERRORS"), 0);
                System.exit(0);
            }
        }
        try {
            _lockWriter = new FileWriter(_lockFile);
            _lockWriter.write(new Date(System.currentTimeMillis()).toString());
            _lockWriter.flush();
        }
        catch (IOException e) {
            if (_lockWriter != null) {
                try {
                    _lockWriter.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (withIHM) {
                JOptionPane.showMessageDialog(null, ResJXTA.getString("LOCK_UNWRITABLE"), ResJXTA.getString("GLOBAL_ERRORS"), 0);
            }
            System.exit(0);
        }
    }

    public static void removeLock() {
        if (_lockWriter != null) {
            try {
                _lockWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (_lockFile != null && !_lockFile.delete()) {
            _lockFile.deleteOnExit();
        }
    }

    public static boolean isLocked() {
        return _lockFile != null && _lockFile.exists();
    }
}

