/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.jxtautility;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.jxtautility.ConfigHelper;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkManager25;
import com.dassault.cecilia.lib.distrib.jxtautility.URIListUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.NetworkConfigurator;
import net.jxta.platform.NetworkManager;

public class NetworkStartUtility {
    private static final String HOSTNAME_REPLACE = "%hostname%";
    private static final String UNIQ_REPLACE = "%uniq%";
    private static ConfigHelper _configHelper;

    public static NetworkManager25 createManager() throws IOException {
        _configHelper = NetworkStartUtility.initFromProperties();
        NetworkStartUtility.cleanIfNeeded(_configHelper);
        NetworkManager25 netManager = new NetworkManager25(_configHelper);
        NetworkConfigurator config = netManager.getConfigurator();
        NetworkStartUtility.configure(config, _configHelper);
        return netManager;
    }

    public static void cleanIfNeeded(ConfigHelper config) {
        if (JXTAProperties.getBoolProperty("cecilia.jxta.clean.startup")) {
            FileDirDeletor jxta = new FileDirDeletor(config.getJxtaHome());
            jxta.deleteAll();
            Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, String.valueOf(ResJXTA.getString("GLOBAL_REMOVING")) + " " + config.getJxtaHome());
        }
    }

    public static ConfigHelper initFromProperties() {
        ConfigHelper helper = new ConfigHelper();
        String peerName = "NoName";
        try {
            String name = System.getProperty("cecilia.jxta.name", InetAddress.getLocalHost().getHostName()).trim();
            if (name.contains("\\") || name.contains("/") || name.contains(":") || name.contains("*") || name.contains("?") || name.contains("\"") || name.contains("<") || name.contains(">") || name.contains("|")) {
                Loggeur.log(NetworkStartUtility.class, Loggeur.ERROR, String.valueOf(ResJXTA.getString("CONFIG_WRONG_PEER_NAME")) + name);
            } else {
                if (name.contains(HOSTNAME_REPLACE)) {
                    name = name.replace(HOSTNAME_REPLACE, InetAddress.getLocalHost().getHostName());
                }
                if (name.contains(UNIQ_REPLACE)) {
                    name = name.replace(UNIQ_REPLACE, String.valueOf(System.currentTimeMillis()).substring(4));
                }
                peerName = name;
            }
        }
        catch (UnknownHostException e) {
            peerName = "Peer" + String.valueOf(System.currentTimeMillis());
        }
        helper.setPeerInstanceName(peerName);
        StringBuffer jxtaHomeSB = new StringBuffer(32);
        jxtaHomeSB.append(JXTAProperties.getDistributedDir());
        jxtaHomeSB.append(File.separator);
        jxtaHomeSB.append(".jxta");
        jxtaHomeSB.append(File.separator);
        helper.setJxtaHome(jxtaHomeSB.toString());
        try {
            String relayBase;
            URIListUtility.readFromFile(new File(jxtaHomeSB.toString(), "discovered.peer").getAbsolutePath());
            String relay = System.getProperty("cecilia.jxta.relayuri");
            if (relay != null) {
                URIListUtility.addAllUri(relay);
            }
            if ((relayBase = System.getProperty("cecilia.jxta.relayfile")) != null) {
                File relayFile = new File(relayBase);
                if (!relayFile.exists()) {
                    Loggeur.log(NetworkStartUtility.class, Loggeur.ERROR, ResJXTA.getString("CONFIG_WRONG_RELAYFILE"));
                } else {
                    URIListUtility.readFromFile(relayFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            Loggeur.log(NetworkStartUtility.class, Loggeur.ERROR, ResJXTA.getString("CONFIG_WRONG_RELAYFILE"));
        }
        helper.setRelayRDVList(URIListUtility.toIPList());
        String httpPort = System.getProperty("cecilia.jxta.config.http", "9700");
        String tcpPort = System.getProperty("cecilia.jxta.config.tcp", "9701");
        try {
            int http = Integer.parseInt(httpPort.trim());
            if (http < 10 || http > 65535) {
                throw new NumberFormatException();
            }
            helper.setHttpPort(http);
            Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, "http=" + http);
            int tcp = Integer.parseInt(tcpPort.trim());
            if (tcp < 10 || tcp > 65535) {
                throw new NumberFormatException();
            }
            helper.setTcpPort(tcp);
            Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, "tcp=" + tcp);
            if (tcp == http) {
                Loggeur.log(NetworkStartUtility.class, Loggeur.ERROR, ResJXTA.getString("CONFIG_SAME_PORT"));
            }
        }
        catch (NumberFormatException e) {
            Loggeur.log(NetworkStartUtility.class, Loggeur.ERROR, ResJXTA.getString("CONFIG_WRONG_PORT"));
        }
        if (JXTAProperties.getBoolProperty("cecilia.jxta.relay")) {
            helper.setMode(NetworkManager.ConfigMode.RENDEZVOUS);
        } else {
            helper.setMode(NetworkManager.ConfigMode.EDGE);
        }
        return helper;
    }

    public static void configure(NetworkConfigurator config, ConfigHelper helper) {
        assert (config.getHome().toURI().equals(helper.getInstanceHomeURI())) : config.getHome().toString();
        Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, "PeerName = " + helper.getPeerInstanceName());
        if (!config.exists()) {
            Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, ResJXTA.getString("CONFIG_FILE_CREATION"));
            config.setHttpEnabled(true);
            config.setHttpPort(helper.getHttpPort());
            config.setTcpEnabled(true);
            config.setTcpPort(helper.getTcpPort());
            config.setPeerID(IDFactory.newPeerID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID));
            config.setInfrastructureID((ID)PeerGroupID.defaultNetPeerGroupID);
            config.setName(helper.getPeerInstanceName());
            config.setDescription("");
            config.setPrincipal("DASSAULT");
            config.setPassword("CECILIA");
        } else {
            Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, ResJXTA.getString("CONFIG_FILE_USE"));
            try {
                File pc = new File(config.getHome(), "PlatformConfig");
                config.load(pc.toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            List<String> relayRDVList = helper.getRelayRDVList();
            config.setRendezvousSeedingURIs(relayRDVList);
            for (String uri : relayRDVList) {
                config.addSeedRendezvous(new URI(uri));
                Loggeur.log(NetworkStartUtility.class, Loggeur.INFO, "Relay=" + uri);
            }
        }
        catch (Exception e) {
            Loggeur.log(NetworkStartUtility.class, Loggeur.ERROR, ResJXTA.getString("CONFIG_WRONG_RELAYFILE"));
        }
        try {
            config.save();
        }
        catch (Exception io) {
            io.printStackTrace();
        }
    }
}

