/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.jxtautility;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIListUtility {
    private static ArrayList<String> uris = new ArrayList();
    private static final Pattern PATTERN_HOST = Pattern.compile("([a-zA-Z][a-zA-Z0-9\\.\\-]*)");
    private static final Pattern PATTERN_IP = Pattern.compile("([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})");
    private static final Pattern PATTERN_IPV6 = Pattern.compile("\\[([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}\\]");

    public static boolean readFromFile(String relayFile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(relayFile));
            String line = "";
            while ((line = br.readLine()) != null) {
                String uri = line.replace(" ", "");
                URIListUtility.addUri(uri);
            }
            br.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void saveURIsToFile(String relayFile) {
        try {
            FileWriter fw = new FileWriter(relayFile);
            for (String uri : uris) {
                String uriName = URIListUtility.getHostnameURI(uri);
                if (uriName != null) {
                    fw.write(uriName);
                } else {
                    fw.write(uri);
                }
                fw.write("\n");
                fw.flush();
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addUri(String uri) {
        switch (URIListUtility.verifyURI(uri)) {
            case BAD: {
                Loggeur.log(URIListUtility.class, Loggeur.ERROR, String.valueOf(ResJXTA.getString("CONFIG_WRONG_URI")) + uri);
            }
            case IPv6: {
                return;
            }
        }
        String ipURI = URIListUtility.getIPURI(uri);
        if (ipURI == null) {
            Loggeur.log(URIListUtility.class, Loggeur.ERROR, String.valueOf(ResJXTA.getString("CONFIG_UNKNOWN_HOST_URI")) + uri);
            return;
        }
        if (!uris.contains(ipURI)) {
            uris.add(ipURI);
        }
    }

    public static void addAllUri(List<String> uriList) {
        for (String uri : uriList) {
            URIListUtility.addUri(uri);
        }
    }

    public static boolean addAllUri(String uriList) {
        try {
            StringTokenizer st = new StringTokenizer(uriList, ",;");
            while (st.hasMoreElements()) {
                String uri = st.nextToken().trim();
                URIListUtility.addUri(uri);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> toIPList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String uri : uris) {
            list.add(uri);
        }
        return list;
    }

    public static URIState verifyURI(String uri) {
        int uriLght = uri.length();
        if (uriLght < 9) {
            return URIState.BAD;
        }
        int pp = uri.lastIndexOf(":");
        if (pp == -1 || pp > uriLght - 2) {
            return URIState.BAD;
        }
        try {
            String portSt = uri.substring(pp + 1, uriLght);
            int port = Integer.parseInt(portSt);
            if (port < 20 || port > 65535) {
                return URIState.BAD;
            }
        }
        catch (NumberFormatException e) {
            return URIState.BAD;
        }
        String ip_or_name = "";
        if (uri.substring(0, 6).equals("tcp://")) {
            ip_or_name = uri.substring(6, pp);
        } else if (uri.substring(0, 7).equals("http://")) {
            ip_or_name = uri.substring(7, pp);
        } else {
            return URIState.BAD;
        }
        if (URIListUtility.isIPv6Addr(ip_or_name)) {
            return URIState.IPv6;
        }
        if (URIListUtility.isIPAddr(ip_or_name) || URIListUtility.isHostName(ip_or_name)) {
            return URIState.IPv4;
        }
        return URIState.BAD;
    }

    public static boolean isHostName(String address) {
        return PATTERN_HOST.matcher(address).matches();
    }

    public static boolean isIPAddr(String addr) {
        Matcher matcher = PATTERN_IP.matcher(addr);
        if (!matcher.matches()) {
            return false;
        }
        int i = 1;
        while (i <= 4) {
            int bloc = Integer.parseInt(matcher.group(i));
            if (bloc > 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIPv6Addr(String addr) {
        Matcher matcher = PATTERN_IPV6.matcher(addr);
        return matcher.matches();
    }

    public static String getIPURI(String uri) {
        try {
            int indexSlash = uri.indexOf("/");
            int indexDeuxPoint = uri.indexOf(":", indexSlash);
            String host = uri.substring(indexSlash + 2, indexDeuxPoint);
            if (URIListUtility.isIPAddr(host)) {
                return uri;
            }
            String ip = URIListUtility.name2ipString(host);
            if (ip != null) {
                return uri.replace(host, ip);
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String getHostnameURI(String uri) {
        block4: {
            try {
                int indexDeuxPoint;
                if (!URIListUtility.isIPAddr(uri)) break block4;
                int indexSlash = uri.indexOf("/");
                String ip = uri.substring(indexSlash + 2, indexDeuxPoint = uri.indexOf(":", indexSlash));
                String name = URIListUtility.ip2name(ip);
                if (name != null) {
                    return uri.replace(ip, name);
                }
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return uri;
    }

    public static String name2ipString(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static byte[] name2ipByte(String hostName) {
        try {
            return InetAddress.getByName(hostName).getAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String ip2name(String IP) {
        byte[] addr = new byte[4];
        try {
            StringTokenizer st = new StringTokenizer(IP, ".");
            String bloc = st.nextToken();
            addr[0] = (byte)Integer.parseInt(bloc);
            bloc = st.nextToken();
            addr[1] = (byte)Integer.parseInt(bloc);
            bloc = st.nextToken();
            addr[2] = (byte)Integer.parseInt(bloc);
            bloc = st.nextToken();
            addr[3] = (byte)Integer.parseInt(bloc);
            if (st.hasMoreTokens()) {
                return null;
            }
        }
        catch (NoSuchElementException e) {
            return null;
        }
        return URIListUtility.ip2name(addr);
    }

    public static String ip2name(byte[] IP) {
        try {
            return InetAddress.getByAddress(IP).getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        URIListUtility.addAllUri("tcp://192.168.4.200:3001 http://192.168.4.200:3003");
    }

    static enum URIState {
        BAD,
        IPv4,
        IPv6;

    }
}

