/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.log;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Loggeur {
    public static final Level FATAL = Level.SEVERE;
    public static final Level ERROR = Level.SEVERE;
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level CONFIG = Level.CONFIG;
    public static final Level DEBUG = Level.FINE;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level FINEST = Level.FINEST;
    private static boolean _loaded = false;
    private static boolean _logOnConsole = false;
    private static final String DEFAULT_LOG_PROP = "log.properties";

    public static void loadConfig() {
        String initializedLogger = null;
        Enumeration<String> enumerator = LogManager.getLogManager().getLoggerNames();
        while (enumerator.hasMoreElements()) {
            String name = enumerator.nextElement();
            if (name == null || name.length() == 0 || name.equals("global")) continue;
            initializedLogger = name;
            break;
        }
        if (initializedLogger != null) {
            Logger.getLogger(Loggeur.class.getName()).info("LogManager already initialized : " + initializedLogger);
            return;
        }
        if (System.getProperty("java.util.logging.config.file") == null) {
            System.setProperty("java.util.logging.config.file", DEFAULT_LOG_PROP);
        }
        LogManager.getLogManager().reset();
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (SecurityException e) {
            System.err.println(e.getMessage());
            _logOnConsole = true;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            _logOnConsole = true;
        }
    }

    public static void log(Class classe, Level level, Object txt) {
        if (!_loaded) {
            Loggeur.loadConfig();
            _loaded = true;
        }
        if (_logOnConsole) {
            StringBuffer sb = new StringBuffer();
            sb.append(new Date(System.currentTimeMillis()).toString());
            sb.append(" ");
            sb.append(txt.toString());
            System.out.println(sb.toString());
        } else if (txt instanceof Throwable) {
            Loggeur.getJavaLogger(classe).log(level, txt.toString(), (Throwable)txt);
        } else {
            Loggeur.getJavaLogger(classe).log(level, txt.toString());
        }
    }

    private static Logger getJavaLogger(Class classe) {
        Logger logg = Logger.getLogger(classe.getName());
        return logg;
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("Super nom de Thread");
        Loggeur.log(Loggeur.class, CONFIG, "---------CONFIG LOG ------");
        Loggeur.log(Loggeur.class, ERROR, "---------SEVERE LOG ------");
        Loggeur.log(Loggeur.class, DEBUG, "---------FINE LOG ------");
        Loggeur.log(Loggeur.class, WARNING, "---------WARN LOG ------");
        Loggeur.log(Loggeur.class, FINER, "---------FINER LOG ------");
        Loggeur.log(Loggeur.class, INFO, "---------INFO LOG ------");
        Loggeur.log(Loggeur.class, FINEST, "---------FINEST LOG ------");
        System.out.println("Verifier que le consoleHandler est bien positionner");
    }
}

