/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoAppList;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServersApp;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.ihm.IHMAdmin;
import com.dassault.cecilia.lib.distrib.jxtautility.LockUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAConnectedToServers;
import com.dassault.cecilia.lib.distrib.peers.PeerAdmin;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminManagerAdmin;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.Message;

public class CECILIAAdmin
extends CECILIAConnectedToServers {
    protected static CECILIAAdmin _singletonAdmin;
    protected PeerAdmin _peerAdmin = new PeerAdmin(this);
    protected String _shortID;

    private CECILIAAdmin() {
        this._serversApp = new InfoServersApp();
        this._admManager = new AdminManagerAdmin(this);
    }

    public static synchronized CECILIAAdmin getAdmin() {
        if (_singletonAdmin == null) {
            LockUtility.createLock(true);
            _singletonAdmin = new CECILIAAdmin();
            _singletonAdmin.init();
            IHMAdmin frame = new IHMAdmin(!Boolean.getBoolean("cecilia.jxta.admin.enable"));
            frame.init(_singletonAdmin);
            frame.setVisible(true);
        }
        return _singletonAdmin;
    }

    public static boolean isActive() {
        return _singletonAdmin != null;
    }

    private void init() {
        this._peerAdmin.startJxta();
        this._shortID = this.createShortPeerID(this._peerAdmin.getPeerIDString());
        this.createInfosServersApp();
        this.periodicKeepAliveConnection();
    }

    private void createInfosServersApp() {
        int delai;
        this._serversApp.clear();
        Iterator<InfoPeerJXTA> it = this._peerAdmin.remotePeerIterator();
        while (it.hasNext()) {
            InfoPeerJXTA peer = it.next();
            if (!peer.getType().equals("SERVER") || peer.getStatus() != 1) continue;
            InfoServerApp serverApp = new InfoServerApp(peer);
            peer.addChangeListener(this);
            this._serversApp.addServer(serverApp);
        }
        this.remoteAskInfo();
        StringBuffer sb = new StringBuffer();
        sb.append(ResJXTA.getString("AVAILABLE_APP_SERVEUR"));
        sb.append("\n");
        sb.append(this._serversApp.toString());
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
        if (this.getServersApp().size() == 0 && (delai = Integer.getInteger("cecilia.jxta.search.delay.noserver", 10000).intValue()) >= 0) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, ResJXTA.msgFormat("NETWORK_SCAN_FINISHED_WITHOUT_PEER", delai / 1000));
            Timer refreshNetWorkSoon = new Timer("SCAN ASAP", true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (CECILIAAdmin.this.getServersApp().size() > 0) {
                        return;
                    }
                    CECILIAAdmin.this.refreshNetwork();
                }
            };
            refreshNetWorkSoon.schedule(task, delai);
        }
    }

    public void refreshNetwork() {
        this.remoteAskInfo();
        ArrayList<InfoPeerJXTA> toBeTrashed = this._peerAdmin.refreshNetwork();
        for (InfoPeerJXTA peerJXTA : toBeTrashed) {
            String peerID = peerJXTA.getPeerIDString();
            if (peerID == null) continue;
            this._serversApp.removeServer(this._serversApp.getServer(peerJXTA.getPeerIDString()));
        }
        this.createInfosServersApp();
    }

    @Override
    public void remoteAskInfo() {
        long time = System.currentTimeMillis();
        try {
            boolean everybobyReplied = false;
            int accelaration = 3;
            int chance = 0;
            while (chance < 2) {
                this.remoteAskInfoMsg();
                int count = 0;
                while (count < accelaration) {
                    Thread.sleep(6000 / accelaration);
                    Iterator<InfoServerApp> serveurs = this._serversApp.iterator();
                    everybobyReplied = true;
                    while (serveurs.hasNext()) {
                        InfoServerApp infoServerApp = serveurs.next();
                        if (infoServerApp.getLastInfoTime() >= time) continue;
                        everybobyReplied = false;
                        break;
                    }
                    if (everybobyReplied) {
                        return;
                    }
                    ++count;
                }
                ++chance;
            }
            this._serversApp.setOfLineServersOlderThan(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void remoteAskInfoMsg() {
        Iterator<InfoServerApp> it = this._serversApp.iterator();
        while (it.hasNext()) {
            InfoServerApp server = it.next();
            this._admManager.remoteAskForInfo(server.getPeerID());
        }
    }

    public void remoteStopRequest(Request req) {
        this._admManager.remoteStopRequest(req);
    }

    public void remoteStopRequests() {
        this._admManager.remoteStopAllRequest();
    }

    public void remoteStopRequests(InfoServerApp server) {
        this._admManager.remoteStopAllRequest(server);
    }

    public void remoteStopRequestsFromClient(InfoPeerJXTA client) {
        this.getAdminManagerAdmin().remoteStopAllRequestClient(client);
    }

    public void remoteChangePriorityClient(InfoPeerJXTA client, int newPrio) {
        this.getAdminManagerAdmin().remoteChangePriorityClient(client, newPrio);
    }

    public void remoteShutdown(InfoPeerJXTA peer) {
        this.getAdminManagerAdmin().remoteShutDown(peer);
    }

    public void remoteChangeServerEngines(InfoPeerJXTA peer, String[] newEngines) {
        this.getAdminManagerAdmin().remoteChangeServerEngine(peer, newEngines);
    }

    private AdminManagerAdmin getAdminManagerAdmin() {
        return (AdminManagerAdmin)this._admManager;
    }

    private String createShortPeerID(String peerID) {
        StringTokenizer st = new StringTokenizer(peerID, "-");
        st.nextToken();
        return st.nextToken();
    }

    @Override
    public PeerJXTA getPeerJXTA() {
        return this._peerAdmin;
    }

    public void manageAdminMessage(Message message, MessageInfoAnalyser info) {
        this._admManager.manageAdminMessage(message, info);
    }

    public InfoServersApp getServersApp() {
        return this._serversApp;
    }

    @Override
    public InfoAppList getRemoteAppList() {
        return this.getServersApp();
    }

    public int numberServer() {
        return this._serversApp.getNumberOfOKServer();
    }

    @Override
    public void printInfo(String s) {
        Loggeur.log(this.getClass(), Loggeur.INFO, s);
    }

    @Override
    public void printError(String s) {
        Loggeur.log(this.getClass(), Loggeur.ERROR, s);
    }

    public static void main(String[] args) {
        JXTAProperties.initLaunchIni();
        CECILIAAdmin admin = CECILIAAdmin.getAdmin();
        try {
            do {
                Thread.sleep(1000L);
            } while (!admin.getPeerJXTA().isStopped());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    @Override
    public void peerStatusChange(String peerID, int oldStatus, int newStatus, PeerChangeListener.Reason reason) {
        InfoServerApp serverApp = this._serversApp.getServer(peerID);
        if (serverApp == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(ResJXTA.getString("NETWORK_ERROR")) + peerID);
            return;
        }
        if (oldStatus == 1 && newStatus == 0) {
            this._serversApp.removeServer(serverApp);
            this._peerAdmin.removeRemote(serverApp.getPeerJXTA());
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this._peerAdmin.stop();
        LockUtility.removeLock();
    }
}

