/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.AraliaPreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.compute.ClientProcessor;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.compute.CxuComputor;
import com.dassault.cecilia.lib.distrib.compute.PreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoAppList;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServersApp;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.entityinfo.RemoteServerChangeListener;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileSender;
import com.dassault.cecilia.lib.distrib.filetransfert.FileCopy;
import com.dassault.cecilia.lib.distrib.filetransfert.FileNameUtility;
import com.dassault.cecilia.lib.distrib.ihm.IHMClient;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.LockUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAConnectedToServers;
import com.dassault.cecilia.lib.distrib.peers.MessagePrinter;
import com.dassault.cecilia.lib.distrib.peers.PeerClient;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.Command;
import com.dassault.cecilia.lib.distrib.request.CommandFileWriter;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqChangeListener;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.ReqSurveyorClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminManagerClient;
import com.dassault.cecilia.lib.distrib.requestManagement.DistributorClient;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestReceiverClient;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStockClient;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestTrash;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLMessageCreator;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JFrame;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;

public class CECILIAClient
extends CECILIAConnectedToServers
implements MessagePrinter,
RemoteServerChangeListener,
ReqChangeListener {
    private static ThreadLocal<Boolean> __singletonClientLocal = new ThreadLocal();
    private static short __singletonClientShutdown = 0;
    protected static CECILIAClient _singletonClient;
    private Object _peerClientMutex = new Object();
    protected PeerClient _peerClient;
    protected int _fileCounter = 0;
    protected int _requestCounter = 0;
    protected Map<String, String> _fileNamesMap;
    protected String _shortID;
    protected RequestStockClient _stock;
    protected RequestTrash _trash;
    protected DistributorClient _distributor;
    protected ClientProcessor _preprocessor;
    protected RequestReceiverClient _reqManager;
    protected IHMClient _ihm;
    private boolean _ready = false;
    static List<DistribClientListener> _distribClientListeners;
    private List<InfoPeerJXTA> _connexionRefusedPeers = new ArrayList<InfoPeerJXTA>();
    private String mutexNextID = "mutexNextID";
    private String mutexFileCount = "mutexFileCount";

    static {
        _distribClientListeners = new ArrayList<DistribClientListener>();
    }

    public static synchronized CECILIAClient getCECILIAClient() {
        return CECILIAClient.getCECILIAClient(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CECILIAClient getCECILIAClient(boolean bloquant) {
        if (__singletonClientLocal.get() != null) return _singletonClient;
        Class<CECILIAClient> clazz = CECILIAClient.class;
        synchronized (CECILIAClient.class) {
            if (_singletonClient == null) {
                LockUtility.createLock(true);
                _singletonClient = new CECILIAClient();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        _singletonClient.shutdown();
                    }
                });
                _singletonClient.init(bloquant);
            }
            __singletonClientLocal.set(Boolean.TRUE);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _singletonClient;
        }
    }

    public static boolean isActive() {
        return _singletonClient != null;
    }

    public static void addDistribClientListener(DistribClientListener listener) {
        if (!_distribClientListeners.contains(listener)) {
            _distribClientListeners.add(listener);
        }
    }

    public static void removeDistribClientListener(DistribClientListener listener) {
        _distribClientListeners.remove(listener);
    }

    public static boolean withOneOrMoreDistribClient() {
        return _distribClientListeners.size() > 0;
    }

    protected CECILIAClient() {
        this._stock = new RequestStockClient();
        this._trash = new RequestTrash();
        this._fileNamesMap = new HashMap<String, String>();
        this._peerClient = new PeerClient(this);
        this._serversApp = new InfoServersApp();
        this._distributor = new DistributorClient(this);
        this._preprocessor = new ClientProcessor(this);
        this._admManager = new AdminManagerClient(this);
        this._reqManager = new RequestReceiverClient(this._stock, this);
    }

    private void init(boolean bloquant) {
        if (bloquant) {
            this.initReal();
        } else {
            new Thread("DISTRIB-CLIENT-LAUNCH"){

                @Override
                public void run() {
                    CECILIAClient.this.initReal();
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReal() {
        Object object = this._peerClientMutex;
        synchronized (object) {
            this._peerClient.startJxta();
        }
        object = this._peerClientMutex;
        synchronized (object) {
            this._shortID = this.createShortPeerID(this._peerClient.getPeerIDString());
            this.createInfosServersApp();
            this.addPreprocessors();
            this._distributor.start();
            this._peerClient.periodicDisplayRemote();
            if (JXTAProperties.getBoolProperty("cecilia.jxta.ihm") && __singletonClientShutdown == 0) {
                this.displayIHM(null, false);
            }
            this._ready = true;
        }
        if (Boolean.getBoolean("cecilia.jxta.temp.empty.startup")) {
            FileDirDeletor.emptyDir(JXTAProperties.getTempDir());
        }
        if (this.getServersApp().size() == 0) {
            int delai = Integer.getInteger("cecilia.jxta.search.delay.noserver", 10000);
            Loggeur.log(this.getClass(), Loggeur.WARNING, ResJXTA.msgFormat("NETWORK_SCAN_FINISHED_WITHOUT_PEER", delai / 1000));
            Timer refreshNetWorkSoon = new Timer("SCAN ASAP", true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (__singletonClientShutdown > 0) {
                        return;
                    }
                    if (CECILIAClient.this.getServersApp().size() > 0) {
                        return;
                    }
                    CECILIAClient.this.refreshNetwork();
                }
            };
            refreshNetWorkSoon.schedule(task, delai);
        }
        this.periodicKeepAliveConnection();
    }

    public List<InfoPeerJXTA> getConnexionRefusedPeer() {
        return this._connexionRefusedPeers;
    }

    private void createInfosServersApp() {
        StringBuffer sb;
        HashMap<String, Boolean> toBeUsed = new HashMap<String, Boolean>();
        Iterator<InfoServerApp> olds = this._serversApp.iterator();
        while (olds.hasNext()) {
            InfoServerApp infoServerApp = olds.next();
            toBeUsed.put(infoServerApp.getPeerID(), infoServerApp.shouldBeUsed());
        }
        this._serversApp.clear();
        this._connexionRefusedPeers.clear();
        Iterator<InfoPeerJXTA> it = this._peerClient.remotePeerIterator();
        while (it.hasNext()) {
            InfoPeerJXTA peer = it.next();
            if (!peer.getType().equals("SERVER") || peer.getStatus() != 1) continue;
            if (!peer.isGoodVersion()) {
                sb = new StringBuffer();
                sb.append(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN_WRONG_VERSION_MESSAGE"));
                sb.append(" ");
                sb.append(peer.getName());
                sb.append(" ");
                sb.append(peer.getVersion());
                Loggeur.log(NetworkUtility.class, Loggeur.WARNING, sb.toString());
                this._connexionRefusedPeers.add(peer);
                continue;
            }
            if (!this._peerClient.isAuthorized(peer, true)) {
                sb = new StringBuffer();
                sb.append(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN_MESSAGE"));
                sb.append(" ");
                sb.append(peer.getName());
                sb.append(" ");
                sb.append(peer.getVersion());
                Loggeur.log(NetworkUtility.class, Loggeur.WARNING, sb.toString());
                this._connexionRefusedPeers.add(peer);
                continue;
            }
            InfoServerApp serverApp = new InfoServerApp(peer);
            peer.addChangeListener(this);
            serverApp.addChangeListener(this);
            this._serversApp.addServer(serverApp);
        }
        this.remoteAskInfo();
        Iterator<InfoServerApp> news = this._serversApp.iterator();
        while (news.hasNext()) {
            InfoServerApp infoServerApp = news.next();
            Boolean mustBeUsed = (Boolean)toBeUsed.get(infoServerApp.getPeerID());
            if (mustBeUsed == null) continue;
            infoServerApp.setToBeUSed(mustBeUsed);
        }
        sb = new StringBuffer();
        sb.append(ResJXTA.getString("AVAILABLE_APP_SERVEUR"));
        sb.append("\n");
        sb.append(this._serversApp.toString());
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
    }

    public void refreshNetwork() {
        this.waitReady();
        if (this._stock.size() > 0) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, ResJXTA.getString("NETWORK_SCAN_ANALYSE"));
        }
        this._distributor.stopDistributor();
        this.remoteAskInfo();
        ArrayList<InfoPeerJXTA> toBeTrashed = this._peerClient.refreshNetwork();
        for (InfoPeerJXTA peerJXTA : toBeTrashed) {
            String peerID = peerJXTA.getPeerIDString();
            if (peerID == null) continue;
            this._serversApp.removeServer(this._serversApp.getServer(peerJXTA.getPeerIDString()));
        }
        this.createInfosServersApp();
        this._distributor.startDistributor();
    }

    public void pauseDistribution() {
        this._distributor.stopDistributor();
    }

    public void resumeDistribution() {
        this._distributor.startDistributor();
    }

    public Request getNewRequest() {
        this.waitReady();
        Request req = new Request(this.getNextRequestID());
        req.addChangeListener(this);
        req.setClientID(this._peerClient.getPeerIDString());
        return req;
    }

    public Command getCommandWriter(Request req) {
        return new Command(this, req);
    }

    public CommandFileWriter CommandFileWriter(Request req) throws IOException {
        return new CommandFileWriter(this, req);
    }

    public void addRequestToStock(Request req) {
        this.waitReady();
        if (!req.isParsed()) {
            if (!this._preprocessor.isEngineOK(req)) {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.NEW_2_PREPROCESS_ERROR);
                return;
            }
            if (!this._preprocessor.preProcess(req)) {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.NEW_2_PREPROCESS_ERROR);
                return;
            }
            req.setParsed(true);
        }
        this._stock.addRequest(req);
    }

    public void cancelRequest(final Request req, boolean stop) {
        new Thread(){

            @Override
            public void run() {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_USER);
                CECILIAClient.this._admManager.remoteStopRequest(req);
            }
        }.start();
    }

    public void cancelAllRequest(boolean bloquant) {
        Loggeur.log(this.getClass(), Loggeur.INFO, "Cancel all request (bloquant=" + bloquant + ")");
        Thread cancelTh = new Thread("DISTRIB-CLIENT-CANCELALLREQUEST"){

            @Override
            public void run() {
                Request req = null;
                while ((req = CECILIAClient.this._stock.getNextRequest()) != null) {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_USER);
                }
                CECILIAClient.this._admManager.remoteStopAllRequest();
            }
        };
        if (bloquant) {
            cancelTh.run();
        } else {
            cancelTh.start();
        }
    }

    public void relaunchRequest(Request req) {
        this.remoteStopRequest(req);
        req.setServerID("");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.RELAUNCH);
    }

    public void remoteStopRequest(Request req) {
        this._admManager.remoteStopRequest(req);
    }

    public void remoteStopRequests() {
        this._admManager.remoteStopAllRequest();
    }

    public void remoteStopRequests(InfoServerApp server) {
        this._admManager.remoteStopAllRequest(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextRequestID() {
        this.waitReady();
        String string = this.mutexNextID;
        synchronized (string) {
            String reqID = Request.createName(this._shortID, this._requestCounter);
            ++this._requestCounter;
            return reqID;
        }
    }

    public String getPertinentInfo(Request req) {
        StringBuffer sb = new StringBuffer();
        switch (req.getState()) {
            case TOO_MANY_ERRORS: {
                sb.append(req.getHisto().getIemeState(req.getHisto().size() - 2).getDesc());
                int err = req.getGeneratedError();
                if (err == 0) break;
                sb.append(" (");
                sb.append(this._preprocessor.createMessage(req.getEngine(), err));
                sb.append(")");
                break;
            }
            default: {
                sb.append(req.getHisto().getIemeState(req.getHisto().size() - 1).getDesc());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeUniqueFileID(String fullPathName, boolean forDiffuseFile) {
        this.waitReady();
        String string = this.mutexFileCount;
        synchronized (string) {
            ++this._fileCounter;
            String uniqueName = FileNameUtility.createName(this._shortID, this._fileCounter, forDiffuseFile);
            this._fileNamesMap.put(uniqueName, fullPathName);
            return uniqueName;
        }
    }

    private String createShortPeerID(String peerID) {
        StringTokenizer st = new StringTokenizer(peerID, "-");
        st.nextToken();
        return st.nextToken();
    }

    public String getShortID() {
        return this._shortID;
    }

    public MessageElement createInfoElement() {
        HashMap<String, String> attMap = new HashMap<String, String>();
        attMap.put("STOCKSIZE", String.valueOf(this._stock.getNbOfRequest(ReqState.WAIT_COMPUTING)));
        XMLMessageCreator messageXML = new XMLMessageCreator();
        messageXML.addEntity("STATRESPONSE", attMap, null);
        StringMessageElement elt = new StringMessageElement("STATRESPONSE", messageXML.toString(), null);
        return elt;
    }

    protected void addPreprocessors() {
        Object ban;
        Class<?> cl;
        this._preprocessor.addComputor("TESTFILE", new CxuComputor());
        this._preprocessor.addComputor("ARALIA", new AraliaPreAndPostProcessor(this));
        this._preprocessor.addComputor("ARALIA4", new AraliaPreAndPostProcessor(this));
        this._preprocessor.addComputor("CECILIABDD", new AraliaPreAndPostProcessor(this));
        try {
            Class.forName("com.dassault.cecilia.lib.ban.BanProcessListener");
            cl = Class.forName("com.dassault.cecilia.lib.distrib.compute.BANExternalPreAndPostProcessor");
            ban = (PreAndPostProcessor)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._preprocessor.addComputor("BAN", (PreAndPostProcessor)ban);
        }
        catch (Throwable e) {
            Loggeur.log(this.getClass(), Loggeur.FINE, e);
        }
        try {
            Class.forName("com.dassault.cecilia.lib.ban.BanProcessListener");
            cl = Class.forName("com.dassault.cecilia.lib.distrib.compute.BANComputor");
            ban = (Computor)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._preprocessor.addComputor("iBAN", (PreAndPostProcessor)ban);
        }
        catch (Throwable e) {
            Loggeur.log(this.getClass(), Loggeur.FINE, e);
        }
        Loggeur.log(this.getClass(), Loggeur.INFO, "JXTAClientCompute: " + this._preprocessor.toString());
    }

    public boolean diffuseFile(File f, String uniqueName) {
        block8: {
            this.waitReady();
            this.remoteAskInfo();
            Loggeur.log(this.getClass(), Loggeur.INFO, "Diffuse " + f.getAbsolutePath() + " aka " + uniqueName);
            try {
                if (f.exists()) break block8;
                Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(f.getAbsolutePath()) + " not found");
                return false;
            }
            catch (SecurityException e) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
                return false;
            }
        }
        if (!f.canRead()) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(f.getAbsolutePath()) + " not readable");
            return false;
        }
        Iterator<InfoServerApp> it = this._serversApp.iterator();
        boolean everythingOK = true;
        while (it.hasNext()) {
            InfoServerApp server = it.next();
            if (!server.canBeUsedForComputation()) continue;
            try {
                ByteFileSender.sendFileTo(f, uniqueName, this._peerClient.getPeerIDString(), server.getPeerJXTA());
            }
            catch (DistribException e) {
                everythingOK = false;
                if (e.getMessage().equals("Problem while reading file")) {
                    this.printError("I/O Erreur sur un fichier : " + e.getFilename() + ", impossible d'envoyer les fichiers au serveur " + server.getName());
                    continue;
                }
                if (!e.getMessage().equals("Problem while communicating with peer")) continue;
                this.printError("Erreur reseau, lors de l'envoie a " + server.getName());
            }
        }
        return everythingOK;
    }

    public void removeDiffusedFiles(String uniqueFileName) {
        this._admManager.removeDiffusedFiles(uniqueFileName);
    }

    @Override
    public void printError(String s) {
        Loggeur.log(this.getClass(), Loggeur.ERROR, s);
    }

    public boolean copyResultFiles(Request req) {
        for (String uniqueName : req.getResultFiles()) {
            String localName = this.getLocalFileName(uniqueName);
            try {
                FileCopy.copyFile(new File(JXTAProperties.getTempDir(), uniqueName), new File(localName));
            }
            catch (Exception e) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
                return false;
            }
        }
        return true;
    }

    public String getLocalFileName(String uniqueFileName) {
        String result = this._fileNamesMap.get(uniqueFileName);
        return result;
    }

    public RequestStockClient getRequestStock() {
        return this._stock;
    }

    public void waitEmptyStock() {
        while (this._stock.size() != 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public RequestTrash getRequestTrash() {
        return this._trash;
    }

    public void waitEmptyTrash() {
        while (this._trash.size() != 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void waitReady() {
        while (!this._ready) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PeerJXTA getPeerJXTA() {
        return this._peerClient;
    }

    public void manageAdminMessage(Message message, MessageInfoAnalyser info) {
        this._admManager.manageAdminMessage(message, info);
    }

    public void manageCeciliaResponseMessage(Message message, MessageInfoAnalyser info) {
        this._reqManager.manageCeciliaResponseMessage(message, info);
    }

    public void manageCeciliaIssueMessage(Message message, MessageInfoAnalyser info) {
        this._reqManager.manageCeciliaIssueMessage(message, info);
    }

    public void manageStateMessage(MessageInfoAnalyser info) {
        this._reqManager.manageStateMessage(info);
    }

    public InfoServersApp getServersApp() {
        return this._serversApp;
    }

    @Override
    public InfoAppList getRemoteAppList() {
        return this.getServersApp();
    }

    public int numberServer() {
        return this._serversApp.getNumberOfOKServer();
    }

    @Override
    public void requestStateChange(Request req, ReqState oldState, ReqState newState) {
        try {
            ReqSurveyorClient surveyor;
            InfoServerApp remoteServer = this._serversApp.getServer(req.getServerID());
            if (ReqAutomatonClient.isAbsorbantState(newState)) {
                this._stock.removeRequest(req);
                req.deleteResultFiles();
                String tmpCmdFile = this.getLocalFileName(req.getCmdFileName());
                if (tmpCmdFile != null) {
                    FileDirDeletor.deleteIfNotDir(new File(tmpCmdFile));
                }
                this._trash.add(req);
            }
            if (ReqAutomatonClient.mustBeReportedToRemote(newState)) {
                this._distributor.remoteSendRequestStatus(req);
            }
            if (newState == ReqState.ENGINE_ERROR || newState == ReqState.WRONG_RESULT) {
                this._preprocessor.manageRequestError(req);
            } else if (newState == ReqState.SENDING_RESULT) {
                surveyor = new ReqSurveyorClient(req, Integer.getInteger("cecilia.jxta.filetransfert.timeout", 1800000));
                surveyor.assertFalseIn(ReqState.SENDING_RESULT, null, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
                surveyor.setFailText("ReceivingTimeOut");
                surveyor.start();
            } else if (newState == ReqState.RESULTS_TRANSFERT_ERROR) {
                if (req.getHisto().countTmpErr() <= 3) {
                    surveyor = new ReqSurveyorClient(req, Integer.getInteger("cecilia.jxta.filetransfert.timeout", 1800000));
                    surveyor.assertFalseIn(ReqState.RESULTS_TRANSFERT_ERROR, null, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
                    surveyor.setFailText("TransfertTimeOut");
                    surveyor.start();
                } else {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
                }
            } else if (newState == ReqState.MISSING_FILE_TO_COMPUTE) {
                if (req.getHisto().countTmpErr() <= 3) {
                    req.relaunch();
                } else {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
                }
            } else if (newState == ReqState.SERVER_DOESNT_HAVE_ENGINE) {
                if (remoteServer != null) {
                    remoteServer.removeEngine(req.getEngine());
                } else {
                    Loggeur.log(this.getClass(), Loggeur.DEBUG, "Unknown remote server");
                }
                req.relaunch();
            } else if (newState == ReqState.NETWORK_DISCONNECT) {
                req.relaunch();
            } else if (newState == ReqState.RESULT_SENT) {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.RESULT_SENT_2_COPYING_RESULT);
                if (this.copyResultFiles(req)) {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.COPYING_RESULT_2_SPECIFIC_THREATMENT);
                } else {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.COPYING_RESULT_2_COPYING_ERROR);
                }
            } else if (newState == ReqState.SPECIFIC_THREATMENT) {
                if (this._preprocessor.doSpecificThreatment(req)) {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SPECIFIC_THREATMENT_2_FINISHED_SUCCESFULY);
                } else {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SPECIFIC_THREATMENT_2_SPECIFIC_THREATMENT_ERROR);
                }
            } else if (newState == ReqState.FINISHED_SUCCESFULY) {
                if (remoteServer != null) {
                    this.printInfo(MessageFormat.format(ResJXTA.getString("REQUEST_FINISHED"), req.getShortNumber(), remoteServer.getName()));
                } else {
                    this.printError(MessageFormat.format(ResJXTA.getString("REQUEST_FINISHED"), req.getShortNumber(), "null"));
                }
            }
        }
        catch (ReqAutomatonException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void fireFileArrived(Request req, String fileArrived) {
        req.fileIsArrived(fileArrived);
        if (req.allFilesArrived()) {
            ReqSurveyorClient surveyor = new ReqSurveyorClient(req, 6000);
            surveyor.assertFalseIn(ReqState.SENDING_RESULT, null, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_RESULTS_TRANFERT_ERROR);
            surveyor.setFailText("FileArrived surveyor");
            surveyor.start();
        }
    }

    @Override
    public void stockSizeChange(String peerID, int oldSize, int newSize) {
        InfoServerApp serverApp = this._serversApp.getServer(peerID);
        if (serverApp == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.getString("ADMIN_STOCK_FOR_UNKNOWN_SERVER"));
            return;
        }
        if (newSize == 0) {
            this.printInfo("Le serveur " + serverApp.getName() + " n'a plus de requetes a executer !!!!");
            if (this._stock.getNbOfRequest(ReqState.NEW) < this._serversApp.getNumberOfOKServer()) {
                this._distributor.redistribReqToServer(serverApp, 1);
            } else {
                this.printInfo("inutile de redistribuer, il reste encore des NEW");
            }
        }
    }

    @Override
    public boolean engineErrorCountChange(String peerID, int oldCount, int newCount) {
        if (newCount > Integer.MAX_VALUE) {
            InfoServerApp serverApp = this._serversApp.getServer(peerID);
            serverApp.setToBeUSed(false);
            this.printInfo(MessageFormat.format(ResJXTA.getString("ENGINE_TOO_MANY_ERROR"), serverApp.getName()));
            this.redistribReqOfServer(serverApp);
            this._serversApp.removeServer(serverApp);
            return false;
        }
        return true;
    }

    public void redistribReqOfServer(InfoServerApp serverApp) {
        this._distributor.redistribReqOfServer(serverApp);
    }

    @Override
    public void peerStatusChange(String peerID, int oldStatus, int newStatus, PeerChangeListener.Reason reason) {
        InfoServerApp serverApp = this._serversApp.getServer(peerID);
        if (serverApp == null) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Status change for null");
            return;
        }
        if (oldStatus == 1 && newStatus == 0) {
            this.printInfo("Le serveur " + serverApp.getName() + " n'est plus considere comme etant en ligne");
            this.printInfo("Reason = " + reason.name());
            this._serversApp.removeServer(serverApp);
            InfoPeerJXTA peer = serverApp.getPeerJXTA();
            this._peerClient.removeRemote(peer);
            if (peer != null) {
                peer.closeConnection();
            }
            Request req = null;
            while ((req = this._stock.getNextRequestFor(serverApp.getPeerID())) != null) {
                req.setServerID("");
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.NETWORK_DISCONNECT);
            }
        }
    }

    @Override
    public void printInfo(String s) {
        Loggeur.log(this.getClass(), Loggeur.INFO, s);
    }

    @Override
    public void serveurListChange() {
    }

    public void displayIHM(JDialog parent) {
        if (this._ihm != null) {
            this._ihm.setVisible(false);
            this._ihm.dispose();
        }
        this._ihm = new IHMClient(parent);
        this._ihm.init(_singletonClient);
        this._ihm.setVisible(true);
    }

    public void displayIHM(JFrame parent, boolean isModal) {
        if (this._ihm != null) {
            this._ihm.setVisible(false);
            this._ihm.dispose();
        }
        this._ihm = new IHMClient(parent);
        this._ihm.init(_singletonClient);
        this._ihm.setModal(isModal);
        this._ihm.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Loggeur.log(this.getClass(), Loggeur.DEBUG, "Client shutdown call");
        Class<CECILIAClient> clazz = CECILIAClient.class;
        synchronized (CECILIAClient.class) {
            if (__singletonClientShutdown == 0) {
                __singletonClientShutdown = 1;
                Object object = this._peerClientMutex;
                synchronized (object) {
                    Loggeur.log(this.getClass(), Loggeur.DEBUG, "Client shutdown realized");
                    super.shutdown();
                    this._peerClient.stop();
                }
                LockUtility.removeLock();
            }
            __singletonClientShutdown = (short)2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static interface DistribClientListener {
        public void callbackSearchServer();
    }
}

