/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Command {
    protected StringBuffer _sb;
    protected CECILIAClient _client;
    protected Request _req;
    protected File tmpCmdFile;
    protected String uniqueFileName;

    public Command(CECILIAClient client, Request req) {
        try {
            this.tmpCmdFile = File.createTempFile("tmp", ".cmd", JXTAProperties.getTempDir());
            this.tmpCmdFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.uniqueFileName = client.makeUniqueFileID(this.tmpCmdFile.getAbsolutePath(), false);
        this._sb = new StringBuffer(64);
        this._client = client;
        this._req = req;
    }

    public void append(String s) {
        this._sb.append(s);
    }

    public void addInputFile(File file) {
        String uniqueName = this._client.makeUniqueFileID(file.getAbsolutePath(), false);
        this._req.addNeededFile(uniqueName);
        this._sb.append(uniqueName);
    }

    public void addOutputFile(File file) {
        String uniqueName = this._client.makeUniqueFileID(file.getAbsolutePath(), false);
        this._req.addResultFile(uniqueName);
        this._sb.append(uniqueName);
    }

    public String toString() {
        return this._sb.toString();
    }

    public String getFileName() {
        try {
            FileWriter fw = new FileWriter(this.tmpCmdFile);
            fw.write(this._sb.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.uniqueFileName;
    }
}

