/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.filetransfert.FileNameUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.AppPeer;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminMessageCreator;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.io.File;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;

public abstract class AdminManager {
    public static final int CANCEL_ONE_REQUEST = 1;
    public static final int CANCEL_ALL_REQUESTS_OF_CLIENT = 8;
    public static final int INFODEMANDE = 5;
    public static final int INFORESPONSE = 6;
    public static final int REMOVEFILE = 9;
    public static final int CONNECTION_REFUSED = 20;
    public static final int CONNECTION_GRANTED = 21;
    public static final int CANCELADMIN_ONE_REQUEST = 22;
    public static final int CANCELADMIN_ALL_REQUESTS_OF_CLIENT = 23;
    public static final int CANCELADMIN_ALL_REQUESTS = 24;
    public static final int PRIORITY_CLIENT_CHANGE = 25;
    public static final int PLEASE_SHUTDOWN = 26;
    public static final int CHANGE_ENGINES = 27;
    public static final String SUPERADMIN = "SUPERADMIN";
    protected PeerJXTA _peerJXTA;
    protected AppPeer _appPeer;

    public AdminManager(AppPeer peer) {
        this._peerJXTA = peer.getPeerJXTA();
        this._appPeer = peer;
    }

    public final void manageAdminMessage(Message mess, MessageInfoAnalyser info) {
        String typeStr = info.getAttribut("ADMINTYPE");
        assert (typeStr != null);
        String senderID = info.getAttribut("SENDERID");
        assert (senderID != null);
        int type = Integer.parseInt(typeStr);
        try {
            InfoPeerApp remote = this._appPeer.getRemoteAppList().getRemoteInfoPeerApp(senderID);
            if (remote == null) {
                this._appPeer.printInfo(String.valueOf(ResJXTA.getString("NETWORK_MESSAGE_FROM_UNKNOWN_PEER")) + senderID);
                return;
            }
            if (this.isAdministratorMessage(type) && !remote.getPeerJXTA().getType().equals("ADMIN")) {
                Loggeur.log(this.getClass(), Loggeur.WARNING, ResJXTA.getString("ADMIN_MESSAGE_FROM_NON_ADMIN_PEER"));
                return;
            }
            Loggeur.log(this.getClass(), Loggeur.FINEST, MessageFormat.format(ResJXTA.getString("ADMIN_MESSAGE_RECEIVED"), typeStr, remote.getPeerJXTA().toString()));
            this.doManageAdminMessage(type, senderID, remote, mess, info);
        }
        catch (ReqAutomatonException e) {
            e.printStackTrace();
            Request req = e.getRequest();
            req.setInfo("AdminManager " + type + " " + e.getMessage());
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
        }
    }

    protected void doManageAdminMessage(int type, String senderID, InfoPeerApp remote, Message mess, MessageInfoAnalyser info) {
        switch (type) {
            case 5: {
                this.remoteSendInfo(senderID);
                break;
            }
            case 6: {
                MessageElement statElt = mess.getMessageElement("STATRESPONSE");
                if (statElt == null) {
                    Loggeur.log(this.getClass(), Loggeur.DEBUG, "STATERESPONSEELEMENT == null");
                    break;
                }
                if (!remote.isOnline() && remote.isBound()) {
                    remote.getPeerJXTA().setStatus(1, PeerChangeListener.Reason.BECAUSE_OF_GOOD_INFO_RESPONSE);
                }
                this.localAnalyseInfo(remote, statElt);
                break;
            }
            case 20: {
                this._appPeer.printInfo(String.valueOf(ResJXTA.getString("NETWORK_CONNECT_NOT_AUTHORIZED")) + " " + remote.getName() + " " + remote.getVersion());
                remote.setAuthorized(false);
                break;
            }
            case 1: {
                String reqID = info.getAttribut("UID");
                this.localStopRequest(reqID, senderID);
                break;
            }
            case 8: {
                Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("ADMIN_CANCEL_ALL_REQUESTS_OF_CLIENT")) + remote.getName());
                this.localStopAllRequest(senderID);
                break;
            }
            case 22: {
                String reqID = info.getAttribut("UID");
                this.localAdminStopRequest(reqID);
                break;
            }
            case 23: {
                String clientID = info.getAttribut("UID");
                Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("ADMIN_CANCEL_ALL_REQUESTS_OF_CLIENT")) + clientID);
                this.localAdminStopAllRequest(clientID);
                break;
            }
            case 24: {
                Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("ADMIN_CANCEL_ALL_REQUESTS")) + "...");
                this.localAdminStopAllRequest();
                Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("ADMIN_CANCEL_ALL_REQUESTS")) + "OK");
                break;
            }
            case 25: {
                String clientID = info.getAttribut("UID");
                String prio = info.getAttribut("PRIO");
                if (prio == null) {
                    return;
                }
                try {
                    this.localChangePriority(clientID, Integer.parseInt(prio));
                }
                catch (Exception e) {
                    Loggeur.log(this.getClass(), Loggeur.DEBUG, "Wrong Priority");
                }
                break;
            }
            case 9: {
                String fileID = info.getAttribut("UID");
                this.localRemoveFile(fileID, senderID);
                break;
            }
            case 26: {
                this.localAdminShutDown();
                break;
            }
            default: {
                Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(ResJXTA.getString("ADMIN_UNKNOWN_ADMIN_MESSAGE")) + String.valueOf(type));
            }
        }
    }

    protected void localStopAllRequest(String senderID) {
    }

    protected void localStopRequest(String reqID, String senderID) {
    }

    protected void localAdminStopRequest(String reqID) {
    }

    protected void localAdminStopAllRequest(String clientID) {
    }

    protected void localAdminStopAllRequest() {
    }

    protected void localAdminShutDown() {
    }

    protected void localAdminStopRequest(String reqID, String senderID) {
    }

    protected void remoteSendInfo(String peerToInform) {
    }

    protected void localChangePriority(String clientID, int prio) {
    }

    protected void localAnalyseInfo(InfoPeerApp peerApp, MessageElement statElt) {
    }

    protected void localRemoveFile(String fileID, String senderID) {
        this._appPeer.printInfo("Demande de suppresion du fichier " + fileID);
        StringTokenizer st = new StringTokenizer(senderID, "-");
        st.nextToken();
        String senderShortID = st.nextToken();
        String fileOwner = FileNameUtility.retrievePeerID(fileID);
        if (senderShortID.equals(fileOwner) || senderID.equals(SUPERADMIN)) {
            File f = new File(JXTAProperties.getTempDir(), fileID);
            FileDirDeletor.deleteIfNotDir(f, true);
        } else {
            this._appPeer.printInfo(String.valueOf(senderShortID) + "n'a pas le droit de supprimer" + fileID);
        }
    }

    public void remoteAskForInfo(String peerToAsk) {
        InfoPeerApp remote = this._appPeer.getRemoteAppList().getRemoteInfoPeerApp(peerToAsk);
        if (remote != null && remote.canTalkWith()) {
            AdminMessageCreator admMessage = new AdminMessageCreator(5, "", this._peerJXTA.getPeerIDString());
            Message message = admMessage.createMessage();
            remote.getPeerJXTA().sendMessage(message);
        }
    }

    private boolean isAdministratorMessage(int type) {
        return type == 24 || type == 23 || type == 22 || type == 25 || type == 26;
    }
}

