/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStock;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLEscape;
import net.jxta.endpoint.Message;

public class RequestReceiverClient {
    protected RequestStock _stock;
    protected CECILIAClient _appPeer;

    public RequestReceiverClient(RequestStock stock, CECILIAClient appPeer) {
        this._stock = stock;
        this._appPeer = appPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageCeciliaResponseMessage(Message message, MessageInfoAnalyser info) {
        String senderID;
        String reqID = info.getAttribut("UID");
        if (!this.isMessageFromRightPeer(reqID, senderID = info.getAttribut("SENDERID"))) {
            return;
        }
        Request req = this._stock.getRequest(reqID);
        if (req == null) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("REQUEST_NO_MORE_IN_STOK")) + reqID);
            return;
        }
        String checkLastFile = new String("checkLastFile");
        if (!req.allFilesArrived()) {
            int i = 0;
            while (i < 3) {
                try {
                    String string = checkLastFile;
                    synchronized (string) {
                        checkLastFile.wait(2000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (req.allFilesArrived()) break;
                ++i;
            }
        }
        if (req.getState() != ReqState.COMPUTE_FINISHED && req.getState() != ReqState.SENDING_RESULT) {
            String checkMessage = new String("checkMessage");
            int securite = 0;
            while (req.getState() != ReqState.SENDING_RESULT && securite < 1000) {
                try {
                    String string = checkMessage;
                    synchronized (string) {
                        checkMessage.wait(500L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                securite += 500;
            }
        }
        if (req.allFilesArrived()) {
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_RESULT_SENT);
            return;
        }
        if (req.isWritingFile()) {
            String checkWrite = new String("checkWrite");
            int securite = 0;
            while (securite < 600000) {
                try {
                    String e = checkWrite;
                    synchronized (e) {
                        checkWrite.wait(500L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (req.allFilesArrived() || req.getState() == ReqState.CANCEL_BY_SOFTWARE) break;
                securite += 500;
            }
        }
        if (req.allFilesArrived()) {
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_RESULT_SENT);
        } else {
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_RESULTS_TRANFERT_ERROR);
        }
    }

    public void manageCeciliaIssueMessage(Message message, MessageInfoAnalyser info) {
        String senderID;
        StringBuffer sb = new StringBuffer(64);
        String reqID = info.getAttribut("UID");
        if (!this.isMessageFromRightPeer(reqID, senderID = info.getAttribut("SENDERID"))) {
            return;
        }
        Request req = this._stock.getRequest(reqID);
        if (req == null) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("REQUEST_NO_MORE_IN_STOK")) + reqID);
            return;
        }
        InfoServerApp serveurApp = this._appPeer.getServersApp().getServer(req.getServerID());
        if (serveurApp == null) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("REQUEST_INVALID_SERVER_FOR_REQ")) + req.getShortNumber());
            return;
        }
        try {
            String nbErr = info.getAttribut("ERRORS");
            req.setNumberOfErr(req.getNumberOfErr() + Integer.parseInt(nbErr));
            String reqInfo = XMLEscape.fromXML(info.getAttribut("REQINFO"));
            req.setInfo(reqInfo);
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Error message wrong state for " + req.getShortNumber());
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
            return;
        }
        String status = info.getAttribut("STATUS");
        ReqState state = ReqState.valueOf(status);
        if (state == null) {
            req.setInfo("Unknown state " + status);
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
            return;
        }
        sb.append(ResJXTA.getString("REQUEST_ERROR"));
        sb.append(" ");
        sb.append(req.getShortNumber());
        sb.append(", status = ");
        sb.append(state.toString());
        sb.append(", err = ");
        sb.append(req.getInfo());
        sb.append(" (");
        sb.append(serveurApp.getName());
        sb.append(")");
        Loggeur.log(this.getClass(), Loggeur.ERROR, sb.toString());
        switch (state) {
            case SERVER_DOESNT_HAVE_ENGINE: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE);
                break;
            }
            case MISSING_FILE_TO_COMPUTE: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE);
                break;
            }
            case ENGINE_ERROR: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.COMPUTING_2_ENGINE_ERROR);
                break;
            }
            case WRONG_RESULT: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_WRONG_RESULT);
                break;
            }
            default: {
                req.setInfo("Wrong IssueMessage");
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
            }
        }
    }

    public void manageStateMessage(MessageInfoAnalyser info) {
        String reqStr = info.getAttribut("UID");
        String senderID = info.getAttribut("SENDERID");
        assert (reqStr != null);
        if (!this.isMessageFromRightPeer(reqStr, senderID)) {
            return;
        }
        Request req = this._stock.getRequest(reqStr);
        if (req == null) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("REQUEST_NO_MORE_IN_STOK")) + reqStr);
            return;
        }
        String stateStr = info.getAttribut("STATUS");
        ReqState state = ReqState.valueOf(stateStr);
        if (state == null) {
            throw new ReqAutomatonException(req, req.getState(), null);
        }
        switch (state) {
            case WAIT_COMPUTING: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.REQUEST_SENT_2_WAIT_COMPUTING);
                break;
            }
            case COMPUTING: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.WAIT_COMPUTING_2_COMPUTING);
                break;
            }
            case COMPUTE_FINISHED: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.COMPUTING_2_COMPUTE_FINISHED);
                break;
            }
            case SENDING_RESULT: {
                if (req.getState() == ReqState.RESULTS_TRANSFERT_ERROR) {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.RESULT_TRANSFERT_ERROR_2_SENDING_RESULT);
                    break;
                }
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.COMPUTE_FINISHED_2_SENDING_RESULT);
                break;
            }
            case CANCEL_BY_ADMIN: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_ADMIN);
                break;
            }
            case CANCEL_BY_SOFTWARE: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
                break;
            }
            default: {
                Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.getString("ADMIN_UNKNOWN_ADMIN_MESSAGE"));
            }
        }
    }

    private boolean isMessageFromRightPeer(String reqStr, String senderID) {
        Request req = this._stock.getRequest(reqStr);
        if (req == null) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "RequestReceiverClient(1)" + reqStr);
            return false;
        }
        if (!req.getServerID().equals(senderID)) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("REQUEST_INVALID_SERVER_FOR_REQ")) + req.getShortNumber());
            return false;
        }
        return true;
    }
}

