/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.test;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.CommandFileWriter;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.test.TestRessources;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRepartition {
    public static final ReqState[] GOOD_LIST = new ReqState[]{ReqState.NEW, ReqState.SENDING_REQUEST, ReqState.REQUEST_SENT, ReqState.WAIT_COMPUTING, ReqState.COMPUTING, ReqState.COMPUTE_FINISHED, ReqState.SENDING_RESULT, ReqState.RESULT_SENT, ReqState.COPYING_RESULT_TO_DEST, ReqState.SPECIFIC_THREATMENT, ReqState.FINISHED_SUCCESFULY};
    protected CECILIAClient _client;
    private int nbTest = 0;

    @Before
    public void setUp() throws Exception {
        JXTAProperties.initLaunchIni();
        StringBuffer sb = new StringBuffer();
        sb.append("JUnit-");
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH'h'mm");
        sb.append(dateFormat.format(new Date()));
        System.setProperty("cecilia.jxta.name", sb.toString());
        this._client = CECILIAClient.getCECILIAClient();
        this._client.waitReady();
    }

    @Test
    public void testRepartition() {
        int nbOfServeurs = this._client.getServersApp().getNumberOfOKServer();
        Assert.assertTrue((String)"Test de repartition necessite au moins 2 serveurs", (nbOfServeurs > 1 ? 1 : 0) != 0);
        Request[] reqs = new Request[nbOfServeurs];
        int i = 0;
        while (i < nbOfServeurs) {
            reqs[i] = this.createAndLaunchTestRequest(5);
            ++i;
        }
        this._client.waitEmptyStock();
        ArrayList<String> srvs = new ArrayList<String>();
        Request[] requestArray = reqs;
        int n = reqs.length;
        int n2 = 0;
        while (n2 < n) {
            Request request = requestArray[n2];
            String serveur = request.getHisto().getLastServeur();
            if (!srvs.contains(serveur)) {
                srvs.add(serveur);
            }
            ++n2;
        }
        Assert.assertTrue((srvs.size() == nbOfServeurs ? 1 : 0) != 0);
        requestArray = reqs;
        n = reqs.length;
        n2 = 0;
        while (n2 < n) {
            Request req = requestArray[n2];
            Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
            ++n2;
        }
    }

    public Request createAndLaunchTestRequest(int executionTime) {
        Request req = this._client.getNewRequest();
        req.setEngine("TESTFILE");
        req.setParsed(true);
        try {
            CommandFileWriter fw = new CommandFileWriter(this._client, req);
            fw.writeText("sizeof ");
            fw.writeInputFile(TestRessources.getRessource("bigresultv4.dag"));
            fw.writeText(" > ");
            fw.writeOutputFile(new File(".\\res\\taille" + this.nbTest + ".txt"));
            fw.writeText(" wait ");
            fw.writeText(String.valueOf(executionTime));
            fw.flushAndClose();
            req.setCmdFileName(fw);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this._client.addRequestToStock(req);
        ++this.nbTest;
        return req;
    }
}

