/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.xmlutility;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class AdvertisementAnalyser {
    protected Map<String, String> _descMap;
    protected String _desc;
    protected ArrayList<String> _engines;

    public AdvertisementAnalyser(PeerAdvertisement adv) {
        this._desc = adv.getDescription();
        if (this._desc == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "PeerAdvertisement.getDescription() == null");
            adv.toString();
        }
        this._descMap = new HashMap<String, String>();
        this.analyseDescription();
        this.findEngines();
    }

    public AdvertisementAnalyser(PipeAdvertisement adv) {
        this._desc = adv.getDescription();
        if (this._desc == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "PipeAdvertisement.getDescription() == null");
        }
        this._descMap = new HashMap<String, String>();
        this.analyseDescription();
    }

    public AdvertisementAnalyser(String desc) {
        this._desc = desc;
        this._descMap = new HashMap<String, String>();
        this.analyseDescription();
    }

    public String getDescription(String att) {
        return this._descMap.get(att);
    }

    public String getDesc() {
        return this._desc != null ? this._desc : "";
    }

    protected void analyseDescription() {
        if (this._desc == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this._desc, ",");
        while (st.hasMoreTokens()) {
            String data = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(data, "=");
            String key = null;
            String objet = null;
            if (st2.hasMoreTokens()) {
                key = st2.nextToken();
            }
            if (st2.hasMoreTokens()) {
                objet = st2.nextToken();
            }
            if (objet == null || key == null) continue;
            this._descMap.put(key, objet);
        }
    }

    public ArrayList<String> findEngines() {
        this._engines = new ArrayList();
        String engines = this._descMap.get("AVAILABLEENGINE");
        if (engines != null) {
            StringTokenizer st = new StringTokenizer(engines, " ");
            while (st.hasMoreTokens()) {
                String engine = st.nextToken();
                if (engine == null || engine.equals("")) continue;
                this._engines.add(engine);
            }
        }
        return this._engines;
    }

    public boolean updatePeerInfo(InfoPeerJXTA newPeerInfo) {
        String userDesc;
        String hostname;
        String freq;
        newPeerInfo.setAdvDesc(this.getDesc());
        newPeerInfo.setType(this.getDescription("PEERTYPE"));
        String version = this.getDescription("VERSION");
        if (version != null && !version.equals("")) {
            newPeerInfo.setVersion(version);
        }
        if (!newPeerInfo.isGoodVersion()) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN_WRONG_VERSION_MESSAGE"));
            sb.append(" ");
            sb.append(newPeerInfo.getName());
            sb.append(" ");
            sb.append(newPeerInfo.getVersion());
            Loggeur.log(NetworkUtility.class, Loggeur.WARNING, sb.toString());
        }
        if ((freq = this.getDescription("CPU")) != null && !freq.equals("")) {
            try {
                newPeerInfo.setCpuFrequency(Integer.parseInt(freq));
            }
            catch (NumberFormatException e) {
                newPeerInfo.setCpuFrequency(-1);
            }
        }
        if ((hostname = this.getDescription("HOSTNAME")) != null && !hostname.equals("")) {
            newPeerInfo.setHostName(hostname);
        }
        if ((userDesc = this.getDescription("DESCRIPTION")) != null) {
            newPeerInfo.setUserDesc(userDesc.replace("__", ","));
        }
        String remoteAppTypes = this.getDescription("APPTYPES");
        ArrayList<String> appTypes = new ArrayList<String>();
        if (remoteAppTypes != null && remoteAppTypes.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(remoteAppTypes);
            while (st.hasMoreElements()) {
                appTypes.add((String)st.nextElement());
            }
        }
        newPeerInfo.setAuthorizedTypes(appTypes);
        return true;
    }
}

