/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.xmlutility;

import com.dassault.cecilia.lib.distrib.jxtautility.URIListUtility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PeerAdvHandler
extends DefaultHandler {
    private String _PID = "-1";
    private String _GID = "-1";
    private String _Name = "";
    private String _Desc = "";
    private boolean _RDV = false;
    private String _tcpURI = "";
    private String _httpURI = "";
    private StringBuffer _pcData;

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
        this._pcData = new StringBuffer();
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
        if (localName.length() == 0) {
            localName = rawName;
        }
        if (localName.equalsIgnoreCase("PID")) {
            this._PID = this.cleanString(this._pcData.toString());
        } else if (localName.equalsIgnoreCase("GID")) {
            this._GID = this.cleanString(this._pcData.toString());
        } else if (localName.equalsIgnoreCase("Name")) {
            this._Name = this.cleanString(this._pcData.toString());
        } else if (localName.equalsIgnoreCase("Desc")) {
            this._Desc = this.cleanString(this._pcData.toString());
        } else if (localName.equalsIgnoreCase("Rdv")) {
            this._RDV = this._pcData.toString().contains("true") || this._pcData.toString().contains("True") || this._pcData.toString().contains("TRUE");
        } else if (localName.equalsIgnoreCase("EA")) {
            String addr = this.cleanString(this._pcData.toString());
            if (addr.contains("tcp")) {
                this._tcpURI = addr;
            } else if (addr.contains("http")) {
                this._httpURI = addr;
                URIListUtility.addUri(this._httpURI);
            }
        }
    }

    public String cleanString(String toClean) {
        return toClean.replace(" ", "").replace("\t", "").replace("\n", "");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._pcData != null) {
            this._pcData.append(new String(ch, start, length));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name : ");
        sb.append(this._Name);
        sb.append("\n");
        sb.append("Desc : ");
        sb.append(this._Desc);
        sb.append("\n");
        sb.append("RDV : ");
        sb.append(String.valueOf(this._RDV));
        sb.append("\n");
        sb.append("TCP : ");
        sb.append(this._tcpURI);
        sb.append("\n");
        sb.append("HTTP : ");
        sb.append(this._httpURI);
        sb.append("\n");
        return sb.toString();
    }

    public boolean isRDV() {
        return this._RDV;
    }

    public String getGID() {
        return this._GID;
    }

    public String getPID() {
        return this._PID;
    }
}

