/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.seqconvert.ConvertChooseDlg;
import com.dassault.cecilia.plugin.seqconvert.Event;
import com.dassault.cecilia.plugin.seqconvert.EventsTableDlg;
import com.dassault.cecilia.plugin.seqconvert.FileChooseDlg;
import com.dassault.cecilia.plugin.seqconvert.ParametersSequenceConverter;
import com.dassault.cecilia.plugin.seqconvert.ResSequenceConverter;
import com.dassault.cecilia.plugin.seqconvert.Sequence;
import com.dassault.cecilia.plugin.seqconvert.SequenceFile;
import com.dassault.cecilia.plugin.seqconvert.SequenceFileWriter;
import com.dassault.cecilia.plugin.seqconvert.SequencesUtility;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PluginSequenceConverter
extends AbstractPluginModel
implements PluginMAction {
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "xml-viewer";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("SequenceConverter.gif"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return false;
    }

    public boolean withParameters() {
        return true;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return new ParametersSequenceConverter();
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        assert (this.withParameters());
        assert (parameters instanceof ParametersSequenceConverter);
        ParametersSequenceConverter clone = new ParametersSequenceConverter((ParametersSequenceConverter)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    public IOParameters getIOParameters() {
        return ParametersSequenceConverter.getIOParameters();
    }

    public void createSession(Plugable launcher, Object parameters) {
        if (!(parameters instanceof ParametersSequenceConverter)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), "Parameters not know for this plugin", ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"), 0);
            return;
        }
        ParametersSequenceConverter params = (ParametersSequenceConverter)parameters;
        FileChooseDlg dlgChooseInFile = FileChooseDlg.createFileChooseDlg(launcher.getWindow(), ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"), ResSequenceConverter.getString("GUI_LABEL_INPATH"), ResSequenceConverter.getString("GUI_BUTTON_NEXT"), ".seq", ResSequenceConverter.getString("GUI_EXTENSIONDESC_SEQ"), ResSequenceConverter.getString("GUI_LABEL_INPATH"), false);
        dlgChooseInFile.setDefaultPath(".");
        if (!dlgChooseInFile.showDialog()) {
            return;
        }
        SequenceFile sequenceFile = new SequenceFile(new File(dlgChooseInFile.getPath()));
        if (!sequenceFile.isValid()) {
            return;
        }
        EventsTableDlg dlgEventsTable = new EventsTableDlg((JFrame)launcher.getWindow(), ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"), sequenceFile.getEvents());
        if (!dlgEventsTable.showDialog()) {
            return;
        }
        ConvertChooseDlg dlgChooseConversion = new ConvertChooseDlg((JFrame)launcher.getWindow(), ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"));
        if (!dlgChooseConversion.showDialog()) {
            return;
        }
        String choice = dlgChooseConversion.getConversionType();
        FileChooseDlg dlgChooseOutFile = FileChooseDlg.createFileChooseDlg(launcher.getWindow(), ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"), "MINICUTSDAG" == choice ? ResSequenceConverter.getString("GUI_LABEL_OUTDAGPATH") : ResSequenceConverter.getString("GUI_LABEL_OUTXMLPATH"), ResSequenceConverter.getString("GUI_BUTTON_CONVERT"), "MINICUTSDAG" == choice ? ".dag" : ".xml", "MINICUTSDAG" == choice ? ResSequenceConverter.getString("GUI_EXTENSIONDESC_DAG") : ResSequenceConverter.getString("GUI_EXTENSIONDESC_XML"), "MINICUTSDAG" == choice ? ResSequenceConverter.getString("GUI_LABEL_OUTDAGPATH") : ResSequenceConverter.getString("GUI_LABEL_OUTXMLPATH"), true);
        dlgChooseOutFile.setDefaultPath(".");
        if (!dlgChooseOutFile.showDialog()) {
            return;
        }
        Event[] eventsToRemove = dlgEventsTable.getEventsToRemove();
        SequencesUtility sequenceUtility = new SequencesUtility();
        Sequence[] sequences = sequenceUtility.filterSequences(sequenceFile.getSequences(), eventsToRemove);
        SequenceFileWriter sequenceFileWriter = new SequenceFileWriter(dlgChooseOutFile.getPath());
        if ("DIRECTXML" == choice) {
            sequences = sequenceUtility.classifySequences(sequences);
            sequenceFileWriter.writeSequencesXML(sequences, sequenceFile.getDreadedEvent());
            if (params.VerifyData(launcher) && params.getXmlViewer()) {
                try {
                    String outFilePath = "\"" + dlgChooseOutFile.getPath() + "\"";
                    String cmd = params.getXmlViewerPath() + " " + outFilePath;
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    StringBuffer mess = new StringBuffer(128);
                    mess.append("Execute error : \n");
                    mess.append(e.getMessage());
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), mess.toString());
                }
            }
        } else {
            sequences = sequenceUtility.removeRedEvtsFromSequences(sequences);
            sequences = sequenceUtility.removeEquivalentSequences(sequences);
            sequences = sequenceUtility.removeNotMinSequences(sequences);
            if ("MINICUTSXML" == choice) {
                sequences = sequenceUtility.classifySequences(sequences);
                sequenceFileWriter.writeSequencesXML(sequences, sequenceFile.getDreadedEvent());
                if (params.VerifyData(launcher) && params.getXmlViewer()) {
                    try {
                        String outFilePath = "\"" + dlgChooseOutFile.getPath() + "\"";
                        String cmd = params.getXmlViewerPath() + " " + outFilePath;
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException e) {
                        StringBuffer mess = new StringBuffer(128);
                        mess.append("Execute error : \n");
                        mess.append(e.getMessage());
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), mess.toString());
                    }
                }
            } else if ("MINICUTSDAG" == choice) {
                sequenceFileWriter.writeSequencesDAG(sequences, sequenceFile.getDreadedEvent());
            }
        }
    }
}

