/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.core.cecilia.export.DBKWriter;
import com.dassault.cecilia.plugin.seqconvert.Event;
import com.dassault.cecilia.plugin.seqconvert.Sequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class SequenceFileWriter {
    private String path;

    public SequenceFileWriter(String p) {
        this.path = p;
    }

    public void writeSequencesXML(Sequence[] sequences, Event dreadedEvent) {
        try {
            File file = new File(this.path);
            file.createNewFile();
            BufferedWriter bufWriter = new BufferedWriter(new FileWriter(file, false));
            DBKWriter writer = new DBKWriter((Writer)bufWriter, " ");
            writer.write("<?xml version=\"1.0\" ?>\n", false);
            writer.write("<sequences>\n", false);
            writer.addIndent(1);
            for (int i = 0; i < sequences.length; ++i) {
                writer.write("<sequence>\n", false);
                writer.addIndent(1);
                writer.write("<order>" + sequences[i].getNbEvents() + "</order>", false);
                for (int j = 0; j < sequences[i].getNbEvents(); ++j) {
                    writer.write("<event_" + (j + 1) + ">", false);
                    writer.write(sequences[i].getEvent(j).getName(), false);
                    writer.write("</event_" + (j + 1) + ">\n", false);
                }
                writer.addIndent(-1);
                writer.write("</sequence>\n", false);
            }
            writer.addIndent(-1);
            writer.write("</sequences>\n", false);
            writer.close(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void writeSequencesDAG(Sequence[] sequences, Event dreadedEvent) {
        try {
            int i;
            File file = new File(this.path);
            file.createNewFile();
            BufferedWriter bufWriter = new BufferedWriter(new FileWriter(file, false));
            bufWriter.write("/* Generate by CStepper */\n");
            bufWriter.write("'");
            bufWriter.write(dreadedEvent.getName());
            bufWriter.write("true' := (");
            boolean first = true;
            for (i = 0; i < sequences.length; ++i) {
                if (!first) {
                    bufWriter.write(" | ");
                }
                first = false;
                bufWriter.write("G_" + i);
            }
            bufWriter.write(");\n");
            for (i = 0; i < sequences.length; ++i) {
                bufWriter.write("G_" + i + " := (");
                boolean firstEvent = true;
                for (int j = 0; j < sequences[i].getNbEvents(); ++j) {
                    if (!firstEvent) {
                        bufWriter.write(" & ");
                    } else {
                        firstEvent = false;
                    }
                    bufWriter.write("'");
                    bufWriter.write(sequences[i].getEvent(j).getName());
                    bufWriter.write("'");
                }
                bufWriter.write(");\n");
            }
            bufWriter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void writeSequencesSEQ(Sequence[] sequences, Event dreadedEvent) {
        try {
            File file = new File(this.path);
            file.createNewFile();
            BufferedWriter bufWriter = new BufferedWriter(new FileWriter(file, false));
            bufWriter.write("products(MRS('");
            bufWriter.write(dreadedEvent.getName());
            bufWriter.write("')) = \n");
            for (int i = 0; i < sequences.length; ++i) {
                bufWriter.write("{");
                boolean firstEvent = true;
                for (int j = 0; j < sequences[i].getNbEvents(); ++j) {
                    if (!firstEvent) {
                        bufWriter.write(", ");
                    } else {
                        firstEvent = false;
                    }
                    bufWriter.write("'");
                    bufWriter.write(sequences[i].getEvent(j).getName());
                    bufWriter.write("'");
                }
                bufWriter.write("}\n");
            }
            bufWriter.write("end");
            bufWriter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

