/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

class CLIWrapper {
    String _path;
    Process _process;
    CLITurn _turn;
    CLIWriter _writer;
    CLIReader _reader;

    CLIWrapper(String path, String prompt) {
        this._path = path;
        this.LaunchProcess();
        this._turn = new CLITurn();
        this._writer = new CLIWriter(this._process.getOutputStream());
        this._reader = new CLIReader(this._process.getInputStream(), this._process.getErrorStream());
        this._reader.SetPrompt(prompt);
        this._reader.start();
        this._writer.start();
    }

    private void LaunchProcess() {
        try {
            Runtime runtime = Runtime.getRuntime();
            this._process = runtime.exec(this._path);
        }
        catch (Throwable w) {
            System.err.println("Internal error");
            w.printStackTrace();
        }
    }

    public void OpenSession() {
        this._reader.SetMemorization(false);
        this._turn.SetTurn(2);
        this._turn.WaitForTurn(3);
    }

    public void CloseSession() {
        this._writer.SetCommand(null);
        this._turn.SetTurn(1);
        OutputStream outputStream = this._process.getOutputStream();
        try {
            outputStream.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException : " + ioe);
        }
        this._process.destroy();
    }

    public void SendCommand(String command, Vector result) {
        this._reader.SetVector(result);
        this._reader.SetMemorization(true);
        this._writer.SetCommand(command);
        this._turn.SetTurn(1);
        this._turn.WaitForTurn(3);
    }

    private class CLIReader
    extends Thread {
        private InputStreamReader _inputReader;
        private InputStreamReader _errorReader;
        private BufferedReader _errorBufferedReader;
        private Vector _vector;
        private boolean _memorization;
        private String _prompt;
        private String _pattern;

        CLIReader(InputStream iStream, InputStream eStream) {
            this._inputReader = new InputStreamReader(iStream);
            this._errorReader = new InputStreamReader(eStream);
            this._errorBufferedReader = new BufferedReader(this._errorReader);
            this._memorization = false;
            this._vector = null;
            this._prompt = null;
            this._pattern = null;
        }

        public void SetVector(Vector aVector) {
            this._vector = aVector;
        }

        public void SetMemorization(boolean value) {
            this._memorization = value;
        }

        public void SetPrompt(String value) {
            this._prompt = value;
            this._pattern = "^" + this._prompt + ".*";
        }

        public String ReadLine() {
            StringBuffer buffer = new StringBuffer();
            int stop = 0;
            try {
                while (stop == 0) {
                    String line;
                    if (!this._inputReader.ready() && (line = buffer.toString()).matches(this._pattern)) {
                        stop = 1;
                    }
                    if (stop != 0) continue;
                    int c = this._inputReader.read();
                    if (c == -1) {
                        stop = 2;
                        continue;
                    }
                    if (c == 13) {
                        c = this._inputReader.read();
                        stop = 1;
                        continue;
                    }
                    if (c == 10) {
                        stop = 1;
                        continue;
                    }
                    buffer.append((char)c);
                }
            }
            catch (IOException ioe) {
                System.err.println("IOExcetpion : " + ioe);
            }
            if (stop == 2 && buffer.length() == 0) {
                return null;
            }
            return buffer.toString();
        }

        private void ReadErrorMessage() {
            try {
                boolean stop = false;
                while (!stop) {
                    if (this._errorBufferedReader.ready()) {
                        String line = this._errorBufferedReader.readLine();
                        if (!this._memorization) continue;
                        this._vector.addElement(line);
                        continue;
                    }
                    stop = true;
                }
            }
            catch (IOException ioe) {
                System.err.println("IOException : " + ioe);
            }
        }

        @Override
        public void run() {
            int status = 1;
            while (status != 0) {
                status = 1;
                CLIWrapper.this._turn.WaitForTurn(2);
                while (status == 1) {
                    String line = this.ReadLine();
                    if (line == null) {
                        status = 0;
                        continue;
                    }
                    if (line.matches(this._pattern)) {
                        status = 2;
                        continue;
                    }
                    if (!this._memorization) continue;
                    this._vector.addElement(line);
                }
                this.ReadErrorMessage();
                CLIWrapper.this._turn.SetTurn(3);
            }
        }
    }

    private class CLIWriter
    extends Thread {
        BufferedWriter _outputWriter;
        String _command;

        CLIWriter(OutputStream anOutputStream) {
            OutputStreamWriter osw = new OutputStreamWriter(anOutputStream);
            this._outputWriter = new BufferedWriter(osw);
        }

        public void SetCommand(String value) {
            this._command = value;
        }

        @Override
        public void run() {
            try {
                boolean stop = false;
                while (!stop) {
                    CLIWrapper.this._turn.WaitForTurn(1);
                    if (this._command == null) {
                        stop = true;
                    } else {
                        this._outputWriter.write(this._command + "\n");
                        this._outputWriter.flush();
                    }
                    CLIWrapper.this._turn.SetTurn(2);
                }
            }
            catch (IOException ioe) {
                System.err.println("IOException : " + ioe);
            }
        }
    }

    private class CLITurn {
        static final int NONE = 0;
        static final int WRITER = 1;
        static final int READER = 2;
        static final int USER = 3;
        private int _state = 0;

        private CLITurn() {
        }

        public synchronized void SetTurn(int value) {
            this._state = value;
            this.notifyAll();
        }

        public synchronized void WaitForTurn(int value) {
            try {
                while (this._state != value) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                System.err.println("InterruptedException : " + e);
            }
        }
    }
}

