/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.parser;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class XmlElement {
    private String _name;
    private HashMap<String, String> _attrs = new HashMap();
    private StringBuffer _text;
    private Object _banObj;
    private int _line = -1;

    protected XmlElement(String sName, String qName, Attributes attrs, Locator loc) {
        this._name = qName;
        if ("".equals(this._name)) {
            this._name = sName;
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getQName(i);
                if ("".equals(aName)) {
                    aName = attrs.getLocalName(i);
                }
                this._attrs.put(aName, attrs.getValue(i));
            }
        }
        if (loc != null) {
            this._line = loc.getLineNumber();
        }
    }

    public boolean verifyNamespace(Map<String, String> prefixmapping) {
        int pos = this._name.indexOf(58);
        if (pos == -1) {
            return true;
        }
        String namespace = this._name.substring(0, pos);
        String uri = prefixmapping.get(namespace);
        if (uri != null && uri.startsWith("http://www.altarica.org")) {
            this._name = namespace + this._name.substring(pos + 1);
            return true;
        }
        return false;
    }

    protected String getName() {
        return this._name;
    }

    protected HashMap<String, String> getAttrs() {
        return this._attrs;
    }

    protected void appendText(String str) {
        if (str == null) {
            return;
        }
        if (str.length() == 0) {
            return;
        }
        if (this._text == null) {
            this._text = new StringBuffer(128);
        }
        this._text.append(str);
    }

    protected String getText() {
        if (this._text == null) {
            return "";
        }
        return this._text.substring(0);
    }

    protected int getLine() {
        return this._line;
    }

    protected void setBanObject(Object banObj) {
        this._banObj = banObj;
    }

    public Object getBanObject() {
        return this._banObj;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("XmlElement(").append(this._name).append(")");
        sb.append(this._attrs);
        return sb.toString();
    }
}

