/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.xslt;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.unitdefs.xslt.DefaultLayoutXML;
import com.dassault.cecilia.lib.ban.unitdefs.xslt.XSLTLayoutSimple;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.destination.Record;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class BanXSLT
extends Unit
implements ErrorListener,
LayoutDefiner {
    UtilFileSrc _style = new UtilFileSrc();
    private File _styleFile;
    List<Param> _params = new ArrayList<Param>();
    List<Param> _outputProperties = new ArrayList<Param>();
    Factory _factory = null;
    private String _headerLog = null;
    private int _nbrError;
    private int _nbrWarning;
    private Transformer _transformer = null;
    private Templates _templates = null;
    private TransformerFactory _tfactory = null;
    protected List<destination> _destDefines = new ArrayList<destination>();
    private List<Destination> _destinations = new ArrayList<Destination>(2);

    protected BanXSLT() {
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._style.setProcess(process);
    }

    public void setStyle(String value) {
        this._style.setFile("style", value);
    }

    public void setStyleref(String value) {
        this._style.setRef("styleref", value);
    }

    public File getStyleFile() {
        if (this._styleFile == null) {
            this._styleFile = this._style.getSrcFile(true);
        }
        return this._styleFile;
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    public Map<String, String> getParams() {
        return Param.mapParams(this._params);
    }

    public Param createOutputproperty() {
        Param param = new Param();
        this._outputProperties.add(param);
        return param;
    }

    public Map<String, String> getOutputProperty() {
        return Param.mapParams(this._outputProperties);
    }

    public Factory createFactory() {
        if (this._factory != null) {
            throw new BanProcessException("Only one 'factory' element");
        }
        this._factory = new Factory();
        return this._factory;
    }

    public void endValid() {
        if (this._style == null) {
            throw new BanProcessException("No attribut 'style' define");
        }
        if (this._destDefines.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(File infile, File outfile) throws Exception {
        this._headerLog = null;
        this._nbrWarning = 0;
        this._nbrError = 0;
        Transformer transformer = this.getTransformer();
        this._headerLog = "XSLT processor [Source : " + infile.getAbsolutePath() + "]";
        InputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(infile));
            StreamSource src = new StreamSource(fis);
            src.setSystemId(infile.toURI().toString());
            fos = new BufferedOutputStream(new FileOutputStream(outfile));
            StreamResult dst = new StreamResult(fos);
            dst.setSystemId(outfile.toURI().toString());
            transformer.transform(src, dst);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException src) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException src) {}
            if (this._nbrError != 0 || this._nbrWarning != 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("Error(s) = ").append(this._nbrError).append(" / ");
                sb.append("Warning(s) = ").append(this._nbrWarning).append("\n");
                this.addRecord(sb.toString());
            }
        }
    }

    private Transformer getTransformer() throws Exception {
        if (this._transformer != null) {
            return this._transformer;
        }
        Templates templates = this.getTemplates();
        this._headerLog = "XSLT create transformer";
        this._transformer = templates.newTransformer();
        this._transformer.setErrorListener(this);
        for (Map.Entry<String, String> param : this.getParams().entrySet()) {
            this._transformer.setParameter(param.getKey(), param.getValue());
        }
        for (Map.Entry<String, String> property : this.getOutputProperty().entrySet()) {
            this._transformer.setOutputProperty(property.getKey(), property.getValue());
        }
        return this._transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates() throws Exception {
        if (this._templates != null) {
            return this._templates;
        }
        TransformerFactory factory = this.getFactory();
        File infile = this.getStyleFile();
        this._headerLog = "XSLT compile stylesheet [" + infile.getPath() + "]";
        try (InputStream bis = null;){
            bis = new BufferedInputStream(new FileInputStream(infile));
            StreamSource src = new StreamSource(bis);
            src.setSystemId(infile.toURI().toString());
            this._templates = factory.newTemplates(src);
        }
        return this._templates;
    }

    private TransformerFactory getFactory() {
        if (this._tfactory != null) {
            return this._tfactory;
        }
        this._headerLog = "XSLT create factory";
        if (this._factory == null) {
            this._tfactory = TransformerFactory.newInstance();
        } else {
            String factoryName = this._factory.getName();
            try {
                Class<?> clazz = Class.forName(factoryName);
                this._tfactory = (TransformerFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BanProcessException(e);
            }
            for (Map.Entry<String, String> attr : this._factory.getAttributes().entrySet()) {
                this._tfactory.setAttribute(attr.getKey(), attr.getValue());
            }
        }
        this._tfactory.setErrorListener(this);
        return this._tfactory;
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.logError(exception, "Warning", 1);
        ++this._nbrWarning;
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.logError(exception, "Error", 0);
        ++this._nbrError;
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.logError(exception, "Fatal Error", 0);
        throw exception;
    }

    private void logError(TransformerException e, String type, int msgLevel) {
        SourceLocator locator;
        StringBuffer msg = new StringBuffer();
        if (this._headerLog != null) {
            msg.append(this._headerLog).append("\n");
            this._headerLog = null;
        }
        if ((locator = e.getLocator()) != null) {
            String systemid = locator.getSystemId();
            if (systemid != null) {
                String url = systemid;
                if (url.startsWith("file:///")) {
                    url = url.substring(8);
                } else if (url.startsWith("file:/")) {
                    url = url.substring(6);
                }
                msg.append(url);
            } else {
                msg.append("Unknown file");
            }
            int line = locator.getLineNumber();
            if (line != -1) {
                msg.append(":" + line);
                int column = locator.getColumnNumber();
                if (column != -1) {
                    msg.append(":" + column);
                }
            }
            msg.append(": ");
        }
        msg.append(type).append("! ");
        msg.append(e.getMessage());
        if (e.getCause() != null) {
            msg.append(" Cause: ").append(e.getCause());
        }
        this.addRecord(msg.toString());
    }

    public destination createDestination() {
        destination app = new destination();
        this._destDefines.add(app);
        return app;
    }

    @Override
    public Class configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return XSLTLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return DefaultLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for diff unit : " + key);
    }

    protected void addDestination(Destination destination2) {
        if (destination2 != null) {
            this._destinations.add(destination2);
        }
    }

    protected void removeDestination(Destination destination2) {
        if (destination2 != null) {
            this._destinations.remove(destination2);
        }
    }

    protected void addRecord(String msg) {
        StringRecord record = new StringRecord(msg);
        for (Destination dest : this._destinations) {
            dest.publish(record);
        }
    }

    protected void close() {
        for (Destination dest : this._destinations) {
            dest.close();
        }
    }

    class StringRecord
    implements Record {
        String _msg;

        StringRecord(String msg) {
            this._msg = msg;
        }

        public String toString() {
            return this._msg;
        }
    }

    class Factory
    extends BanProcessComponent {
        String _name = null;
        List<Param> _attributes = new ArrayList<Param>();

        Factory() {
        }

        public void setName(String value) {
            this._name = value;
        }

        protected String getName() {
            return this.expanse(this._name);
        }

        public Param createAttribute() {
            Param param = new Param();
            this._attributes.add(param);
            return param;
        }

        public Map<String, String> getAttributes() {
            return Param.mapParams(this._attributes);
        }

        public void endValid() {
            if (this._name == null) {
                throw new BanProcessException("No attribut 'name' define");
            }
        }
    }
}

