/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderHelper;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdMCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.swing.Icon;

public class PluginCmdDebug
extends AbstractPluginModel {
    private static Logger _LOG = Logger.getLogger(PluginCmdDebug.class.getPackage().getName());
    private static EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public boolean withOption(Plugable plugable) {
        return false;
    }

    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    public void refreshOptions(Plugable launcher) {
    }

    public boolean withParameters() {
        return false;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    public IOParameters getIOParameters() {
        return null;
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_NOMINAL_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "ctrl alt 1";
        }
        return "Info";
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCompute.getImageIcon("PLUGIN_DEBUG");
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createSession(Plugable launcher, Object parameters) {
        InfoDatum idatum = launcher.getDatum("Tree.Compute." + PluginCmdMCS.KEY_DATUM);
        if (idatum == null) {
            return;
        }
        String msgError = (String)idatum.getParameters().get("tree.error");
        if (msgError != null && !msgError.isEmpty()) {
            JOptionCecilia.showMessageDialog((Component)launcher.getWindow(), (String)msgError, (String)this.getInfo("plugin.name"), (int)0);
            return;
        }
        try {
            File dagFile = (File)idatum.getInputFiles().get("ceciliabdd.file.dag");
            if (dagFile == null) return;
            if (!dagFile.exists()) return;
            if (dagFile.length() == 0L) {
                return;
            }
            File xmlFile = (File)idatum.getInputFiles().get("ceciliabdd.file.xml");
            if (xmlFile == null) return;
            if (!xmlFile.exists()) return;
            if (xmlFile.length() == 0L) {
                return;
            }
            PluginModel pluginEngine = launcher.getPlugin(PluginCmdEngine.class.getName());
            if (pluginEngine == null || !(pluginEngine instanceof EngineBDDConfig)) {
                _LOG.severe("No EngineBDDConfig");
                return;
            }
            EngineBDDConfig engineBDDCfg = (EngineBDDConfig)pluginEngine;
            BooleanStore store = new BooleanStore();
            FileInputStream xmlStream = null;
            try {
                xmlStream = new FileInputStream(xmlFile);
                store.loadXML(xmlStream);
                _LOG.info(store.toString());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Iterator iterator = idatum.getInputFiles().values().iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
                return;
            }
            finally {
                if (xmlStream != null) {
                    try {
                        xmlStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            BooleanNode root = store.getRoot();
            if (root == null) {
                _LOG.severe("Pas de variable sommet...");
                return;
            }
            ParamComputeMCS optionsCompute = new ParamComputeMCS();
            if (!optionsCompute.displayDialog(store, launcher)) {
                return;
            }
            EngineBDDMCS engineBDD = new EngineBDDMCS(engineBDDCfg);
            engineBDD.addInputFile(dagFile);
            Appendable cmds = engineBDD.getCmdsAppendable();
            double missionTime = optionsCompute.getMissionTimeH();
            if (missionTime >= 0.0) {
                final LinkedHashSet withErrorNodes = new LinkedHashSet();
                BooleanStore.ProbabilityControl ctrl = new BooleanStore.ProbabilityControl(){

                    @Override
                    public void appendMissingProbability(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendLesserPeriodicity(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendGreaterExposition(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendErrorProbability(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendAvgNoAttribute(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendAvgNoMatrix(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendAvgDefInspected(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendAvgNoInspected(BooleanNode node) {
                        withErrorNodes.add(node);
                    }

                    @Override
                    public void appendAvgBadParameter(BooleanNode node) {
                        withErrorNodes.add(node);
                    }
                };
                store.computeLeavesProbability(missionTime, ctrl);
                if (withErrorNodes.size() == 0) {
                    store.prepareComputeAverageRisk(optionsCompute.getTypeProbability(), missionTime, ctrl);
                }
                if (withErrorNodes.size() > 0) {
                    StringBuffer sb = new StringBuffer().append("\n-------------------------\nEvents with error : \n");
                    Iterator<Object> iterator = withErrorNodes.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            _LOG.severe(sb.toString());
                            return;
                        }
                        BooleanNode leaf = (BooleanNode)iterator.next();
                        sb.append("  ").append(leaf.getName()).append("\n");
                    }
                }
                try {
                    store.writeProbabilities(cmds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            EngineBDDConfig.EngineType engineType = engineBDDCfg.getEngineType(false);
            File resFile = new File("e:\\" + engineType.toString() + ".txt");
            try {
                optionsCompute.generateComputeScript(cmds, root, engineType == EngineBDDConfig.EngineType.Aralia4, resFile.getAbsolutePath(), EMPTY_ITERATOR);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            final StringBuffer userBuffer = new StringBuffer(1024);
            EngineControl ctrl = new EngineControl(){

                @Override
                public boolean isCanceled() {
                    return false;
                }

                @Override
                public void appendOut(String msg) {
                    _LOG.info(msg);
                }

                @Override
                public void appendErr(String msg) {
                    _LOG.severe(msg);
                }

                @Override
                public void appendUserMsg(String msg) {
                    userBuffer.append(msg);
                }
            };
            EngineBDDConfig.ResultType result = engineBDD.execute(ctrl);
            if (result != EngineBDDConfig.ResultType.NoError) {
                _LOG.severe("Erreur lors du calcul\n" + userBuffer.toString());
                return;
            }
            _LOG.info("*Yes");
            BooleanResult boolResult = new BooleanResult(store, optionsCompute);
            BufferedReader resReader = null;
            try {
                resReader = new BufferedReader(new FileReader(resFile));
                MCSReaderHelper helper = new MCSReaderHelper(){

                    @Override
                    public boolean isCanceled() {
                        return false;
                    }
                };
                boolResult.parse(root, resReader, helper);
                if (helper.hasLimited()) {
                    _LOG.warning(helper.getWarningMsg());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Iterator iterator = idatum.getInputFiles().values().iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
                return;
            }
            finally {
                if (resReader != null) {
                    try {
                        ((Reader)resReader).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            boolResult.computeProbabilities(optionsCompute.getTypeProbability(), missionTime, ctrl);
            _LOG.info(boolResult.getResultsString());
            return;
        }
        finally {
            Iterator iterator = idatum.getInputFiles().values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                File file = (File)iterator.next();
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }

    private static class EmptyIterator
    implements Iterator<BooleanNode> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public BooleanNode next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

