/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.bddmemory;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.IntegerVerifier;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAralia;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAraliaTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionsAralia4Panel
extends JPanel {
    public static final int MINBDDSIZE = 4093;
    public static final int MAXBDDSIZE = 16381;
    private JLabel _configLabel = new JLabel(ResCompute.getString("DLG_ARALIA_CONFIGURATION"));
    private JComboBox _configChoice = new JComboBox();
    private static final int NB_FIELD_INT = 10;
    private static final int NB_FIELD_FLOAT = 4;
    private static final int NB_FIELD = 14;
    private OptionsAraliaTextField[] _textFieldsInt = new OptionsAraliaTextField[10];
    private OptionsAraliaTextField[] _textFieldsDouble = new OptionsAraliaTextField[4];
    private JLabel[] _labelTextFields = new JLabel[14];
    private JLabel _clearUselessComputationsLabel = new JLabel(ResCompute.getString("DLG_ARALIA_CLEAR_USELESS"));
    private JComboBox _clearUselessComputationsCombo = new JComboBox();
    private JLabel _strategyReorderingLabel = new JLabel(ResCompute.getString("DLG_ARALIA_STRATEGY_REORDERING"));
    private JComboBox _strategyReorderingCombo = new JComboBox();
    private OptionsAralia _configurator;
    private Map<OptionsAralia.Type, Map<String, String>> _configs = new HashMap<OptionsAralia.Type, Map<String, String>>();

    public OptionsAralia4Panel() {
        this.createPanel();
    }

    public void configurate(OptionsAralia config) {
        this._configurator = config;
        OptionsAralia.Type typeConfig = this._configurator.getConfig();
        this._configChoice.setSelectedItem((Object)typeConfig);
        this.selectConfig(typeConfig);
    }

    public OptionsAralia.Type getTypeConfig() {
        return (OptionsAralia.Type)((Object)this._configChoice.getSelectedItem());
    }

    public Map<String, String> getUserConfig() {
        OptionsAralia.Type typeConfig = this.getTypeConfig();
        Map<String, String> config = this._configs.get((Object)typeConfig);
        if (typeConfig == OptionsAralia.Type.CFGUser) {
            this.copyFromCtrl(config);
        }
        return config;
    }

    private void createPanel() {
        int i;
        for (i = 0; i < 10; ++i) {
            this._textFieldsInt[i] = new OptionsAraliaTextField(10, false);
        }
        this._textFieldsInt[9].setInputVerifier(new IntegerVerifier(){

            @Override
            protected boolean valueIsGood(int value) {
                return value >= 4093 && value <= 16381;
            }

            @Override
            protected String msgError() {
                return MessageFormat.format(ResCompute.getString("DLG_ARALIA_ERREUR_TABLE_SIZE"), 4093, 16381);
            }
        });
        for (i = 0; i < 4; ++i) {
            this._textFieldsDouble[i] = new OptionsAraliaTextField(10, true);
        }
        this._labelTextFields[0] = new JLabel(ResCompute.getString("DLG_ARALIA_PERIODE_GARBAGE"));
        this._labelTextFields[1] = new JLabel(ResCompute.getString("DLG_ARALIA_TAILLE_TABLE_BDD"));
        this._labelTextFields[2] = new JLabel(ResCompute.getString("DLG_ARALIA_NOMBRE_PAGES"));
        this._labelTextFields[3] = new JLabel(ResCompute.getString("DLG_ARALIA_MINIMUM"));
        this._labelTextFields[4] = new JLabel(ResCompute.getString("DLG_ARALIA_MAXIMUM"));
        this._labelTextFields[5] = new JLabel(ResCompute.getString("DLG_ARALIA_RATIO_PLUS"));
        this._labelTextFields[6] = new JLabel(ResCompute.getString("DLG_ARALIA_RATIO_MOINS"));
        this._labelTextFields[7] = new JLabel(ResCompute.getString("DLG_ARALIA_THRESHOLD_REORDERING"));
        this._labelTextFields[8] = new JLabel(ResCompute.getString("DLG_ARALIA_PERIOD_REORDERING"));
        this._labelTextFields[9] = new JLabel(ResCompute.getString("DLG_ARALIA_MINIMUM"));
        this._labelTextFields[10] = new JLabel(ResCompute.getString("DLG_ARALIA_MAXIMUM"));
        this._labelTextFields[11] = new JLabel(ResCompute.getString("DLG_ARALIA_RATIO_PLUS"));
        this._labelTextFields[12] = new JLabel(ResCompute.getString("DLG_ARALIA_RATIO_MOINS"));
        this._labelTextFields[13] = new JLabel(ResCompute.getString("DLG_ARALIA_DIMENSION"));
        this._strategyReorderingCombo.addItem(ResCompute.getString("DLG_ARALIA_OFF"));
        this._strategyReorderingCombo.addItem(ResCompute.getString("DLG_ARALIA_ON"));
        this._clearUselessComputationsCombo.addItem(ResCompute.getString("DLG_ARALIA_OFF"));
        this._clearUselessComputationsCombo.addItem(ResCompute.getString("DLG_ARALIA_ON"));
        this._configChoice.addItem(OptionsAralia.Type.CFG1);
        this._configChoice.addItem(OptionsAralia.Type.CFG2);
        this._configChoice.addItem(OptionsAralia.Type.CFG3);
        this._configChoice.addItem(OptionsAralia.Type.CFGUser);
        this._configChoice.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((OptionsAralia.Type)((Object)value)).getLabel());
                return this;
            }
        });
        this._configChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsAralia4Panel.this.selectConfig((OptionsAralia.Type)((Object)OptionsAralia4Panel.this._configChoice.getSelectedItem()));
            }
        });
        JPanel garbageCollectorPanel = new JPanel();
        garbageCollectorPanel.setLayout(new GridBagLayout());
        garbageCollectorPanel.add((Component)this._labelTextFields[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._textFieldsInt[0], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._labelTextFields[1], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._textFieldsInt[1], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._labelTextFields[2], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._textFieldsInt[2], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._clearUselessComputationsLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._clearUselessComputationsCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._labelTextFields[13], new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 5, 5), 0, 0));
        garbageCollectorPanel.add((Component)this._textFieldsInt[9], new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 5, 5), 0, 0));
        JPanel hashCachePanel = new JPanel();
        hashCachePanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ARALIA_HASHCACHE")));
        hashCachePanel.setLayout(new GridBagLayout());
        hashCachePanel.add((Component)this._labelTextFields[3], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashCachePanel.add((Component)this._textFieldsInt[3], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        hashCachePanel.add((Component)this._labelTextFields[4], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashCachePanel.add((Component)this._textFieldsInt[4], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        hashCachePanel.add((Component)this._labelTextFields[5], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashCachePanel.add((Component)this._textFieldsDouble[0], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        hashCachePanel.add((Component)this._labelTextFields[6], new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashCachePanel.add((Component)this._textFieldsDouble[1], new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        JPanel reorderingPanel = new JPanel();
        reorderingPanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ARALIA_REORDERING")));
        reorderingPanel.setLayout(new GridBagLayout());
        reorderingPanel.add((Component)this._strategyReorderingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        reorderingPanel.add((Component)this._strategyReorderingCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        reorderingPanel.add((Component)this._labelTextFields[7], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        reorderingPanel.add((Component)this._textFieldsInt[5], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        reorderingPanel.add((Component)this._labelTextFields[8], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        reorderingPanel.add((Component)this._textFieldsInt[6], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        JPanel hashTablesPanel = new JPanel();
        hashTablesPanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ARALIA_HASHTABLES")));
        hashTablesPanel.setLayout(new GridBagLayout());
        hashTablesPanel.add((Component)this._labelTextFields[9], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._textFieldsInt[7], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._labelTextFields[10], new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._textFieldsInt[8], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._labelTextFields[11], new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._textFieldsDouble[2], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._labelTextFields[12], new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        hashTablesPanel.add((Component)this._textFieldsDouble[3], new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        JPanel detailPanel = new JPanel();
        detailPanel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ARALIA_DETAILS")));
        detailPanel.setLayout(new GridBagLayout());
        detailPanel.add((Component)garbageCollectorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        detailPanel.add((Component)hashCachePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        detailPanel.add((Component)reorderingPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        detailPanel.add((Component)hashTablesPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._configLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 10, 1), 0, 0));
        this.add((Component)this._configChoice, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(10, 1, 10, 10), 0, 0));
        this.add((Component)detailPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    private void selectConfig(OptionsAralia.Type typeConfig) {
        Map<String, String> config = this._configs.get((Object)typeConfig);
        if (config == null) {
            config = this._configurator.getConfigOptions(typeConfig);
            if (typeConfig == OptionsAralia.Type.CFGUser) {
                config = new LinkedHashMap<String, String>(config);
            }
            this._configs.put(typeConfig, config);
        }
        if (typeConfig == OptionsAralia.Type.CFGUser) {
            this.editTextField(this._textFieldsInt, true);
            this.editTextField(this._textFieldsDouble, true);
            this._clearUselessComputationsCombo.setEnabled(true);
            this._strategyReorderingCombo.setEnabled(true);
        } else {
            this.editTextField(this._textFieldsInt, false);
            this.editTextField(this._textFieldsDouble, false);
            this._clearUselessComputationsCombo.setEnabled(false);
            this._strategyReorderingCombo.setEnabled(false);
        }
        this.copyToCtrl(config);
    }

    public boolean validateData() {
        int max;
        int i;
        if (this.getTypeConfig() != OptionsAralia.Type.CFGUser) {
            return true;
        }
        for (i = 0; i < this._textFieldsInt.length; ++i) {
            if (this._textFieldsInt[i].getText().length() != 0) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_CHAMP_VIDE"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            return false;
        }
        for (i = 0; i < this._textFieldsDouble.length; ++i) {
            if (this._textFieldsDouble[i].getText().length() != 0) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_CHAMP_VIDE"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            return false;
        }
        int min = Integer.parseInt(this._textFieldsInt[3].getText());
        if (min > (max = Integer.parseInt(this._textFieldsInt[4].getText()))) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_HASHCACHE"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            this._textFieldsInt[3].setText(this._textFieldsInt[3].getPreviousValue());
            this._textFieldsInt[4].setText(this._textFieldsInt[4].getPreviousValue());
            return false;
        }
        min = Integer.parseInt(this._textFieldsInt[7].getText());
        if (min > (max = Integer.parseInt(this._textFieldsInt[8].getText()))) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("DLG_ARALIA_ERREUR_HASHTABLE"), ResCompute.getString("DLG_ARALIA_ERREUR_PARAMETRES"), 0);
            this._textFieldsInt[7].setText(this._textFieldsInt[7].getPreviousValue());
            this._textFieldsInt[8].setText(this._textFieldsInt[8].getPreviousValue());
            return false;
        }
        return true;
    }

    private void editTextField(JTextField[] textfield, boolean active) {
        int size = textfield.length;
        for (int i = 0; i < size; ++i) {
            textfield[i].setEditable(active);
        }
    }

    private void copyFromCtrl(Map<String, String> map) {
        map.put("bdd-unique-table maximum-page-number", this._textFieldsInt[2].getText());
        map.put("bdd-unique-table default-page-size", this._textFieldsInt[1].getText());
        map.put("bdd-hashtables maximum-size", this._textFieldsInt[8].getText());
        map.put("bdd-hashtables minimum-size", this._textFieldsInt[7].getText());
        map.put("bdd-hashtables enlargement-ratio", this._textFieldsDouble[2].getText());
        map.put("bdd-hashtables reduction-ratio", this._textFieldsDouble[3].getText());
        map.put("bdd-entry-table size", this._textFieldsInt[9].getText());
        map.put("bdd-hashcache maximum-size", this._textFieldsInt[4].getText());
        map.put("bdd-hashcache minimum-size", this._textFieldsInt[3].getText());
        map.put("bdd-hashcache enlargement-ratio", this._textFieldsDouble[0].getText());
        map.put("bdd-hashcache reduction-ratio", this._textFieldsDouble[1].getText());
        map.put("bdd-garbage-collection period", this._textFieldsInt[0].getText());
        map.put("bdd-reordering strategy", (String)this._strategyReorderingCombo.getSelectedItem());
        map.put("bdd-reordering threshold", this._textFieldsInt[5].getText());
        map.put("bdd-reordering period", this._textFieldsInt[6].getText());
        map.put("sift maximum-growth", "2");
        map.put("sifting minimum-ratio", "0.5");
        map.put("round-robin minimum-improvement", "0.5");
        if (this._clearUselessComputationsCombo.getSelectedItem().equals("on")) {
            map.put("clear-useless-computations", "on");
        }
    }

    private void copyToCtrl(Map<String, String> map) {
        this._textFieldsInt[0].setText(map.get("bdd-garbage-collection period"));
        this._textFieldsInt[1].setText(map.get("bdd-unique-table default-page-size"));
        this._textFieldsInt[2].setText(map.get("bdd-unique-table maximum-page-number"));
        this._textFieldsInt[3].setText(map.get("bdd-hashcache minimum-size"));
        this._textFieldsInt[4].setText(map.get("bdd-hashcache maximum-size"));
        this._textFieldsDouble[0].setText(map.get("bdd-hashcache enlargement-ratio"));
        this._textFieldsDouble[1].setText(map.get("bdd-hashcache reduction-ratio"));
        this._textFieldsInt[5].setText(map.get("bdd-reordering threshold"));
        this._textFieldsInt[6].setText(map.get("bdd-reordering period"));
        this._textFieldsInt[7].setText(map.get("bdd-hashtables minimum-size"));
        this._textFieldsInt[8].setText(map.get("bdd-hashtables maximum-size"));
        this._textFieldsDouble[2].setText(map.get("bdd-hashtables enlargement-ratio"));
        this._textFieldsDouble[3].setText(map.get("bdd-hashtables reduction-ratio"));
        this._textFieldsInt[9].setText(map.get("bdd-entry-table size"));
        this._strategyReorderingCombo.setSelectedItem(map.get("bdd-reordering strategy"));
        if (map.containsKey("clear-useless-computations")) {
            this._clearUselessComputationsCombo.setSelectedItem(map.get("clear-useless-computations"));
        } else {
            this._clearUselessComputationsCombo.setSelectedIndex(0);
        }
    }
}

