/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.PartialCheckBox;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeStd;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class DlgPanelComputeMEL
extends DlgPanelComputeStd {
    Plugable _plugable;
    private PartialCheckBox _ctrlSimplified;
    private boolean _forceSimplified = false;
    private PartialCheckBox _ctrlApproximate;
    private boolean _forcePessimist = false;
    private PartialCheckBox _ctrlListCheck;
    private File _listFile;
    private JTextField _ctrlListPath;
    JButton _ctrlListBut;
    private static JFileChooser __dlgFileChooser = null;

    public DlgPanelComputeMEL(Plugable plugable) {
        this._plugable = plugable;
        this._ctrlSimplified = new PartialCheckBox(ResCompute.getString("DLG_PARAM_MEL_SIMPLIFIED"));
        this._ctrlSimplified.setToolTipText(ResCompute.getString("DLG_PARAM_MEL_SIMPLIFIED_TOOLTIP"));
        this._ctrlSimplified.setAsymetricChangeValue(true);
        this._ctrlSimplified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPanelComputeMEL.this.refreshCtrlSimplified();
                DlgPanelComputeMEL.this.updateCtrls();
            }
        });
        this._ctrlApproximate = new PartialCheckBox(ResCompute.getString("DLG_PARAM_MEL_APPROX"));
        this._ctrlApproximate.setToolTipText(ResCompute.getString("DLG_PARAM_MEL_APPROX_TOOLTIP"));
        this._ctrlApproximate.setAsymetricChangeValue(true);
        this._ctrlListCheck = new PartialCheckBox(ResCompute.getString("DLG_PARAM_MEL_LIST"));
        this._ctrlListCheck.setAsymetricChangeValue(true);
        this._ctrlListPath = new JTextField(20);
        this._ctrlListPath.setEditable(false);
        this._ctrlListPath.setEnabled(false);
        this._ctrlListBut = new JButton("...");
        this._ctrlListBut.setEnabled(false);
        this._ctrlListBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser dlg = DlgPanelComputeMEL.getDlgFileChooser(DlgPanelComputeMEL.this._plugable);
                if (DlgPanelComputeMEL.this._listFile != null) {
                    dlg.setSelectedFile(DlgPanelComputeMEL.this._listFile);
                    File listDir = DlgPanelComputeMEL.this._listFile.getParentFile();
                    if (listDir.exists()) {
                        dlg.setCurrentDirectory(listDir);
                    }
                }
                if (dlg == null) {
                    return;
                }
                if (dlg.showOpenDialog(DlgPanelComputeMEL.this._ctrlListBut) != 0) {
                    return;
                }
                File selectedFile = dlg.getSelectedFile();
                if (selectedFile == null) {
                    return;
                }
                if (!DlgPanelComputeMEL.this.verifyListFile(selectedFile, false)) {
                    DlgPanelComputeMEL.this.setListFile(null);
                    return;
                }
                DlgPanelComputeMEL.this.setListFile(selectedFile);
            }
        });
        this._ctrlListCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPanelComputeMEL.this.refreshCtrlCheck();
            }
        });
    }

    @Override
    protected JComponent createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.add((Component)this._ctrlSimplified, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return headerPanel;
    }

    protected void refreshCtrlSimplified() {
        boolean selected;
        boolean bl = selected = this._ctrlSimplified.isSelected() && this._ctrlSimplified.getState() != PartialCheckBox.State.PARTIAL;
        if (selected) {
            Object itemSelect = this._ctrlPrType.getSelectedItem();
            this._ctrlPrType.removeItem(TypeProbability.BDD);
            if (itemSelect == TypeProbability.BDD || itemSelect == null) {
                this._ctrlPrType.setSelectedItem(TypeProbability.MCS);
            }
        } else {
            boolean find = false;
            for (int i = this._ctrlPrType.getModel().getSize() - 1; i >= 0 && !find; --i) {
                if (this._ctrlPrType.getModel().getElementAt(i) != TypeProbability.BDD) continue;
                find = true;
            }
            if (!find) {
                this._ctrlPrType.insertItemAt(TypeProbability.BDD, 1);
            }
        }
    }

    protected void refreshCtrlCheck() {
        boolean selected = this._ctrlListCheck.isSelected() && this._ctrlListCheck.getState() != PartialCheckBox.State.PARTIAL;
        this._ctrlListPath.setEnabled(selected);
        this._ctrlListBut.setEnabled(selected);
    }

    protected Map<Attr.Key, Set<String>> createAttributesMap() {
        return Collections.emptyMap();
    }

    @Override
    protected void addOptionnalCutsCtrl(JPanel cutPanel, int x, int y, int width) {
        cutPanel.add((Component)this._ctrlApproximate, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 5, 5), 0, 0));
    }

    @Override
    protected void addOptionnalProbaCtrl(JPanel prbPanel, int x, int y, int width) {
    }

    @Override
    protected boolean displayPostTreatment() {
        return true;
    }

    @Override
    protected void addOptionnalCtrls(JPanel panel, int x, int y, int width) {
        JPanel evtPanel = new JPanel((LayoutManager)new ToggleBorderLayout());
        JPanel internalPanel = new JPanel(new GridBagLayout());
        internalPanel.add((Component)this._ctrlListPath, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        internalPanel.add((Component)this._ctrlListBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        ToggleBorderLayout.configure((Container)evtPanel, (JToggleButton)this._ctrlListCheck, (JComponent)internalPanel);
        panel.add((Component)evtPanel, new GridBagConstraints(x, y++, width, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    protected boolean displayLatent() {
        return false;
    }

    @Override
    protected void updateCtrls() {
        boolean selectedSimplified;
        super.updateCtrls();
        boolean bl = selectedSimplified = this._ctrlSimplified.isSelected() && !this._ctrlSimplified.isPartial();
        if (selectedSimplified) {
            this._ctrlCutTruncated.setEnabled(false);
            this._ctrlCutLbl.setEnabled(false);
            this._ctrlCutOrder.setEnabled(false);
            this._ctrlApproximate.setEnabled(false);
        } else {
            this._ctrlCutTruncated.setEnabled(true);
            boolean seletedTrunc = this._ctrlCutTruncated.isSelected() && !this._ctrlCutTruncated.isPartial();
            this._ctrlCutOrder.setEnabled(seletedTrunc);
            this._ctrlCutLbl.setEnabled(seletedTrunc);
            if (!seletedTrunc || this._forcePessimist) {
                this._ctrlApproximate.setEnabled(false);
                this._ctrlApproximate.setSelected(this._forcePessimist);
            } else {
                this._ctrlApproximate.setEnabled(true);
            }
        }
    }

    @Override
    public boolean verifyParameters() {
        if (!super.verifyParameters()) {
            return false;
        }
        if (this._ctrlListCheck.isSelected() && this._ctrlListCheck.getState() != PartialCheckBox.State.PARTIAL) {
            if (this._listFile == null || !this._listFile.exists() || !this._listFile.canRead()) {
                this._ctrlListBut.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlListBut), ResCompute.getString("DLG_PARAM_ERR_MEL_FILE"));
                return false;
            }
            if (!this.verifyListFile(this._listFile, true)) {
                return false;
            }
        }
        return true;
    }

    protected boolean verifyListFile(File file, boolean confirm) {
        return true;
    }

    void setListFile(File listFile) {
        this._listFile = listFile;
        if (this._listFile != null) {
            this._ctrlListPath.setText(this._listFile.getPath());
        } else {
            this._ctrlListPath.setText("");
        }
    }

    private static synchronized JFileChooser getDlgFileChooser(Plugable plugable) {
        if (__dlgFileChooser == null) {
            __dlgFileChooser = new JFileChooser();
            JChooserFileUtility.configureCurrentDirectory((JFileChooser)__dlgFileChooser, (Plugable)plugable);
            JChooserFileUtility.configureFileFilter((JFileChooser)__dlgFileChooser, (JChooserFileUtility.Type)JChooserFileUtility.Type.XML);
        }
        return __dlgFileChooser;
    }

    public void defaultValues() {
        this._ctrlListCheck.setSelected(false);
        this.setListFile(null);
        this.refreshCtrlCheck();
        this._ctrlApproximate.setSelected(this._forcePessimist);
    }

    public void configureSimplified(Boolean simplifiedMode, boolean forceTrue) {
        this._forceSimplified = forceTrue;
        if (this._forceSimplified) {
            this._ctrlSimplified.setSelected(true);
            this._ctrlSimplified.setEnabled(false);
        } else {
            if (simplifiedMode == null) {
                this._ctrlSimplified.setPartial(true);
                this._ctrlSimplified.setState(PartialCheckBox.State.PARTIAL);
            } else {
                this._ctrlSimplified.setPartial(false);
                this._ctrlSimplified.setSelected(simplifiedMode.booleanValue());
            }
            this._ctrlSimplified.updateUI();
        }
        this.refreshCtrlSimplified();
    }

    public void configureApproximate(Boolean pessimistCompute, boolean forceTrue) {
        this._forcePessimist = forceTrue;
        if (this._forcePessimist) {
            this._ctrlApproximate.setSelected(true);
            return;
        }
        if (this.getLimitOrder() == null || this.getLimitOrder() < 0) {
            this._ctrlApproximate.setSelected(false);
            return;
        }
        if (pessimistCompute == null) {
            this._ctrlApproximate.setPartial(true);
            this._ctrlApproximate.setState(PartialCheckBox.State.PARTIAL);
        } else {
            this._ctrlApproximate.setPartial(false);
            this._ctrlApproximate.setSelected(pessimistCompute.booleanValue());
        }
        this._ctrlApproximate.updateUI();
    }

    public void configureListFile(Boolean checkList, File listFile) {
        if (checkList == null) {
            this._ctrlListCheck.setSelected(true);
            this._ctrlListCheck.setState(PartialCheckBox.State.PARTIAL);
        } else {
            this._ctrlListCheck.setSelected(checkList.booleanValue());
        }
        this._ctrlListCheck.updateUI();
        if (checkList != null && checkList.booleanValue() && listFile != null) {
            this.setListFile(listFile);
        } else {
            this.setListFile(null);
        }
        this.refreshCtrlCheck();
    }

    public Boolean isSimplified() {
        if (this._ctrlSimplified.getState() == PartialCheckBox.State.PARTIAL) {
            return null;
        }
        return this._ctrlSimplified.isSelected();
    }

    public Boolean isApproximate() {
        if (this._ctrlApproximate.getState() == PartialCheckBox.State.PARTIAL) {
            return null;
        }
        return this._ctrlApproximate.isSelected();
    }

    public File getListFile() {
        if (this._ctrlListCheck.isSelected()) {
            return this._listFile;
        }
        return null;
    }
}

