/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.lib.mcs.CutUser;
import com.dassault.cecilia.lib.mcs.McsToAralia;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderHelper;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineMELHelper;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class EngineMELHelperAbstract
implements EngineMELHelper,
Runnable {
    private static Logger _LOG = Logger.getLogger(EngineMELHelperAbstract.class.getPackage().getName());
    Map<String, BooleanNode> _mapNameEngineToNode;
    protected String _currentTarget;
    List<File> _tmpFiles = new ArrayList<File>();

    protected abstract BooleanStore getStore();

    protected abstract BooleanMEL getResult();

    protected EngineMELHelperAbstract() {
        this._mapNameEngineToNode = new HashMap<String, BooleanNode>();
    }

    @Override
    public void setCurrentTarget(String tgt) {
        this._currentTarget = tgt;
    }

    public void prepare() {
        Iterator<BooleanNode> iNode = this.getStore().iterate();
        while (iNode.hasNext()) {
            BooleanNode node = iNode.next();
            if (!node.isLeaf()) continue;
            this._mapNameEngineToNode.put(node.getEngineName(), node);
        }
    }

    @Override
    public File createTmpFile() throws IOException {
        File tmpFile = File.createTempFile("EngineMEL", ".tmp");
        this._tmpFiles.add(tmpFile);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Appendable output, boolean forAralia, String pathResult, boolean nominal) throws IOException {
        ParamComputeMEL parameters = this.getParameters();
        if (nominal && parameters.getLimitOrder() > 0 && parameters.withPessimistCompute() && !parameters.withMCSResult()) {
            int limitOrder = parameters.getLimitOrder();
            try {
                parameters.setLimitOrder(limitOrder + 1);
                parameters.generateComputeScript(output, this.getStore().getRoot(), forAralia, pathResult, this.getStore().iterate());
            }
            finally {
                parameters.setLimitOrder(limitOrder);
            }
        } else {
            parameters.generateComputeScript(output, this.getStore().getRoot(), forAralia, pathResult, this.getStore().iterate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanResult readResult(String pathResult, final ActionControl ctrl) throws IOException {
        BooleanResult boolResult = new BooleanResult(this.getStore(), null);
        try (Reader resReader = null;){
            resReader = new BufferedReader(new FileReader(pathResult));
            MCSReaderHelper helper = new MCSReaderHelper(){

                @Override
                public boolean isCanceled() {
                    return ctrl.isCanceled();
                }
            };
            boolResult.parse(this.getStore().getRoot(), resReader, helper);
            if (helper.hasLimited()) {
                this.addWarning(helper.getWarningMsg());
            }
        }
        return boolResult;
    }

    @Override
    public BooleanResult postTreatResult(BooleanResult result, ActionControl ctrl) throws IOException {
        BooleanMCS originMCS;
        BooleanMCS currentMCS = originMCS = result.getMCS();
        if (this.getParameters().getPostTreatmentDormant().booleanValue()) {
            switch (this.getParameters().getTypeProbability()) {
                case ARP1: 
                case ARP3: 
                case MCS: {
                    BooleanMCS evidentMCS = currentMCS.postTreatmentHide(this.getParameters().getMissionTimeH());
                    if (evidentMCS == currentMCS) {
                        this.addWarning(ResCompute.getString("PTD_ERROR_NO_DORMANT"));
                    }
                    currentMCS = evidentMCS;
                    break;
                }
                default: {
                    this.addError(ResCompute.getString("PTD_ERROR_COMPUTE_TYPE"));
                    throw new IOException(ResCompute.getString("PTD_ERROR_COMPUTE_TYPE"));
                }
            }
        }
        if (this.getParameters().getPostTreatmentAtRisk().booleanValue()) {
            switch (this.getParameters().getTypeProbability()) {
                case ARP1: 
                case ARP3: 
                case MCS: {
                    BooleanMCS endOfFlyMCS = currentMCS.postTreatmentRisk(this.getParameters().getSpecificTimeH());
                    if (endOfFlyMCS == null) {
                        this.addError(ResCompute.getString("PTF_DORMANT_ERROR"));
                        throw new IOException(ResCompute.getString("PTF_DORMANT_ERROR"));
                    }
                    currentMCS = endOfFlyMCS;
                    break;
                }
                default: {
                    this.addError(ResCompute.getString("PTD_ERROR_COMPUTE_TYPE"));
                    throw new IOException(ResCompute.getString("PTD_ERROR_COMPUTE_TYPE"));
                }
            }
        }
        if (originMCS != currentMCS) {
            return new BooleanResult(currentMCS, new ParamComputeMCS(this.getParameters()));
        }
        return result;
    }

    @Override
    public void computeProbabilities(BooleanResult result, ActionControl ctrl) {
        result.computeProbabilities(this.getParameters().getTypeProbability(), this.getParameters().getMissionTimeH(), ctrl);
    }

    @Override
    public boolean withPessimistCompute() {
        return this.getParameters().withPessimistCompute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File defineEquationFromMCS(BooleanMCS resultMCS) throws IOException {
        if (!this.withPessimistCompute()) {
            return null;
        }
        File tmpFile = this.createTmpFile();
        try (Writer araWriter = null;){
            araWriter = new BufferedWriter(new FileWriter(tmpFile));
            McsToAralia mcs2Aralia = new McsToAralia(null, araWriter);
            mcs2Aralia.beginSet();
            mcs2Aralia.setTop(this.getStore().getRoot().getEngineName());
            BooleanMCS.BooleanMCSOrderCutIterator cutIter = resultMCS.cutIterate();
            class CutProxy
            extends AbstractCollection<String>
            implements CutUser,
            Iterator<String> {
                Cut _cut;
                int _idx;

                CutProxy() {
                }

                public Collection<String> getEvents() {
                    return this;
                }

                @Override
                public int size() {
                    return this._cut.getOrder();
                }

                @Override
                public Iterator<String> iterator() {
                    this._idx = 0;
                    return this;
                }

                @Override
                public boolean hasNext() {
                    return this._idx < this._cut.getOrder();
                }

                @Override
                public String next() {
                    return this._cut.getEvent(this._idx++).toString();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            CutProxy cutProxy = new CutProxy();
            while (cutIter.hasNext()) {
                cutProxy._cut = cutIter.next();
                mcs2Aralia.addCut((CutUser)cutProxy);
            }
            mcs2Aralia.endSet();
        }
        return tmpFile;
    }

    @Override
    public void addResult(String tgt, BooleanResult result) {
        if (tgt == null) {
            this.getResult().addItem(null, result);
        } else {
            BooleanNode node = this._mapNameEngineToNode.get(tgt);
            if (node != null) {
                this.getResult().addItem(node, result);
            } else {
                _LOG.info("No node into store for name : " + tgt);
            }
        }
    }

    @Override
    public void run() {
        for (File file : this._tmpFiles) {
            if (!file.exists() || !Boolean.getBoolean("cecilia.ft.compute.KeepFile.MEL") && file.delete()) continue;
            file.deleteOnExit();
        }
    }
}

