/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.DlgPanelTime;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableColorPreferencies;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatStandard;
import com.dassault.cecilia.plugin.faulttree.compute.pref.DisplayDefaultMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.awt.Color;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ArborPreferenciesRenderer
implements ArborRenderer {
    boolean _bAltenateRenderer = false;
    Color _colorFalse = new Color(255, 45, 84);
    Color _colorTrue = new Color(130, 255, 185);
    Color _colorError = Color.red;
    Color _colorExtern = Color.red;
    Color _colorSelect = Color.lightGray;
    Color _colorSelectNo = Color.white;
    Color _colorNormal = Color.black;
    private DoubleFormat _format = new DoubleFormatStandard("0.000E00", new DecimalFormatSymbols(Locale.ENGLISH));

    @Override
    public Color getColor(ArborRenderer.DisplayColor type) {
        switch (type) {
            case FGExtern: {
                return this._colorExtern;
            }
            case FGCCF: 
            case FGOther: {
                return this._colorNormal;
            }
            case BGNormalSelectedLast: {
                return this._colorSelect;
            }
            case BGNormalSelected: {
                return this._colorSelect;
            }
            case BGNormal: {
                return this._colorSelectNo;
            }
            case BGTrue: {
                return this._colorTrue;
            }
            case BGFalse: {
                return this._colorFalse;
            }
            case FGError: {
                return this._colorError;
            }
        }
        return Color.white;
    }

    @Override
    public String formatNumber(double value) {
        return this._format.format(value);
    }

    @Override
    public String formatProbability(double value) {
        if (value <= 0.0) {
            return "-";
        }
        if (Double.isNaN(value)) {
            return "-";
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return this._format.format(value);
    }

    @Override
    public double convertProbability(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    @Override
    public String formatMissionTime(double timeSec) {
        return DlgPanelTime.formatMissionTime((double)timeSec);
    }

    public ArborPreferenciesRenderer(Plugable plugable) {
        PluginWithOptions pref = plugable.getPreferencies(GeneralTextPreferencies.PREF_KEY);
        if (pref != null && pref instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies txtPref = (GeneralTextPreferencies)pref;
            this._format = txtPref.getDoubleFormat();
        }
        if ((pref = plugable.getPreferencies(FTVariableColorPreferencies.PREF_KEY)) != null && pref instanceof FTVariableColorPreferencies) {
            FTVariableColorPreferencies colorPref = (FTVariableColorPreferencies)pref;
            this._colorTrue = colorPref.getPref("EvtTrue").getColor();
            this._colorFalse = colorPref.getPref("EvtFalse").getColor();
            this._colorNormal = colorPref.getPref("EvtForeNormal").getColor();
            this._colorExtern = colorPref.getPref("EvtForeExtern").getColor();
            this._colorSelect = colorPref.getPref("EvtSelected").getColor();
            this._colorSelectNo = colorPref.getPref("EvtNormal").getColor();
        }
        this._bAltenateRenderer = PlugableUtility.getBoolOpt((Plugable)plugable, (String)DisplayDefaultMCS.PREF_MCS_RENDERER_ALT, (boolean)false);
    }

    @Override
    public boolean isAltRenderer() {
        return this._bAltenateRenderer;
    }
}

