/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSortingInOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MCSSorterOrder
implements MCSSorter {
    boolean _sorterWithProba;
    List<List<Cut>> _tmpCuts;
    List<Cut[]> _resCuts;
    Comparator<Cut> _comparator;
    static final int[] __INIT_CAPACITY = new int[]{1, 16, 256, 1024, 4096};
    boolean _isSorting = false;
    Object _lockerThread = new Object();
    static Comparator<Cut> _comparatorLexico = new Comparator<Cut>(){

        @Override
        public int compare(Cut cut1, Cut cut2) {
            int order1 = cut1.getOrder();
            for (int i = 0; i < order1; ++i) {
                int idx2;
                int idx1 = cut1.getEvent(i).getIndex();
                if (idx1 < (idx2 = cut2.getEvent(i).getIndex())) {
                    return -1;
                }
                if (idx1 <= idx2) continue;
                return 1;
            }
            return 0;
        }
    };
    static Comparator<Cut> _comparatorProbaLexico = new Comparator<Cut>(){

        @Override
        public int compare(Cut cut1, Cut cut2) {
            int cmpProba = Double.compare(cut1.getProbability(), cut2.getProbability());
            if (cmpProba != 0) {
                return -cmpProba;
            }
            int order1 = cut1.getOrder();
            for (int i = 0; i < order1; ++i) {
                int idx2;
                int idx1 = cut1.getEvent(i).getIndex();
                if (idx1 < (idx2 = cut2.getEvent(i).getIndex())) {
                    return -1;
                }
                if (idx1 <= idx2) continue;
                return 1;
            }
            return 0;
        }
    };

    public MCSSorterOrder(boolean sorterProba) {
        this._sorterWithProba = sorterProba;
        this._comparator = this._sorterWithProba ? _comparatorProbaLexico : _comparatorLexico;
        this._isSorting = false;
        this._tmpCuts = new ArrayList<List<Cut>>();
    }

    @Override
    public void addCut(Cut cut) {
        if (this._isSorting) {
            throw new UnsupportedOperationException();
        }
        int order = cut.getOrder();
        while (this._tmpCuts.size() <= order) {
            int len = this._tmpCuts.size();
            this._tmpCuts.add(new ArrayList(len < __INIT_CAPACITY.length ? __INIT_CAPACITY[len] : 4096));
        }
        this._tmpCuts.get(order).add(cut);
    }

    protected void finishSorter() {
        this._resCuts = new ArrayList<Cut[]>(this._tmpCuts.size());
        for (int i = 0; i < this._tmpCuts.size(); ++i) {
            List<Cut> tmpCuts = this._tmpCuts.get(i);
            Cut[] resCuts = new Cut[tmpCuts.size()];
            if (resCuts.length == 0) {
                this._resCuts.add(resCuts);
            } else {
                resCuts = tmpCuts.toArray(resCuts);
                Arrays.sort(resCuts, this._comparator);
                this._resCuts.add(resCuts);
            }
            this._tmpCuts.set(i, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MCS getMCS() {
        if (!this._isSorting) {
            Object object = this._lockerThread;
            synchronized (object) {
                this.finishSorter();
                this._isSorting = true;
            }
        }
        return new MCSSortingInOrder(this._resCuts);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MCSSorterOrder)) {
            return false;
        }
        MCSSorterOrder sorterOrder = (MCSSorterOrder)obj;
        return sorterOrder._sorterWithProba == this._sorterWithProba;
    }

    public int hashCode() {
        return this._sorterWithProba ? 1 : 0;
    }
}

