/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.pref.DisplayDefaultMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterLatent;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterNone;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterStandard;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilterWeight;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTable;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTableModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableModel;

public class MCSTablePanel
extends JPanel {
    MCS _mcs;
    MCS _mcsFilter;
    MCSTableModel _modelTable;
    MCSTable _table;
    ArborRenderer _renderer;
    boolean _withProbability;
    Map<Attr.Key, Set<String>> _attributes;
    JComboBox _filterSel;
    JButton _filterBut;
    MCSFilter _filterPrevious;
    JComboBox _sorterSel;
    boolean _sorterNull;
    JComboBox _limitedSel;
    boolean _flagCallRefreshSorterFilter = false;
    protected EventListenerList _listenerList = new EventListenerList();

    public MCSTablePanel(MCS mcs, ArborRenderer renderer, boolean withProbability, Map<Attr.Key, Set<String>> attributes) {
        super(new GridBagLayout());
        this._mcs = this._mcsFilter = mcs;
        this._modelTable = new MCSTableModel(this._mcsFilter, renderer);
        this._renderer = renderer;
        this._withProbability = withProbability;
        this._attributes = attributes;
        this.create();
    }

    public void refreshRenderer() {
        this._modelTable.fireTableChanged(new TableModelEvent((TableModel)((Object)this._modelTable), 0, this._modelTable.getRowCount(), 0));
    }

    protected boolean withFilter() {
        return true;
    }

    protected boolean withSorter() {
        return true;
    }

    protected boolean withLimited() {
        return true;
    }

    protected void create() {
        CApplInit appl = CApplInit.getInstance();
        List listPrefs = null;
        if (appl != null && appl instanceof CeciliaAppl) {
            CeciliaAppl application = (CeciliaAppl)appl;
            Object prefs = application.getPreferencies().getOptions(DisplayDefaultMCS.PREF_KEY);
            if (prefs == null || !(prefs instanceof DisplayDefaultMCS)) {
                prefs = new DisplayDefaultMCS();
                application.getPreferencies().addOptions(prefs);
                prefs.refreshOptions((Plugable)application.getPlugable());
            }
            listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
        }
        this._modelTable.getColumnModel().setOptionnalFields(PrefFieldsFactory.clone(listPrefs));
        this._table = new MCSTable(this._modelTable, this._renderer);
        JPanel panelList = new JPanel(new GridBagLayout());
        int idxX = 0;
        JPanel panelFilter = new JPanel(new GridBagLayout());
        panelFilter.setBorder(BorderFactory.createEtchedBorder());
        int idxF = 0;
        panelFilter.add((Component)new JLabel(ResMsgVoc.getString((String)"VOC_FILTER")), new GridBagConstraints(idxF++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        this._filterSel = new JComboBox();
        this._filterPrevious = new MCSFilterNone();
        this._filterSel.addItem(this._filterPrevious);
        this._filterSel.addItem(new MCSFilterStandard(this._mcs, this._renderer, this._withProbability, this._attributes));
        if (this._withProbability) {
            this._filterSel.addItem(new MCSFilterWeight(0.0));
        }
        if (this._attributes.size() > 0) {
            this._filterSel.addItem(new MCSFilterLatent(this._attributes));
        }
        this._filterSel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (MCSTablePanel.this._filterSel.isEnabled()) {
                    this.setText(((MCSFilter)value).getTitle());
                } else {
                    this.setText("");
                }
                return this;
            }
        });
        this._filterSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MCSFilter filter;
                Object selectedItem = MCSTablePanel.this._filterSel.getSelectedItem();
                MCSFilter mCSFilter = filter = selectedItem != null && selectedItem instanceof MCSFilter ? (MCSFilter)selectedItem : null;
                if (filter != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!filter.selectFilter(MCSTablePanel.this._filterSel)) {
                                MCSTablePanel.this._filterSel.setSelectedItem(MCSTablePanel.this._filterPrevious);
                                return;
                            }
                            MCSTablePanel.this._filterPrevious = filter;
                            MCSTablePanel.this.refreshSorterFilter();
                        }
                    });
                }
            }
        });
        panelFilter.add((Component)this._filterSel, new GridBagConstraints(idxF++, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        this._filterBut = new JButton("...");
        this._filterBut.setMargin(new Insets(0, 0, 0, 0));
        this._filterBut.setEnabled(false);
        this._filterBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = MCSTablePanel.this._filterSel.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                if (!(selectedItem instanceof MCSFilter)) {
                    return;
                }
                MCSFilter filter = (MCSFilter)selectedItem;
                if (!filter.withDialog()) {
                    return;
                }
                if (!filter.displayDialog(MCSTablePanel.this._filterSel)) {
                    return;
                }
                MCSTablePanel.this.callRefreshSorterFilter();
            }
        });
        panelFilter.add((Component)this._filterBut, new GridBagConstraints(idxF++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        if (this.withFilter()) {
            panelList.add((Component)panelFilter, new GridBagConstraints(idxX++, 0, 1, 1, 0.05, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        }
        JPanel panelSorter = new JPanel(new GridBagLayout());
        if (this.withLimited()) {
            panelSorter.setBorder(BorderFactory.createEtchedBorder());
        }
        int idxS = 0;
        panelSorter.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_SORTER")), new GridBagConstraints(idxS++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        this._sorterSel = new JComboBox();
        this._sorterNull = false;
        this._sorterSel.addItem(MCSSorter.Type.ORDER_LEXIC);
        if (this._withProbability) {
            this._sorterSel.addItem(MCSSorter.Type.ORDER_PROBA_LEXIC);
            this._sorterSel.addItem(MCSSorter.Type.PROBA_ORDER_LEXIC);
        }
        this._sorterSel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (MCSTablePanel.this._sorterNull) {
                    this.setText("");
                } else {
                    this.setText(((MCSSorter.Type)((Object)value)).getLabel());
                }
                return this;
            }
        });
        this._sorterSel.setEditable(false);
        panelSorter.add((Component)this._sorterSel, new GridBagConstraints(idxS++, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        this._sorterSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MCSTablePanel.this.callRefreshSorterFilter();
            }
        });
        if (this.withLimited()) {
            panelSorter.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_SORTER_LIMIT")), new GridBagConstraints(idxS++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        }
        this._limitedSel = new JComboBox<Object>(new Object[]{ResCompute.getString("DLG_RESULT_SORTER_LIMIT_NONE").trim(), 50, 100, 200, 500, 1000});
        this._limitedSel.setEditable(true);
        this._limitedSel.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                JTextField myEditor = new JTextField("", 4){

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public void setBorder(Border b) {
                        if (!(b instanceof BasicComboBoxEditor.UIResource)) {
                            super.setBorder(b);
                        }
                    }
                };
                myEditor.setBorder(null);
                return myEditor;
            }
        });
        this._limitedSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MCSTablePanel.this.callRefreshSorterFilter();
            }
        });
        if (this.withLimited()) {
            panelSorter.add((Component)this._limitedSel, new GridBagConstraints(idxS++, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        }
        if (this.withSorter()) {
            panelList.add((Component)panelSorter, new GridBagConstraints(idxX++, 0, 1, 1, 0.05, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        }
        JLabel glue = new JLabel();
        panelList.add((Component)glue, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        boolean optionnalGlue = false;
        if (this.withCAA()) {
            JButton caaDlg = new JButton(ResCompute.getString("VOC_C_A_A_"));
            caaDlg.setToolTipText(ResCompute.getString("CAA_EXPLICATION"));
            panelList.add((Component)caaDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
            caaDlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MCSTablePanel.this.launchCAA();
                }
            });
            optionnalGlue = true;
        }
        if (this.withPostTreatmentDormant()) {
            JButton caaDlg = new JButton(ResCompute.getString("VOC_DORMANT"));
            caaDlg.setToolTipText(ResCompute.getString("PTD_EXPLICATION"));
            panelList.add((Component)caaDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
            caaDlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MCSTablePanel.this.launchPostTreatmentDormant();
                }
            });
            optionnalGlue = true;
        }
        if (this.withPostTreatmentEndOfFly()) {
            JButton treatDlg = new JButton(ResCompute.getString("VOC_ENDOFFLY"));
            treatDlg.setToolTipText(ResCompute.getString("PTF_EXPLICATION"));
            panelList.add((Component)treatDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
            treatDlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MCSTablePanel.this.launchPostTreatmentEndOfFly();
                }
            });
            optionnalGlue = true;
        }
        if (optionnalGlue) {
            JLabel glue2 = new JLabel();
            panelList.add((Component)glue2, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        }
        JButton fieldsDlg = new JButton(ResMsgVoc.getString((String)"VOC_FIELDS"));
        panelList.add((Component)fieldsDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
        fieldsDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List originItems = MCSTablePanel.this._modelTable.getColumnModel().getOptionnalFields();
                List copyItems = PrefFieldsFactory.clone((List)originItems);
                if (!PrefFieldsFactory.displayDlgChangeFields((JComponent)((Object)MCSTablePanel.this._table), (List)copyItems)) {
                    return;
                }
                boolean change = PrefFieldsFactory.copySelected((List)copyItems, (List)originItems);
                if (change) {
                    MCSTablePanel.this._modelTable.getColumnModel().resetFilterIndexes();
                    MCSTablePanel.this._modelTable.refresh(false, true);
                }
            }
        });
        JScrollPane scrollTable = new JScrollPane((Component)((Object)this._table));
        panelList.add((Component)scrollTable, new GridBagConstraints(0, 1, idxX, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)panelList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.callRefreshSorterFilter();
    }

    public void trash() {
        this._mcs = null;
        this._modelTable = null;
        this._table = null;
    }

    private void callRefreshSorterFilter() {
        if (this._flagCallRefreshSorterFilter) {
            return;
        }
        this._flagCallRefreshSorterFilter = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MCSTablePanel.this.refreshSorterFilter();
            }
        });
    }

    public void refreshSorterFilter() {
        MCSFilter filter;
        this._flagCallRefreshSorterFilter = false;
        Object selectedItem = this._filterSel.getSelectedItem();
        MCSFilter mCSFilter = filter = selectedItem != null && selectedItem instanceof MCSFilter ? (MCSFilter)selectedItem : null;
        if (filter != null) {
            this._filterBut.setEnabled(filter.withDialog());
            int rankLimit = -1;
            Object selection = this._limitedSel.getSelectedItem();
            if (selection != null) {
                if (selection instanceof Integer) {
                    rankLimit = (Integer)selection;
                } else if (selection instanceof String) {
                    try {
                        rankLimit = Integer.parseInt((String)selection);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (rankLimit <= 0) {
                    if (!selection.equals(this._limitedSel.getItemAt(0))) {
                        this._limitedSel.setSelectedIndex(0);
                        return;
                    }
                    rankLimit = -1;
                }
            }
            MCSSorter.Type sorter = MCSSorter.Type.ORDER_LEXIC;
            Object selection2 = this._sorterSel.getSelectedItem();
            if (selection2 != null && selection2 instanceof MCSSorter.Type) {
                sorter = (MCSSorter.Type)((Object)selection2);
            }
            this.applySorterFilter(filter, sorter, rankLimit);
            String filterAbstract = filter.getAbstract();
            if (filterAbstract.length() > 0) {
                this._filterBut.setToolTipText(new StringBuffer().append("<html>").append(filterAbstract.replaceAll("\\n", "<br/>")).append("</html>").toString());
            } else {
                this._filterBut.setToolTipText(null);
            }
            if (filter instanceof MCSFilterWeight) {
                this._sorterSel.setEnabled(false);
                this._limitedSel.setEnabled(false);
                this._sorterNull = true;
            } else {
                this._sorterNull = false;
                this._sorterSel.setEnabled(this._sorterSel.getItemCount() > 1);
                this._limitedSel.setEnabled(true);
            }
            this.fireChangeTable(filter);
        } else {
            this._filterBut.setEnabled(false);
            this._mcsFilter = this._mcs;
            this._modelTable.changeMCS(this._mcsFilter);
            this._filterBut.setToolTipText("");
            this.fireChangeTable(null);
        }
    }

    private void applySorterFilter(MCSFilter filter, MCSSorter.Type sorter, int rankLimit) {
        filter.setRankLimit(rankLimit);
        filter.setTypeSorter(sorter);
        this._mcsFilter = filter.filterMCS(this._mcs);
        this._modelTable.changeMCS(this._mcsFilter);
    }

    public void addFilterListener(MCSFilterListener l) {
        this._listenerList.add(MCSFilterListener.class, l);
    }

    public void removeFilterListener(MCSFilterListener l) {
        this._listenerList.remove(MCSFilterListener.class, l);
    }

    protected void fireChangeTable(MCSFilter filter) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MCSFilterListener.class) continue;
            ((MCSFilterListener)listeners[i + 1]).changeTable(this._mcsFilter, filter);
        }
    }

    public void setMCS(MCS mcs) {
        this._mcs = mcs;
        this.callRefreshSorterFilter();
    }

    protected boolean withCAA() {
        return false;
    }

    protected void launchCAA() {
    }

    protected boolean withPostTreatmentDormant() {
        return false;
    }

    protected void launchPostTreatmentDormant() {
    }

    protected boolean withPostTreatmentEndOfFly() {
        return false;
    }

    protected void launchPostTreatmentEndOfFly() {
    }

    public static interface MCSFilterListener
    extends EventListener {
        public void changeTable(MCS var1, MCSFilter var2);
    }
}

