/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public class CodatID
extends net.jxta.codat.CodatID {
    protected static final int hashSize = 20;
    protected static final int groupIdOffset = 0;
    protected static final int idOffset = 16;
    protected static final int codatHashOffset = 32;
    protected static final int padOffset = 52;
    protected static final int padSize = 11;
    protected IDBytes id;

    protected CodatID() {
        this.id = new IDBytes(1);
    }

    protected CodatID(IDBytes id) {
        this.id = id;
    }

    protected CodatID(UUID groupUUID, UUID idUUID) {
        this();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, idUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, idUUID.getLeastSignificantBits());
    }

    public CodatID(PeerGroupID groupID) {
        this(groupID.getUUID(), UUIDFactory.newUUID());
    }

    public CodatID(PeerGroupID groupID, byte[] seed) {
        this();
        UUID groupUUID = groupID.getUUID();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        System.arraycopy(seed, 0, this.id.bytes, 16, Math.min(16, seed.length));
        this.id.bytes[22] = (byte)(this.id.bytes[22] & 0xF);
        this.id.bytes[22] = (byte)(this.id.bytes[22] | 0x40);
        this.id.bytes[24] = (byte)(this.id.bytes[24] & 0x3F);
        this.id.bytes[24] = (byte)(this.id.bytes[24] | 0x80);
        this.id.bytes[26] = (byte)(this.id.bytes[26] & 0x3F);
        this.id.bytes[26] = (byte)(this.id.bytes[26] | 0x80);
    }

    public CodatID(PeerGroupID groupID, InputStream in) throws IOException {
        this(groupID);
        this.setHash(in);
    }

    public CodatID(PeerGroupID groupID, byte[] seed, InputStream in) throws IOException {
        this(groupID, seed);
        this.setHash(in);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof CodatID) {
            CodatID codatTarget = (CodatID)target;
            return this.id.equals(codatTarget.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public ID getPeerGroupID() {
        UUID groupUUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return IDFormat.translateToWellKnown(groupID);
    }

    public boolean isStatic() {
        for (int eachHashByte = 32; eachHashByte < 52; ++eachHashByte) {
            if (0 == this.id.bytes[eachHashByte]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHash(InputStream in) throws IOException {
        MessageDigest dig = null;
        try {
            dig = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException caught) {
            dig = null;
        }
        if (dig == null) {
            throw new ProviderException("SHA-1 digest algorithm not found");
        }
        dig.reset();
        byte[] chunk = new byte[1024];
        try {
            int read;
            while ((read = in.read(chunk)) != -1) {
                dig.update(chunk, 0, read);
            }
        }
        finally {
            in.close();
        }
        byte[] result = dig.digest();
        System.arraycopy(result, 0, this.id.bytes, 32, 20);
    }
}

