/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import net.jxta.impl.util.BASE64InputStream;
import net.jxta.impl.util.BASE64OutputStream;
import net.jxta.logging.Logging;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509NameTokenizer;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class PSEUtils {
    private static final transient Logger LOG = Logger.getLogger(PSEUtils.class.getName());
    private static final PSEUtils UTILS = new PSEUtils();
    final transient SecureRandom srng;
    static final String PKCS5_PBSE1_ALGO = "PBEWITHMD5ANDDES";

    private PSEUtils() {
        block4: {
            this.srng = new SecureRandom();
            try {
                ClassLoader sysloader = ClassLoader.getSystemClassLoader();
                Class<?> loaded = sysloader.loadClass(BouncyCastleProvider.class.getName());
                Provider provider = (Provider)loaded.newInstance();
                Security.addProvider(provider);
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Loaded Security Providers into system class loader");
                }
            }
            catch (Exception disallowed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed loading Security Providers into System Class Loader. Will try local class loader (which may not work)", disallowed);
                }
                Security.addProvider((Provider)new BouncyCastleProvider());
                if (!Logging.SHOW_INFO || !LOG.isLoggable(Level.INFO)) break block4;
                LOG.info("Loaded Security Providers into local class loader");
            }
        }
    }

    public static IssuerInfo genCert(String cn, IssuerInfo issuerinfo) throws SecurityException {
        try {
            String useCN;
            if (null == issuerinfo) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Generating Self Signed Cert ...");
                }
                useCN = !cn.endsWith("-CA") ? cn + "-CA" : cn;
            } else {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Generating Client Cert ...");
                }
                useCN = cn;
            }
            Hashtable<DERObjectIdentifier, String> attrs = new Hashtable<DERObjectIdentifier, String>();
            attrs.put(X509Principal.CN, useCN);
            attrs.put(X509Principal.O, "www.jxta.org");
            byte[] ou = new byte[10];
            PSEUtils.UTILS.srng.nextBytes(ou);
            String ouStr = PSEUtils.toHexDigits(ou);
            attrs.put(X509Principal.OU, ouStr);
            X509Principal subject = new X509Principal(attrs);
            X500Principal samesubject = new X500Principal(subject.getEncoded());
            KeyPairGenerator g = KeyPairGenerator.getInstance("RSA");
            g.initialize(1024, PSEUtils.UTILS.srng);
            KeyPair keypair = g.generateKeyPair();
            return PSEUtils.genCert(samesubject, keypair, issuerinfo);
        }
        catch (NoSuchAlgorithmException e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Could not generate certificate", e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
    }

    public static IssuerInfo genCert(X500Principal subject, KeyPair keypair, IssuerInfo issuerinfo) throws SecurityException {
        try {
            X509Principal issuer;
            PrivateKey signer;
            if (null == issuerinfo) {
                signer = keypair.getPrivate();
                issuer = new X509Principal(subject.getEncoded());
            } else {
                signer = issuerinfo.subjectPkey;
                X500Principal issuer_subject = issuerinfo.cert.getSubjectX500Principal();
                issuer = new X509Principal(issuer_subject.getEncoded());
            }
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(today);
            cal.add(1, 10);
            Date until = cal.getTime();
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            certGen.setIssuerDN((X509Name)issuer);
            certGen.setSubjectDN((X509Name)new X509Principal(subject.getEncoded()));
            certGen.setNotBefore(today);
            certGen.setNotAfter(until);
            certGen.setPublicKey(keypair.getPublic());
            certGen.setSignatureAlgorithm("SHA1WITHRSA");
            certGen.setSerialNumber(BigInteger.valueOf(1L));
            IssuerInfo info = new IssuerInfo();
            info.cert = certGen.generateX509Certificate(signer, PSEUtils.UTILS.srng);
            info.subjectPkey = keypair.getPrivate();
            info.issuer = null == issuerinfo ? info.cert : issuerinfo.cert;
            info.issuerPkey = signer;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                if (null == issuer) {
                    LOG.fine("Root Cert : \n" + info.cert.toString());
                } else {
                    LOG.fine("Client Cert : \n" + info.cert.toString());
                }
            }
            return info;
        }
        catch (SignatureException e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.FINE, "Could not generate certificate", e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
        catch (InvalidKeyException e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.FINE, "Could not generate certificate", e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
        catch (IOException e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.FINE, "Could not generate certificate", e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
    }

    public static String getCertSubjectCName(X509Certificate cert) {
        X500Principal subject = cert.getSubjectX500Principal();
        X509NameTokenizer tokens = new X509NameTokenizer(subject.getName());
        while (tokens.hasMoreTokens()) {
            String attribute;
            String aToken = tokens.nextToken();
            if (aToken.length() < 3 || !"CN=".equalsIgnoreCase(attribute = aToken.substring(0, 3))) continue;
            return aToken.substring(3);
        }
        return null;
    }

    public static String getCertIssuerCName(X509Certificate cert) {
        X500Principal issuer = cert.getIssuerX500Principal();
        X509NameTokenizer tokens = new X509NameTokenizer(issuer.getName());
        while (tokens.hasMoreTokens()) {
            String attribute;
            String aToken = tokens.nextToken();
            if (aToken.length() < 3 || !"CN=".equalsIgnoreCase(attribute = aToken.substring(0, 3))) continue;
            return aToken.substring(3);
        }
        return null;
    }

    public static byte[] computeSignature(String algorithm, PrivateKey key, InputStream stream) throws InvalidKeyException, SignatureException, IOException {
        int read;
        Signature sign;
        try {
            sign = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException badsigner) {
            throw new IOException("Could not initialize signer with algorithm " + algorithm);
        }
        sign.initSign(key, PSEUtils.UTILS.srng);
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) >= 0) {
            sign.update(buffer, 0, read);
        }
        return sign.sign();
    }

    public static boolean verifySignature(String algorithm, Certificate cert, byte[] signature, InputStream stream) throws InvalidKeyException, SignatureException, IOException {
        int read;
        Signature sign;
        try {
            sign = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException badsigner) {
            throw new IOException("Could not initialize signer with algorithm " + algorithm);
        }
        sign.initVerify(cert);
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) >= 0) {
            sign.update(buffer, 0, read);
        }
        return sign.verify(signature);
    }

    public static byte[] hash(String algorithm, byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static EncryptedPrivateKeyInfo pkcs5_Encrypt_pbePrivateKey(char[] password, PrivateKey privkey, int iterations) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Encrypting " + privkey + " with '" + new String(password) + "'");
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        byte[] salt = new byte[8];
        PSEUtils.UTILS.srng.nextBytes(salt);
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, iterations);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PKCS5_PBSE1_ALGO);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(PKCS5_PBSE1_ALGO);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] encryptedPrivKey = pbeCipher.doFinal(privkey.getEncoded());
            AlgorithmParameters algo = AlgorithmParameters.getInstance(PKCS5_PBSE1_ALGO);
            algo.init(pbeParamSpec);
            EncryptedPrivateKeyInfo result = new EncryptedPrivateKeyInfo(algo, encryptedPrivKey);
            return result;
        }
        catch (Exception failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Encrypt failed", failed);
            }
            return null;
        }
    }

    public static PrivateKey pkcs5_Decrypt_pbePrivateKey(char[] password, String algorithm, EncryptedPrivateKeyInfo encryptedPrivKey) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Decrypting " + encryptedPrivKey + "/" + algorithm + " with '" + new String(password) + "'");
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        try {
            AlgorithmParameters algo = encryptedPrivKey.getAlgParameters();
            if (null == algo) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Could not get algo parameters from " + encryptedPrivKey);
                }
                throw new IllegalStateException("Could not get algo parameters from " + encryptedPrivKey);
            }
            PBEParameterSpec pbeParamSpec = algo.getParameterSpec(PBEParameterSpec.class);
            try {
                SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PKCS5_PBSE1_ALGO);
                SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
                Cipher pbeCipher = Cipher.getInstance(PKCS5_PBSE1_ALGO);
                pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
                PKCS8EncodedKeySpec key_spec = encryptedPrivKey.getKeySpec(pbeCipher);
                KeyFactory kf = KeyFactory.getInstance(algorithm);
                return kf.generatePrivate(key_spec);
            }
            catch (InvalidKeySpecException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Incorrect key for " + encryptedPrivKey + " : " + failed);
                }
                return null;
            }
        }
        catch (Exception failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Decrypt failed", failed);
            }
            return null;
        }
    }

    public static String loadBase64Object(BufferedReader rdr, String type) throws IOException {
        if (null != PSEUtils.findObject(rdr, type)) {
            return PSEUtils.readBase64Object(rdr, type);
        }
        return null;
    }

    public static byte[] loadObject(BufferedReader rdr, String type) throws IOException {
        if (null != PSEUtils.findObject(rdr, type)) {
            return PSEUtils.readObject(rdr, type);
        }
        return null;
    }

    public static String findObject(BufferedReader br, String type) throws IOException {
        String line;
        String prefix = "-----BEGIN ";
        String suffix = type == null ? "-----" : type + "-----";
        do {
            br.mark(1024);
            line = br.readLine();
            if (null != line) continue;
            return null;
        } while (!line.startsWith(prefix) || !line.endsWith(suffix));
        br.reset();
        return line.substring(prefix.length(), line.length() - 5);
    }

    public static String readBase64Object(BufferedReader br, String type) throws IOException {
        String suffix;
        String line = br.readLine();
        String prefix = "-----BEGIN ";
        String string = suffix = type == null ? "-----" : type + "-----";
        if (!line.startsWith(prefix) || !line.endsWith(suffix)) {
            throw new IOException("Not at begining of object");
        }
        StringBuilder block = new StringBuilder();
        while (null != (line = br.readLine()) && !line.startsWith("-----END ")) {
            block.append(line);
            block.append('\n');
        }
        return block.toString();
    }

    public static byte[] readObject(BufferedReader br, String type) throws IOException {
        String base64 = PSEUtils.readBase64Object(br, type);
        return PSEUtils.base64Decode(new StringReader(base64));
    }

    public static void writeBase64Object(BufferedWriter bw, String type, String object) throws IOException {
        bw.write("-----BEGIN ");
        bw.write(type);
        bw.write("-----");
        bw.newLine();
        bw.write(object);
        char lastChar = object.charAt(object.length() - 1);
        if ('\n' != lastChar && '\r' != lastChar) {
            bw.newLine();
        }
        bw.write("-----END ");
        bw.write(type);
        bw.write("-----");
        bw.newLine();
        bw.flush();
    }

    public static void writeObject(BufferedWriter out, String type, byte[] object) throws IOException {
        String base64 = PSEUtils.base64Encode(object);
        PSEUtils.writeBase64Object(out, type, base64);
    }

    public static String base64Encode(byte[] in) throws IOException {
        return PSEUtils.base64Encode(in, true);
    }

    public static String base64Encode(byte[] in, boolean wrap) throws IOException {
        StringWriter base64 = new StringWriter();
        BASE64OutputStream b64os = wrap ? new BASE64OutputStream(base64, 72) : new BASE64OutputStream(base64);
        b64os.write(in);
        b64os.close();
        String encoded = base64.toString();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Encoded " + in.length + " bytes -> " + encoded.length() + " characters.");
        }
        return encoded;
    }

    public static byte[] base64Decode(Reader in) throws IOException {
        int c;
        BASE64InputStream b64is = new BASE64InputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((c = b64is.read()) >= 0) {
            bos.write(c);
        }
        byte[] result = bos.toByteArray();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Decoded " + result.length + " bytes.");
        }
        return result;
    }

    private static String toHexDigits(byte theByte) {
        char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder result = new StringBuilder(2);
        result.append(HEXDIGITS[theByte >>> 4 & 0xF]);
        result.append(HEXDIGITS[theByte & 0xF]);
        return result.toString();
    }

    private static String toHexDigits(byte[] bytes) {
        StringBuilder encoded = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            encoded.append(PSEUtils.toHexDigits(aByte).toUpperCase());
        }
        return encoded.toString();
    }

    public static class IssuerInfo {
        public X509Certificate cert;
        public PrivateKey subjectPkey;
        public X509Certificate issuer;
        public PrivateKey issuerPkey;
    }
}

