/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.ConfiguratorException;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.peergroup.IncompleteConfigurationException;
import net.jxta.impl.peergroup.NullConfigurator;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;

public class AutomaticConfigurator
extends NullConfigurator {
    private static final transient Logger LOG = Logger.getLogger(AutomaticConfigurator.class.getName());

    public AutomaticConfigurator(URI jxtaHome) throws ConfiguratorException {
        super(jxtaHome);
    }

    public PlatformConfig getPlatformConfig() throws ConfiguratorException {
        boolean reconf;
        super.getPlatformConfig();
        try {
            reconf = this.buildPlatformConfig();
        }
        catch (RuntimeException serious) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Trouble while fixing PlatformConfig. Hope for the best.", serious);
            }
            reconf = true;
        }
        if (reconf) {
            throw new IncompleteConfigurationException("Damaged platform configuration.");
        }
        this.save();
        return this.advertisement;
    }

    private boolean buildPlatformConfig() {
        PSEConfigAdv pseConfig;
        boolean reconf;
        block59: {
            RdvConfigAdv rdvAdv;
            block58: {
                RelayConfigAdv relayConfig;
                TCPAdv tcpAdv;
                HTTPAdv httpAdv;
                block57: {
                    String jpn;
                    String peerName;
                    reconf = false;
                    if (this.advertisement == null) {
                        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                            LOG.config("New PlatformConfig Advertisement");
                        }
                        this.advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
                        this.advertisement.setDescription("Platform Config Advertisement created by : " + AutomaticConfigurator.class.getName());
                    }
                    if ((null == (peerName = this.advertisement.getName()) || 0 == peerName.trim().length()) && 0 != (jpn = System.getProperty("jxta.peer.name", "")).trim().length()) {
                        this.advertisement.setName(jpn);
                    }
                    XMLDocument http = (XMLDocument)this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                    httpAdv = null;
                    boolean httpEnabled = true;
                    if (http != null) {
                        try {
                            httpEnabled = this.advertisement.isSvcEnabled(PeerGroup.httpProtoClassID);
                            XMLElement param = null;
                            Enumeration httpChilds = http.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (httpChilds.hasMoreElements()) {
                                param = (XMLElement)httpChilds.nextElement();
                            }
                            if (null != param) {
                                String intf;
                                httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(param);
                                if (httpEnabled && null != (intf = httpAdv.getInterfaceAddress()) && !this.isValidInetAddress(intf)) {
                                    reconf = true;
                                    if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                                        LOG.config("Reconfig requested - invalid interface address");
                                    }
                                }
                            }
                        }
                        catch (RuntimeException advTrouble) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "HTTP advertisement corrupted", advTrouble);
                            }
                            httpAdv = null;
                        }
                    }
                    if (httpAdv == null) {
                        int port;
                        block55: {
                            if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                                LOG.config("HTTP advertisement missing, making a new one.");
                            }
                            port = 0;
                            String httpPort = System.getProperty("jxta.http.port");
                            if (httpPort != null) {
                                try {
                                    int propertyPort = Integer.parseInt(httpPort);
                                    if (propertyPort < 65536 && propertyPort >= 0) {
                                        port = propertyPort;
                                    } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                        LOG.warning("Property 'jxta.http.port' is not a valid port number : " + propertyPort);
                                    }
                                }
                                catch (NumberFormatException ignored) {
                                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block55;
                                    LOG.warning("Property 'jxta.http.port' was not an integer : " + http);
                                }
                            }
                        }
                        httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(HTTPAdv.getAdvertisementType());
                        httpAdv.setProtocol("http");
                        httpAdv.setPort(port);
                        httpAdv.setServerEnabled(false);
                    }
                    http = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    XMLDocument httAdvDoc = (XMLDocument)httpAdv.getDocument(MimeMediaType.XMLUTF8);
                    StructuredDocumentUtils.copyElements(http, http, httAdvDoc);
                    if (!httpEnabled) {
                        http.appendChild(http.createElement("isOff"));
                    }
                    this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, http);
                    XMLDocument tcp = (XMLDocument)this.advertisement.getServiceParam(PeerGroup.tcpProtoClassID);
                    tcpAdv = null;
                    boolean tcpEnabled = true;
                    if (tcp != null) {
                        try {
                            tcpEnabled = this.advertisement.isSvcEnabled(PeerGroup.tcpProtoClassID);
                            XMLElement param = null;
                            Enumeration tcpChilds = tcp.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (tcpChilds.hasMoreElements()) {
                                param = (XMLElement)tcpChilds.nextElement();
                            }
                            if (null != param) {
                                String intf;
                                tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(param);
                                if (tcpEnabled && null != (intf = tcpAdv.getInterfaceAddress()) && !this.isValidInetAddress(intf)) {
                                    reconf = true;
                                    if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                                        LOG.config("Reconfig requested - invalid interface address");
                                    }
                                }
                            }
                        }
                        catch (RuntimeException advTrouble) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "TCP advertisement corrupted", advTrouble);
                            }
                            tcpAdv = null;
                        }
                    }
                    if (tcpAdv == null) {
                        int port;
                        block56: {
                            if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                                LOG.config("TCP advertisement missing, making a new one.");
                            }
                            port = 0;
                            String tcpPort = System.getProperty("jxta.tcp.port");
                            if (tcpPort != null) {
                                try {
                                    int propertyPort = Integer.parseInt(tcpPort);
                                    if (propertyPort < 65536 && propertyPort >= 0) {
                                        port = propertyPort;
                                    } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                        LOG.warning("Property 'jxta.tcp.port' is not a valid port number : " + propertyPort);
                                    }
                                }
                                catch (NumberFormatException ignored) {
                                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block56;
                                    LOG.warning("Property 'jxta.tcp.port' was not an integer : " + tcpPort);
                                }
                            }
                        }
                        tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(TCPAdv.getAdvertisementType());
                        tcpAdv.setProtocol("tcp");
                        tcpAdv.setPort(port);
                        tcpAdv.setMulticastAddr("224.0.1.85");
                        tcpAdv.setMulticastPort(1234);
                        tcpAdv.setMulticastSize(16384);
                        tcpAdv.setMulticastState(true);
                    }
                    tcp = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    StructuredDocumentUtils.copyElements(tcp, tcp, (XMLDocument)tcpAdv.getDocument(MimeMediaType.XMLUTF8));
                    if (!tcpEnabled) {
                        tcp.appendChild(tcp.createElement("isOff"));
                    }
                    this.advertisement.putServiceParam(PeerGroup.tcpProtoClassID, tcp);
                    relayConfig = null;
                    try {
                        XMLElement param = (XMLElement)((Object)this.advertisement.getServiceParam(PeerGroup.relayProtoClassID));
                        if (param != null) {
                            param.addAttribute("type", RelayConfigAdv.getAdvertisementType());
                            relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement(param);
                        }
                    }
                    catch (Exception failure) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block57;
                        LOG.log(Level.WARNING, "Problem reading relay configuration", failure);
                    }
                }
                if (null == relayConfig) {
                    if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                        LOG.config("Relay Config advertisement missing, making a new one.");
                    }
                    relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement(RelayConfigAdv.getAdvertisementType());
                    if (!tcpAdv.isServerEnabled() || !httpAdv.isServerEnabled()) {
                        relayConfig.setClientEnabled(true);
                    }
                }
                XMLDocument relayDoc = (XMLDocument)relayConfig.getDocument(MimeMediaType.XMLUTF8);
                this.advertisement.putServiceParam(PeerGroup.relayProtoClassID, relayDoc);
                rdvAdv = null;
                try {
                    XMLElement param = (XMLElement)((Object)this.advertisement.getServiceParam(PeerGroup.rendezvousClassID));
                    if (param != null) {
                        param.addAttribute("type", RdvConfigAdv.getAdvertisementType());
                        rdvAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(param);
                    }
                }
                catch (Exception failure) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block58;
                    LOG.log(Level.WARNING, "Problem reading rendezvous configuration", failure);
                }
            }
            if (null == rdvAdv) {
                if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("Rdv Config advertisement missing, making a new one.");
                }
                rdvAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
            }
            XMLDocument rdvDoc = (XMLDocument)rdvAdv.getDocument(MimeMediaType.XMLUTF8);
            this.advertisement.putServiceParam(PeerGroup.rendezvousClassID, rdvDoc);
            XMLDocument proxy = (XMLDocument)this.advertisement.getServiceParam(PeerGroup.proxyClassID);
            if (null == proxy) {
                if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("Proxy config advertisement missing, making a new one.");
                }
                proxy = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                proxy.appendChild(proxy.createElement("isOff"));
                this.advertisement.putServiceParam(PeerGroup.proxyClassID, proxy);
            }
            pseConfig = null;
            try {
                XMLElement param = (XMLElement)((Object)this.advertisement.getServiceParam(PeerGroup.membershipClassID));
                if (param != null) {
                    param.addAttribute("type", PSEConfigAdv.getAdvertisementType());
                    pseConfig = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(param);
                }
            }
            catch (Exception failure) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block59;
                LOG.log(Level.WARNING, "Problem reading pse configuration", failure);
            }
        }
        if (null == pseConfig) {
            if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                LOG.config("PSE Config advertisement missing, making a new one.");
            }
            pseConfig = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
            XMLDocument pseDoc = (XMLDocument)pseConfig.getDocument(MimeMediaType.XMLUTF8);
            this.advertisement.putServiceParam(PeerGroup.membershipClassID, pseDoc);
        }
        return reconf;
    }

    private boolean isValidInetAddress(String address) {
        InetAddress[] ias;
        boolean found = false;
        try {
            ias = InetAddress.getAllByName(address);
        }
        catch (UnknownHostException notfound) {
            return false;
        }
        Iterator<InetAddress> la = IPUtils.getAllLocalAddresses();
        while (la.hasNext() && !found) {
            for (InetAddress ia1 : ias) {
                found |= ia1.equals(la.next());
            }
        }
        boolean loopback = true;
        for (InetAddress ia1 : ias) {
            loopback &= ia1.isLoopbackAddress();
        }
        return found || loopback;
    }
}

