/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeterBuildSettings;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RendezVousServiceProvider
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger(RendezVousServiceProvider.class.getName());
    protected static final String PropSName = "JxtaPropagate";
    protected static final String RDV_MSG_NAMESPACE_NAME = "jxta";
    protected final String PropPName;
    protected final String PROP_HDR_ELEMENT_NAME;
    protected int MAX_TTL;
    protected final PeerGroup group;
    protected final RendezVousServiceImpl rdvService;
    protected boolean closed = false;
    private PeerAdvertisement cachedPeerAdv = null;
    private int cachedPeerAdvModCount = -1;
    private XMLDocument cachedPeerAdvDoc = null;
    protected RendezvousServiceMonitor rendezvousServiceMonitor = null;
    protected RendezvousMeter rendezvousMeter = null;

    protected RendezVousServiceProvider(PeerGroup group, RendezVousServiceImpl rdvService) {
        this.group = group;
        this.rdvService = rdvService;
        this.PropPName = this.group.getPeerGroupID().getUniqueValue().toString();
        this.PROP_HDR_ELEMENT_NAME = "RendezVousPropagate" + this.PropPName;
    }

    @Override
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        RendezVousPropagateMessage propHdr = this.checkPropHeader(msg);
        if (null != propHdr) {
            String sName = propHdr.getDestSName();
            String sParam = propHdr.getDestSParam();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Processing " + msg + "(" + propHdr.getMsgId() + ") for " + sName + "/" + sParam + " from " + srcAddr);
            }
            this.processReceivedMessage(msg, propHdr, srcAddr, new EndpointAddress(dstAddr, sName, sParam));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLDocument getPeerAdvertisementDoc() {
        RendezVousServiceProvider rendezVousServiceProvider = this;
        synchronized (rendezVousServiceProvider) {
            PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
            int newModCount = newPadv.getModCount();
            if (this.cachedPeerAdv != newPadv || this.cachedPeerAdvModCount != newModCount) {
                this.cachedPeerAdv = newPadv;
                this.cachedPeerAdvModCount = newModCount;
            } else {
                newPadv = null;
            }
            if (null != newPadv) {
                this.cachedPeerAdvDoc = (XMLDocument)this.cachedPeerAdv.getDocument(MimeMediaType.XMLUTF8);
            }
        }
        return this.cachedPeerAdvDoc;
    }

    protected int startApp(String[] arg) {
        block9: {
            try {
                if (!this.rdvService.endpoint.addIncomingMessageListener(this, PropSName, this.PropPName)) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Cannot register the propagation listener (already registered)");
                    }
                    return -1;
                }
            }
            catch (Exception ez1) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed registering the endpoint listener", ez1);
                }
                return -1;
            }
            try {
                if (this.rdvService.isRendezVous()) {
                    XMLDocument params = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    Object e = params.createElement("Rdv", Boolean.TRUE.toString());
                    params.appendChild(e);
                    this.group.getPeerAdvertisement().putServiceParam(this.rdvService.getAssignedID(), params);
                } else {
                    this.group.getPeerAdvertisement().removeServiceParam(this.rdvService.getAssignedID());
                }
            }
            catch (Exception ignored) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block9;
                LOG.log(Level.WARNING, "Could not update Rdv Params in Peer Advertisement", ignored);
            }
        }
        return 0;
    }

    protected void stopApp() {
        EndpointListener shouldbeMe = this.rdvService.endpoint.removeIncomingMessageListener(PropSName, this.PropPName);
        if (null != shouldbeMe && this != shouldbeMe && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unregistered listener was not as expected." + this + " != " + shouldbeMe);
        }
        this.group.getPeerAdvertisement().removeServiceParam(this.rdvService.getAssignedID());
    }

    public void setRendezvousServiceMonitor(RendezvousServiceMonitor rendezvousServiceMonitor) {
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING) {
            this.rendezvousServiceMonitor = rendezvousServiceMonitor;
            if (rendezvousServiceMonitor != null) {
                this.rendezvousMeter = rendezvousServiceMonitor.getRendezvousMeter();
            }
        }
    }

    public abstract void challengeRendezVous(ID var1, long var2);

    public abstract void connectToRendezVous(EndpointAddress var1, Object var2) throws IOException;

    public abstract void disconnectFromRendezVous(ID var1);

    public abstract Vector<ID> getConnectedPeerIDs();

    public abstract void propagate(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract void propagate(Enumeration<? extends ID> var1, Message var2, String var3, String var4, int var5) throws IOException;

    public abstract void propagateToNeighbors(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract boolean isConnectedToRendezVous();

    public abstract void walk(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract void walk(Vector<? extends ID> var1, Message var2, String var3, String var4, int var5) throws IOException;

    protected void processReceivedMessage(Message message, RendezVousPropagateMessage propHdr, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        EndpointListener listener = this.rdvService.endpoint.getIncomingMessageListener(dstAddr.getServiceName(), dstAddr.getServiceParameter());
        if (listener != null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Calling local listener " + listener.getClass().getName() + " for [" + dstAddr.getServiceName() + "/" + dstAddr.getServiceParameter() + "] with " + message + " (" + propHdr.getMsgId() + ")");
            }
            this.rdvService.endpoint.processIncomingMessage(message, srcAddr, dstAddr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.receivedMessageProcessedLocally();
            }
        } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("No message listener found for ServiceName :" + dstAddr.getServiceName() + " ServiceParam :" + dstAddr.getServiceParameter());
        }
    }

    protected abstract void repropagate(Message var1, RendezVousPropagateMessage var2, String var3, String var4);

    public abstract void propagateInGroup(Message var1, String var2, String var3, int var4) throws IOException;

    protected void sendToNetwork(Message msg, RendezVousPropagateMessage propHdr) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Endpoint propagating " + msg + " (" + propHdr.getMsgId() + ")");
        }
        this.rdvService.endpoint.propagate(msg, PropSName, this.PropPName);
    }

    protected static EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID;
        try {
            asID = IDFactory.fromURI(new URI(destPeer));
        }
        catch (URISyntaxException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return RendezVousServiceProvider.mkAddress(asID, serv, parm);
    }

    protected static EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress(RDV_MSG_NAMESPACE_NAME, destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    protected RendezVousPropagateMessage getPropHeader(Message msg) {
        MessageElement elem = msg.getMessageElement(RDV_MSG_NAMESPACE_NAME, this.PROP_HDR_ELEMENT_NAME);
        if (elem == null) {
            return null;
        }
        try {
            StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(elem);
            return new RendezVousPropagateMessage(asDoc);
        }
        catch (IOException failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not get prop header of " + msg, failed);
            }
            IllegalArgumentException failure = new IllegalArgumentException("Could not get prop header of " + msg);
            failure.initCause(failed);
            throw failure;
        }
    }

    protected RendezVousPropagateMessage checkPropHeader(Message msg) {
        RendezVousPropagateMessage propHdr;
        try {
            propHdr = this.getPropHeader(msg);
            if (null == propHdr) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Discarding " + msg + " -- missing propagate header.");
                }
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                    this.rendezvousMeter.invalidMessageReceived();
                }
                return null;
            }
        }
        catch (Exception failure) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Discarding " + msg + " -- bad propagate header.", failure);
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.invalidMessageReceived();
            }
            return null;
        }
        if (propHdr.getTTL() <= 0) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Discarding " + msg + "(" + propHdr.getMsgId() + ") -- dead on arrival (TTl=" + propHdr.getTTL() + ").");
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.receivedDeadMessage();
            }
            return null;
        }
        if (!this.rdvService.addMsgId(propHdr.getMsgId())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Discarding " + msg + "(" + propHdr.getMsgId() + ") -- feedback.");
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.receivedDuplicateMessage();
            }
            return null;
        }
        if (propHdr.isVisited(this.group.getPeerID().toURI())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Discarding " + msg + "(" + propHdr.getMsgId() + ") -- loopback.");
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.receivedLoopbackMessage();
            }
            return null;
        }
        return propHdr;
    }

    protected RendezVousPropagateMessage updatePropHeader(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam, int initialTTL) {
        boolean newHeader = false;
        if (null == propHdr) {
            propHdr = this.newPropHeader(serviceName, serviceParam, initialTTL);
            newHeader = true;
        } else if (null == this.updatePropHeader(propHdr, initialTTL)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("TTL expired for " + msg + " (" + propHdr.getMsgId() + ") TTL=" + propHdr.getTTL());
            }
            return null;
        }
        XMLDocument propHdrDoc = (XMLDocument)propHdr.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement elem = new TextDocumentMessageElement(this.PROP_HDR_ELEMENT_NAME, propHdrDoc, null);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine((newHeader ? "Added" : "Updated") + " prop header for " + msg + " (" + propHdr.getMsgId() + ") TTL = " + propHdr.getTTL());
        }
        msg.replaceMessageElement(RDV_MSG_NAMESPACE_NAME, elem);
        return propHdr;
    }

    private RendezVousPropagateMessage newPropHeader(String serviceName, String serviceParam, int initialTTL) {
        RendezVousPropagateMessage propHdr = new RendezVousPropagateMessage();
        propHdr.setTTL(initialTTL);
        propHdr.setDestSName(serviceName);
        propHdr.setDestSParam(serviceParam);
        UUID msgID = this.rdvService.createMsgId();
        propHdr.setMsgId(msgID);
        this.rdvService.addMsgId(msgID);
        propHdr.addVisited(this.group.getPeerID().toURI());
        return propHdr;
    }

    private RendezVousPropagateMessage updatePropHeader(RendezVousPropagateMessage propHdr, int maxTTL) {
        int msgTTL = propHdr.getTTL();
        URI me = this.group.getPeerID().toURI();
        int useTTL = msgTTL;
        if (!propHdr.isVisited(me)) {
            --useTTL;
        }
        useTTL = Math.min(useTTL, maxTTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating propagation header (" + propHdr.getMsgId() + ") TTL: " + msgTTL + "-->" + useTTL);
        }
        propHdr.setTTL(useTTL);
        propHdr.addVisited(me);
        return useTTL <= 0 ? null : propHdr;
    }
}

