/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.util.pipe.reliable.FixedFlowControl;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.impl.util.pipe.reliable.OutgoingMsgrAdaptor;
import net.jxta.impl.util.pipe.reliable.ReliableInputStream;
import net.jxta.impl.util.pipe.reliable.ReliableOutputStream;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.socket.JxtaSocketAddress;
import net.jxta.socket.JxtaSocketInputStream;
import net.jxta.socket.JxtaSocketOutputStream;

public class JxtaSocket
extends Socket
implements PipeMsgListener,
OutputPipeListener {
    private static final Logger LOG = Logger.getLogger(JxtaSocket.class.getName());
    private static final int MAXRETRYTIMEOUT = 120000;
    private static final int DEFAULT_TIMEOUT = 15000;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private boolean initiator = false;
    protected PeerGroup group;
    protected PipeAdvertisement pipeAdv;
    protected PipeAdvertisement localEphemeralPipeAdv;
    protected InputPipe localEphemeralPipeIn;
    protected PipeAdvertisement remoteEphemeralPipeAdv;
    protected Messenger remoteEphemeralPipeMsgr;
    protected PipeService pipeSvc;
    protected PeerID remotePeerID;
    protected OutputPipe connectOutpipe;
    private int soTimeout = 0;
    protected long timeout = 60000L;
    protected int retryTimeout = 60000;
    protected int maxRetryTimeout = 120000;
    protected int windowSize = 20;
    protected final Object pipeResolveLock = new Object();
    protected final Object socketConnectLock = new Object();
    protected final Object closeLock = new Object();
    private boolean closeAckReceived = false;
    protected volatile boolean closed = false;
    protected boolean bound = false;
    protected boolean connected = false;
    protected Credential remoteCredential = null;
    protected Credential localCredential = null;
    private PeerAdvertisement remotePeerAdv = null;
    protected boolean isReliable = true;
    private boolean outputShutdown = false;
    private boolean inputShutdown = false;
    protected Outgoing outgoing = null;
    protected ReliableInputStream ris = null;
    protected ReliableOutputStream ros = null;
    protected JxtaSocketInputStream nonReliableInputStream = null;
    protected JxtaSocketOutputStream nonReliableOutputStream = null;
    private int outputBufferSize = -1;

    public JxtaSocket() {
    }

    protected JxtaSocket(PeerGroup group, PipeAdvertisement pipeAdv, PipeAdvertisement remoteEphemeralPipeAdv, PeerAdvertisement remotePeerAdv, Credential localCredential, Credential remoteCredential, boolean isReliable) throws IOException {
        this.initiator = false;
        this.group = group;
        this.pipeAdv = pipeAdv;
        this.remoteEphemeralPipeAdv = remoteEphemeralPipeAdv;
        this.localEphemeralPipeAdv = JxtaSocket.newEphemeralPipeAdv(pipeAdv);
        this.remotePeerAdv = remotePeerAdv;
        this.remotePeerID = remotePeerAdv.getPeerID();
        this.localCredential = localCredential;
        this.remoteCredential = remoteCredential;
        this.isReliable = isReliable;
        this.pipeSvc = group.getPipeService();
        this.bind();
        this.connect();
        Message connectResponse = this.createConnectMessage(group, this.localEphemeralPipeAdv, localCredential, isReliable, this.initiator);
        this.remoteEphemeralPipeMsgr.sendMessage(connectResponse);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("New socket : " + this);
        }
    }

    public JxtaSocket(SocketAddress address) throws IOException {
        this.connect(address, 15000);
    }

    public JxtaSocket(PeerGroup group, PipeAdvertisement pipeAdv) throws IOException {
        this.connect(group, pipeAdv);
    }

    public JxtaSocket(SocketAddress address, int timeout) throws IOException {
        this.connect(address, timeout);
    }

    public JxtaSocket(PeerGroup group, PipeAdvertisement pipeAdv, int timeout) throws IOException {
        this.connect(group, pipeAdv, timeout);
    }

    public JxtaSocket(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAdv, int timeout) throws IOException {
        this.connect(group, peerid, pipeAdv, timeout);
    }

    public JxtaSocket(SocketAddress address, int timeout, boolean reliable) throws IOException {
        this.isReliable = reliable;
        this.connect(address, timeout);
    }

    public JxtaSocket(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAdv, int timeout, boolean reliable) throws IOException {
        this.isReliable = reliable;
        this.connect(group, peerid, pipeAdv, timeout);
    }

    protected void finalize() throws Throwable {
        if (!this.closed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("JxtaSocket is being finalized without being previously closed. This is likely a users bug.");
        }
        this.close();
        super.finalize();
    }

    @Deprecated
    public void create(boolean reliable) throws IOException {
        if (this.isBound()) {
            throw new IOException("Socket already bound, it is not possible to change connection type");
        }
        this.isReliable = reliable;
    }

    public void bind(SocketAddress address) throws IOException {
        throw new IOException("Unsupported operation, use java.net.Socket instead");
    }

    public void connect(SocketAddress address) throws IOException {
        this.connect(address, 15000);
    }

    public void connect(SocketAddress address, int timeout) throws IOException {
        if (!(address instanceof JxtaSocketAddress)) {
            throw new IOException("Subclass of SocketAddress not supported. Use JxtaSocketAddress instead.");
        }
        JxtaSocketAddress socketAddress = (JxtaSocketAddress)address;
        PeerGroup pg = PeerGroup.globalRegistry.lookupInstance(socketAddress.getPeerGroupId());
        if (pg == null) {
            throw new IOException("Can't connect socket in PeerGroup with id " + socketAddress.getPeerGroupId() + ". No running instance of the group is registered.");
        }
        this.connect(pg.getWeakInterface(), socketAddress.getPeerId(), socketAddress.getPipeAdv(), timeout);
        pg.unref();
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAdv) throws IOException {
        this.connect(group, pipeAdv, 15000);
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAdv, int timeout) throws IOException {
        this.connect(group, null, pipeAdv, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void connect(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAdv, int timeout) throws IOException {
        long waitFor;
        if ("JxtaPropagate".equals(pipeAdv.getType())) {
            throw new IOException("Propagate pipe advertisements are not supported");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout may not be negative");
        }
        this.initiator = true;
        this.group = group;
        this.remotePeerID = peerid;
        this.pipeAdv = pipeAdv;
        this.localEphemeralPipeAdv = JxtaSocket.newEphemeralPipeAdv(pipeAdv);
        this.timeout = timeout == 0 ? Long.MAX_VALUE : (long)timeout;
        this.pipeSvc = group.getPipeService();
        this.bind();
        Message openMsg = this.createConnectMessage(group, this.localEphemeralPipeAdv, this.localCredential, this.isReliable, this.initiator);
        long connectTimeoutAt = System.currentTimeMillis() + (long)timeout;
        if (connectTimeoutAt < (long)timeout) {
            connectTimeoutAt = Long.MAX_VALUE;
        }
        if (peerid == null) {
            this.pipeSvc.createOutputPipe(pipeAdv, this);
        } else {
            this.pipeSvc.createOutputPipe(pipeAdv, Collections.singleton(peerid), this);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Beginning Output Pipe Resolution. " + this);
        }
        Object object = this.pipeResolveLock;
        // MONITORENTER : object
        while (this.connectOutpipe == null) {
            try {
                waitFor = connectTimeoutAt - System.currentTimeMillis();
                if (waitFor <= 0L) break;
                if (this.connectOutpipe != null) continue;
                this.pipeResolveLock.wait(waitFor);
            }
            catch (InterruptedException ie) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Interrupted", ie);
                }
                Thread.interrupted();
                SocketException exp = new SocketException("Connect Interrupted");
                exp.initCause(ie);
                throw exp;
            }
        }
        // MONITOREXIT : object
        if (this.connectOutpipe == null) {
            throw new SocketTimeoutException("Connection (resolution) timeout");
        }
        try {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Sending connect message. " + this);
            }
            this.connectOutpipe.send(openMsg);
            object = this.socketConnectLock;
            // MONITORENTER : object
            while (!this.isConnected()) {
                try {
                    waitFor = connectTimeoutAt - System.currentTimeMillis();
                    if (waitFor <= 0L) break;
                    this.socketConnectLock.wait(waitFor);
                }
                catch (InterruptedException ie) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Interrupted", ie);
                    }
                    Thread.interrupted();
                    SocketException exp = new SocketException("Connect Interrupted");
                    exp.initCause(ie);
                    throw exp;
                }
            }
            // MONITOREXIT : object
        }
        finally {
            this.connectOutpipe.close();
            this.connectOutpipe = null;
        }
        if (!this.isConnected()) {
            throw new SocketTimeoutException("Connection timeout (connect)");
        }
        if (!Logging.SHOW_INFO) return;
        if (!LOG.isLoggable(Level.INFO)) return;
        LOG.info("New socket connection : " + this);
    }

    protected static Credential getDefaultCredential(PeerGroup group) {
        try {
            MembershipService membership = group.getMembershipService();
            return membership.getDefaultCredential();
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to get credential", e);
            }
            return null;
        }
    }

    public Credential getCredentialDoc() {
        try {
            return this.remoteCredential;
        }
        catch (Exception failure) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to generate credential document ", failure);
            }
            return null;
        }
    }

    public void setCredential(Credential localCredential) {
        if (localCredential == null) {
            this.localCredential = localCredential;
        } else {
            try {
                MembershipService membership = this.group.getMembershipService();
                this.localCredential = membership.getDefaultCredential();
            }
            catch (Exception failed) {
                this.localCredential = null;
            }
        }
    }

    protected Message createConnectMessage(PeerGroup group, PipeAdvertisement pipeAdv, Credential credential, boolean isReliable, boolean initiator) throws IOException {
        Message msg = new Message();
        if (credential == null) {
            credential = JxtaSocket.getDefaultCredential(group);
        }
        if (credential == null && "JxtaUnicastSecure".equals(pipeAdv.getType())) {
            throw new IOException("Credentials must be established to initiate a secure connection.");
        }
        if (credential != null) {
            try {
                XMLDocument credDoc = (XMLDocument)credential.getDocument(MimeMediaType.XMLUTF8);
                msg.addMessageElement("JXTASOC", new TextDocumentMessageElement("Cred", credDoc, null));
            }
            catch (Exception failed) {
                IOException failure = new IOException("Could not generate credential element.");
                failure.initCause(failed);
                throw failure;
            }
        }
        msg.addMessageElement("JXTASOC", new TextDocumentMessageElement(initiator ? "reqPipe" : "remPipe", (XMLDocument)pipeAdv.getDocument(MimeMediaType.XMLUTF8), null));
        msg.addMessageElement("JXTASOC", new TextDocumentMessageElement("remPeer", (XMLDocument)group.getPeerAdvertisement().getDocument(MimeMediaType.XMLUTF8), null));
        msg.addMessageElement("JXTASOC", new StringMessageElement("stream", Boolean.toString(isReliable), null));
        return msg;
    }

    protected static PipeAdvertisement newEphemeralPipeAdv(PipeAdvertisement pipeAdv) {
        PipeAdvertisement adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        PeerGroupID gid = (PeerGroupID)((PipeID)pipeAdv.getPipeID()).getPeerGroupID();
        adv.setPipeID(IDFactory.newPipeID(gid));
        adv.setName(pipeAdv.getName() + ".remote");
        adv.setType(pipeAdv.getType());
        return adv;
    }

    public boolean isBound() {
        return this.bound;
    }

    private void setBound(boolean boundState) {
        this.bound = boundState;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void setConnected(boolean connectedState) {
        this.connected = connectedState;
    }

    private void bind() throws IOException {
        this.localEphemeralPipeIn = this.pipeSvc.createInputPipe(this.localEphemeralPipeAdv, this);
        this.setBound(true);
    }

    protected Outgoing makeOutgoing(Messenger msgr, long timeout) {
        return new OutgoingMsgrAdaptor(msgr, (int)timeout);
    }

    private void connect() throws IOException {
        this.remoteEphemeralPipeMsgr = JxtaSocket.lightweightOutputPipe(this.group, this.remoteEphemeralPipeAdv, this.remotePeerAdv);
        if (this.remoteEphemeralPipeMsgr == null) {
            throw new IOException("Could not create messenger back to connecting peer");
        }
        if (this.remoteEphemeralPipeMsgr.getMTU() < (long)this.outputBufferSize) {
            this.outputBufferSize = Math.min((int)this.remoteEphemeralPipeMsgr.getMTU(), 262144);
        }
        if (this.outputBufferSize == -1) {
            this.outputBufferSize = Math.min((int)this.remoteEphemeralPipeMsgr.getMTU(), 262144);
        }
        if (this.isReliable) {
            this.outgoing = this.makeOutgoing(this.remoteEphemeralPipeMsgr, this.retryTimeout);
            this.ris = new ReliableInputStream(this.outgoing, this.soTimeout);
            this.ros = new ReliableOutputStream(this.outgoing, new FixedFlowControl(this.windowSize));
            try {
                this.ros.setSendBufferSize(this.outputBufferSize);
            }
            catch (IOException iOException) {}
        } else {
            this.nonReliableInputStream = new JxtaSocketInputStream(this, this.windowSize);
            this.nonReliableOutputStream = new JxtaSocketOutputStream(this, this.outputBufferSize);
        }
        this.setConnected(true);
    }

    @Deprecated
    public int getOutputStreamBufferSize() {
        return this.outputBufferSize == -1 ? 262144 : this.outputBufferSize;
    }

    @Deprecated
    public void setOutputStreamBufferSize(int size) throws IOException {
        this.setSendBufferSize(size);
    }

    public InputStream getInputStream() throws IOException {
        this.checkState();
        if (this.isInputShutdown()) {
            throw new SocketException("Input already shutdown.");
        }
        if (this.isReliable) {
            return this.ris;
        }
        return this.nonReliableInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkState();
        if (this.isOutputShutdown()) {
            throw new SocketException("Output already shutdown.");
        }
        return this.isReliable ? this.ros : this.nonReliableOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            Object object = this.closeLock;
            synchronized (object) {
                long closingFor;
                long closeEndsAt;
                block21: {
                    closeEndsAt = System.currentTimeMillis() + this.timeout;
                    if (closeEndsAt < this.timeout) {
                        closeEndsAt = Long.MAX_VALUE;
                    }
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Closing " + this + " timeout=" + this.timeout + "ms.");
                    }
                    if (!this.closed) break block21;
                    return;
                }
                this.closed = true;
                this.shutdownOutput();
                this.shutdownInput();
                while (this.isConnected() && (closingFor = closeEndsAt - System.currentTimeMillis()) > 0L) {
                    block22: {
                        if (this.isReliable) {
                            try {
                                if (this.ros.isQueueEmpty()) {
                                    this.sendClose();
                                    break block22;
                                }
                                this.ros.waitQueueEmpty(1000L);
                                continue;
                            }
                            catch (InterruptedException woken) {
                                Thread.interrupted();
                                break;
                            }
                        }
                        this.sendClose();
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Sent close, awaiting ACK for " + this);
                    }
                    try {
                        long nextTry = Math.min(20000L, closingFor);
                        if (nextTry <= 0L || !this.isConnected()) continue;
                        this.closeLock.wait(nextTry);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                        break;
                    }
                }
                if (this.isConnected()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Still connected at end of timeout. Forcing closed." + this);
                    }
                    this.sendClose();
                    throw new SocketTimeoutException("Failed to receive close ack from remote connection.");
                }
            }
        }
        finally {
            this.setConnected(false);
            this.unbind();
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Socket closed : " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFromRemote() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.INFO)) {
                LOG.info("Received a remote close request." + this);
            }
            if (this.isConnected()) {
                this.setConnected(false);
                if (this.isReliable) {
                    this.ris.softClose();
                    this.ros.hardClose();
                } else {
                    this.nonReliableInputStream.softClose();
                    this.nonReliableOutputStream.hardClose();
                }
            }
            if (this.isBound() && this.ros != null && this.ros.isQueueEmpty()) {
                this.sendCloseACK();
            }
            if (this.closeAckReceived) {
                this.closeLock.notifyAll();
            }
        }
    }

    protected synchronized void unbind() {
        if (!this.isBound()) {
            return;
        }
        if (this.isReliable) {
            try {
                this.ris.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ros.hardClose();
        } else {
            this.nonReliableInputStream.close();
            this.nonReliableOutputStream.hardClose();
        }
        this.setBound(false);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Closing ephemeral input pipe");
        }
        this.localEphemeralPipeIn.close();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Closing remote ephemeral pipe messenger");
        }
        if (null != this.outgoing) {
            this.outgoing.close();
        }
        this.remoteEphemeralPipeMsgr.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeMsgEvent(PipeMsgEvent event) {
        Object incomingPipeAdv;
        Message message;
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Pipe Message Event for " + this + "\n\t" + event.getMessage() + " for " + event.getPipeID());
        }
        if ((message = event.getMessage()) == null) {
            return;
        }
        MessageElement element2 = message.getMessageElement("JXTASOC", "close");
        if (element2 != null) {
            block50: {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Handling a close message " + this + " : " + element2.toString());
                }
                if ("close".equals(element2.toString())) {
                    try {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Received a close request");
                        }
                        this.closeFromRemote();
                    }
                    catch (IOException ie) {
                        if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.log(Level.SEVERE, "failed during closeFromRemote", ie);
                        }
                        break block50;
                    }
                }
                if ("closeACK".equals(element2.toString())) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Received a close acknowledgement");
                    }
                    Object ie = this.closeLock;
                    synchronized (ie) {
                        this.closeAckReceived = true;
                        this.setConnected(false);
                        this.closeLock.notifyAll();
                    }
                }
            }
            return;
        }
        if (!this.isConnected()) {
            Credential incomingCredential;
            PeerAdvertisement incomingRemotePeerAdv;
            block51: {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Processing connect response : " + message);
                }
                element2 = message.getMessageElement("JXTASOC", "remPipe");
                incomingPipeAdv = null;
                if (element2 != null) {
                    try {
                        XMLDocument pipeAdvDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(element2);
                        incomingPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(pipeAdvDoc);
                    }
                    catch (IOException badPipeAdv) {
                        // empty catch block
                    }
                }
                element2 = message.getMessageElement("JXTASOC", "remPeer");
                incomingRemotePeerAdv = null;
                if (element2 != null) {
                    try {
                        XMLDocument peerAdvDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(element2);
                        incomingRemotePeerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(peerAdvDoc);
                    }
                    catch (IOException badPeerAdv) {
                        // empty catch block
                    }
                }
                element2 = message.getMessageElement("JXTASOC", "Cred");
                incomingCredential = null;
                if (element2 != null) {
                    try {
                        StructuredDocument incomingCredentialDoc = StructuredDocumentFactory.newStructuredDocument(element2);
                        incomingCredential = this.group.getMembershipService().makeCredential(incomingCredentialDoc);
                    }
                    catch (Exception failed) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block51;
                        LOG.log(Level.WARNING, "Unable to generate credential for " + this, failed);
                    }
                }
            }
            element2 = message.getMessageElement("JXTASOC", "stream");
            boolean incomingIsReliable = this.isReliable;
            if (element2 != null) {
                incomingIsReliable = Boolean.valueOf(element2.toString());
            }
            if (null != incomingPipeAdv && null != incomingRemotePeerAdv) {
                if (null != this.remotePeerID && this.remotePeerID != incomingRemotePeerAdv.getPeerID()) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Connection response from wrong peer! " + this.remotePeerID + " != " + incomingRemotePeerAdv.getPeerID());
                    }
                    return;
                }
                Object object = this.socketConnectLock;
                synchronized (object) {
                    if (!this.isConnected()) {
                        this.remoteCredential = incomingCredential;
                        this.remotePeerAdv = incomingRemotePeerAdv;
                        this.remotePeerID = incomingRemotePeerAdv.getPeerID();
                        this.remoteEphemeralPipeAdv = incomingPipeAdv;
                        this.isReliable = incomingIsReliable;
                        try {
                            this.connect();
                        }
                        catch (IOException failed) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Connection failed : " + this, failed);
                            }
                            return;
                        }
                        this.socketConnectLock.notify();
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.log(Level.INFO, "New Socket Connection : " + this);
                        }
                    }
                }
                return;
            }
        }
        incomingPipeAdv = this.socketConnectLock;
        synchronized (incomingPipeAdv) {
            long waitFor;
            long timeoutAt = System.currentTimeMillis() + this.timeout;
            if (timeoutAt < this.timeout) {
                timeoutAt = Long.MAX_VALUE;
            }
            while (!this.isClosed() && !this.isConnected() && (waitFor = timeoutAt - System.currentTimeMillis()) > 0L) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Holding " + message + " for " + this.timeout);
                }
                try {
                    this.socketConnectLock.wait(this.timeout);
                }
                catch (InterruptedException woken) {
                    return;
                }
            }
        }
        if (!this.isReliable) {
            Message.ElementIterator dataElements = message.getMessageElements("JXTASOC", "data");
            while (dataElements.hasNext()) {
                MessageElement anElement = (MessageElement)dataElements.next();
                this.nonReliableInputStream.enqueue(anElement);
            }
        } else {
            if (this.ros != null) {
                this.ros.recv(message);
            }
            if (this.ris != null) {
                this.ris.recv(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputPipeEvent(OutputPipeEvent event) {
        OutputPipe op = event.getOutputPipe();
        if (op.getAdvertisement() == null) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The output pipe has no internal pipe advertisement. discarding event");
            }
            return;
        }
        if (this.pipeAdv.getID().equals(op.getAdvertisement().getID()) && this.pipeAdv.getType().equals(op.getAdvertisement().getType())) {
            Object object = this.pipeResolveLock;
            synchronized (object) {
                if (this.connectOutpipe == null) {
                    this.connectOutpipe = op;
                    op = null;
                }
                this.pipeResolveLock.notify();
            }
            if (op != null) {
                op.close();
            }
        } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unexpected OutputPipe :" + op);
        }
    }

    protected static Messenger lightweightOutputPipe(PeerGroup group, PipeAdvertisement pipeAdv, PeerAdvertisement peerAdv) {
        EndpointAddress addr;
        EndpointService endpoint = group.getEndpointService();
        ID opId = pipeAdv.getPipeID();
        String destPeer = peerAdv.getPeerID().getUniqueValue().toString();
        RouteAdvertisement routeHint = EndpointUtils.extractRouteAdv(peerAdv);
        if (pipeAdv.getType().equals("JxtaUnicast")) {
            addr = new EndpointAddress("jxta", destPeer, "PipeService", opId.toString());
        } else if (pipeAdv.getType().equals("JxtaUnicastSecure")) {
            addr = new EndpointAddress("jxtatls", destPeer, "PipeService", opId.toString());
        } else {
            throw new IllegalArgumentException(pipeAdv.getType() + " is not a supported pipe type");
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("New pipe lightweight messenger for " + addr);
        }
        return endpoint.getMessenger(addr, routeHint);
    }

    private void sendClose() throws IOException {
        Message msg = new Message();
        msg.addMessageElement("JXTASOC", new StringMessageElement("close", "close", null));
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending a close request " + this + " : " + msg);
        }
        this.remoteEphemeralPipeMsgr.sendMessageN(msg, null, null);
    }

    private void sendCloseACK() throws IOException {
        Message msg = new Message();
        msg.addMessageElement("JXTASOC", new StringMessageElement("close", "closeACK", null));
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending a close ACK " + this + " : " + msg);
        }
        this.remoteEphemeralPipeMsgr.sendMessageN(msg, null, null);
    }

    public int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.timeout > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)this.timeout;
    }

    public void setSoTimeout(int soTimeout) throws SocketException {
        if (soTimeout < 0) {
            throw new IllegalArgumentException("Invalid Socket timeout :" + soTimeout);
        }
        this.timeout = soTimeout;
        if (!this.isBound()) {
            return;
        }
        if (this.isReliable) {
            if (this.ris != null) {
                this.ris.setTimeout(soTimeout);
            }
        } else {
            this.nonReliableInputStream.setTimeout(soTimeout);
        }
    }

    @Deprecated
    public int getMaxRetryTimeout() {
        return this.maxRetryTimeout;
    }

    @Deprecated
    public void setMaxRetryTimeout(int maxRetryTimeout) {
        if (maxRetryTimeout <= 0 || maxRetryTimeout > 120000) {
            throw new IllegalArgumentException("Invalid Maximum retry timeout :" + maxRetryTimeout + " Exceed Global maximum retry timeout :" + 120000);
        }
        this.maxRetryTimeout = maxRetryTimeout;
    }

    public int getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(int retryTimeout) throws SocketException {
        if (retryTimeout <= 0 || retryTimeout > this.maxRetryTimeout) {
            throw new IllegalArgumentException("Invalid Retry Socket timeout :" + retryTimeout);
        }
        this.retryTimeout = retryTimeout;
        if (this.outgoing != null) {
            this.outgoing.setTimeout(retryTimeout);
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) throws SocketException {
        if (this.isBound()) {
            throw new SocketException("Socket bound. Can not change the window size");
        }
        this.windowSize = windowSize;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void write(byte[] buf, int offset, int length) throws IOException {
        this.checkState();
        if (this.isReliable) {
            this.ros.write(buf, offset, length);
        } else {
            byte[] bufCopy = new byte[length];
            System.arraycopy(buf, offset, bufCopy, 0, length);
            Message msg = new Message();
            msg.addMessageElement("JXTASOC", new ByteArrayMessageElement("data", MimeMediaType.AOS, bufCopy, 0, length, null));
            this.remoteEphemeralPipeMsgr.sendMessageB(msg, null, null);
        }
    }

    private void checkState() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed.");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket not bound.");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket not connected.");
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket is closed");
        }
        return this.outputBufferSize == -1 ? 262144 : this.outputBufferSize;
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket is closed");
        }
        if (size < 1) {
            throw new IllegalArgumentException("negative/zero buffer size");
        }
        if (null != this.remoteEphemeralPipeMsgr && (long)size > this.remoteEphemeralPipeMsgr.getMTU()) {
            throw new IllegalArgumentException("Buffer size larger than limit : " + this.remoteEphemeralPipeMsgr.getMTU());
        }
        this.outputBufferSize = size;
        if (null != this.ros) {
            try {
                this.ros.setSendBufferSize(size);
            }
            catch (SocketException failure) {
                throw failure;
            }
            catch (IOException failed) {
                SocketException failure = new SocketException("Failed");
                failure.initCause(failed);
                throw failure;
            }
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isInputShutdown()) {
            throw new SocketException("Socket is closed");
        }
        return this.outputBufferSize * this.windowSize;
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.inputShutdown) {
            throw new SocketException("Socket is closed");
        }
        return false;
    }

    public int getTrafficClass() throws SocketException {
        throw new SocketException("TrafficClass not yet defined");
    }

    public void setTrafficClass(int tc) throws SocketException {
        throw new SocketException("TrafficClass not yet defined");
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setOOBInline(boolean state) throws SocketException {
        throw new SocketException("Enable/disable OOBINLINE supported");
    }

    public void setKeepAlive(boolean state) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        throw new SocketException("Operation not supported");
    }

    public void shutdownInput() throws IOException {
        this.inputShutdown = true;
        if (this.isReliable) {
            this.ris.close();
        } else {
            this.nonReliableInputStream.close();
        }
    }

    public void shutdownOutput() throws IOException {
        this.outputShutdown = true;
        if (this.isReliable) {
            this.ros.setLingerDelay(this.timeout);
            this.ros.close();
        } else {
            this.nonReliableOutputStream.close();
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new JxtaSocketAddress(this.group, this.localEphemeralPipeAdv, this.group.getPeerAdvertisement());
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new JxtaSocketAddress(this.group, this.remoteEphemeralPipeAdv, this.remotePeerAdv);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append('@');
        result.append(System.identityHashCode(this));
        result.append('[');
        if (null != this.pipeAdv) {
            result.append(this.pipeAdv.getPipeID().getUniqueValue());
        }
        result.append('/');
        if (null != this.localEphemeralPipeAdv) {
            result.append(this.localEphemeralPipeAdv.getPipeID().getUniqueValue());
        }
        result.append(']');
        result.append(this.isClosed() ? " CLOSED :" : " OPEN :");
        result.append(this.initiator ? " I " : " i ");
        result.append(this.isReliable ? " R " : " r ");
        result.append(this.isBound() ? " B " : " b ");
        result.append(this.isConnected() ? " C " : " c ");
        return result.toString();
    }
}

