/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.patchs.DlgCorrectorDBFolderWithMsg;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public abstract class AbstractCorrectorWithSimpleMsg
extends CThread {
    public AbstractCorrectorWithSimpleMsg(Component c) {
        super(c);
    }

    protected abstract String getTitle();

    protected abstract void patch(List<DBFolder> var1);

    protected void treatError(Map<DBFolder, StringBuilder> errorFolders) {
        if (errorFolders.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgAdmin.getString("PATCH_NO_PROBLEM"), this.getTitle(), 1);
            return;
        }
        Window win = JOptionCecilia.getWindowOf(this.getSource());
        final DlgCorrectorDBFolderWithMsg dlg = new DlgCorrectorDBFolderWithMsg(win, errorFolders){

            @Override
            protected Component createNorthComponent() {
                JLabel explain = new JLabel(ResMsgAdmin.getString("PATCH_LOCAL_FOLDER_LABEL"));
                explain.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
                return explain;
            }
        };
        dlg.setTitle(this.getTitle());
        dlg.setLocationRelativeTo(win);
        dlg.setModal(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    AbstractCorrectorWithSimpleMsg.this.patch(dlg.getFoldersToBeCorrected());
                }
            }
        });
    }

    protected void appendError(DBFolder dbFolder, Map<DBFolder, StringBuilder> errorFolders, String msg) {
        StringBuilder msgBuffer = errorFolders.get(dbFolder);
        if (msgBuffer == null) {
            msgBuffer = new StringBuilder();
            errorFolders.put(dbFolder, msgBuffer);
        }
        if (msgBuffer.length() > 0) {
            msgBuffer.append("\n");
        }
        msgBuffer.append(msg);
    }
}

