/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdFreeze;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CorrectorDependFreeze
extends CThread {
    CAppl _appl;

    public CorrectorDependFreeze(CAppl appl, Component c) {
        super(c);
        this._appl = appl;
    }

    @Override
    protected void firstDo() {
        DAOFactory daoFactory = this._appl.getDAOFactory();
        LinkedHashMap<DBFolder, List<DBFolder>> errorFolders = new LinkedHashMap<DBFolder, List<DBFolder>>();
        this.findDependsNotFreeze_rec(daoFactory.createFolderDAO().getRootID("ROOT"), daoFactory, errorFolders);
        if (errorFolders.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgAdmin.getString("PATCH_NO_PROBLEM"), ResMsgAdmin.getString("PATCH_FREEZE_DEPENDS_TITLE"), 1);
            return;
        }
        Window win = JOptionCecilia.getWindowOf(this.getSource());
        final DlgCorrectorDependsFreeze dlg = new DlgCorrectorDependsFreeze(win, errorFolders);
        dlg.setLocationRelativeTo(win);
        dlg.setModal(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    DBFolderCmdFreeze cmd = new DBFolderCmdFreeze(CorrectorDependFreeze.this._appl, CorrectorDependFreeze.this.getSource(), dlg.getFoldersToBeCorrected(), CorrectorDependFreeze.this._appl.getDBUser(), true);
                    cmd.realiseDo();
                }
            }
        });
    }

    private void findDependsNotFreeze_rec(DBFolder dbFolder, DAOFactory daoFactory, Map<DBFolder, List<DBFolder>> errorFolders) {
        if (dbFolder.getObject() != null && dbFolder.isFreeze()) {
            Collection<DBRelation> dbRelations = daoFactory.createRelationDAO().getDestinationRelations(dbFolder);
            for (DBRelation dbRelation : dbRelations) {
                DBFolder dbOther = dbRelation.getDestination();
                if (dbOther.getObject() == null || dbOther.isFreeze()) continue;
                List<DBFolder> freezeLists = errorFolders.get(dbOther);
                if (freezeLists == null) {
                    freezeLists = new ArrayList<DBFolder>();
                    errorFolders.put(dbOther, freezeLists);
                }
                freezeLists.add(dbFolder);
            }
        }
        if (dbFolder.isVersion()) {
            return;
        }
        List<DBFolder> dbChildren = dbFolder.getChildren();
        if (dbChildren == null) {
            dbChildren = daoFactory.createFolderDAO().findChildren(dbFolder);
        }
        if (dbChildren == null) {
            return;
        }
        for (DBFolder dbChild : dbChildren) {
            this.findDependsNotFreeze_rec(dbChild, daoFactory, errorFolders);
        }
    }

    static class DlgCorrectorDependsFreeze
    extends DBFolderDlgDisplayError {
        boolean _bSelectedOnly = true;
        ArrayList<DBFolder> _errorFolders;

        public DlgCorrectorDependsFreeze(Window owner, Map<DBFolder, List<DBFolder>> errorFolders) {
            super(owner);
            this._errorFolders = new ArrayList<DBFolder>(errorFolders.keySet());
            Collections.sort(this._errorFolders, DBFolder.getComparatorWithFamily());
            int size = this._errorFolders.size();
            ArrayList msgs = new ArrayList(size + 1);
            for (int i = 0; i < size; ++i) {
                DBFolder errFolder = this._errorFolders.get(i);
                StringBuilder sb = new StringBuilder();
                List<DBFolder> srcFolders = errorFolders.get(errFolder);
                for (int j = 0; j < srcFolders.size(); ++j) {
                    DBFolder dbSrc = srcFolders.get(j);
                    if (j > 0) {
                        sb.append("\n");
                    }
                    sb.append("- ").append(dbSrc.getRefPath()).append(" (").append(dbSrc.getFamily().toString().toLowerCase()).append(")");
                }
                msgs.add(new GeneralError<DBFolder>(errFolder, sb.toString()));
            }
            this.setErrors(msgs);
            this.setTitle(ResMsgAdmin.getString("PATCH_FREEZE_DEPENDS_TITLE"));
        }

        @Override
        protected Component createNorthComponent() {
            JLabel explain = new JLabel(ResMsgAdmin.getString("PATCH_FREEZE_DEPENDS_LABEL"));
            explain.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            return explain;
        }

        @Override
        protected Component createSouthComponent() {
            JComponent result = this.createButPanel();
            this._ctrlOK.setText(ResMsgAdmin.getString("PATCH_BUTTON"));
            return result;
        }

        @Override
        protected boolean verifyParameters() {
            int selectedSize = this.getSelectedItems().size();
            if (selectedSize == 0) {
                this._bSelectedOnly = false;
                return true;
            }
            if (selectedSize < this._errorFolders.size()) {
                int result = JOptionPane.showConfirmDialog(this, ResMsgAdmin.getString("PATCH_CONFIRM"), this.getTitle(), 1);
                if (result == 2) {
                    return false;
                }
                this._bSelectedOnly = result == 0;
            }
            return true;
        }

        public List<DBFolder> getFoldersToBeCorrected() {
            if (this._bSelectedOnly) {
                return this.getSelectedItems();
            }
            return this._errorFolders;
        }
    }
}

