/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.patchs.DBFoldersDisplayDlg;
import com.dassault.cecilia.main.admin.patchs.ReplayLimitedMigrationThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CorrectorGeneralMigration
extends CCmd {
    DBFolder[] _dbFolders;
    Date _dateModify;
    boolean _isOnlyFreeze;

    public CorrectorGeneralMigration(CAppl appl, Component c) {
        super(appl, c);
    }

    @Override
    protected boolean prepareDo() {
        DBFolderSelectMigrationDlg dlg = new DBFolderSelectMigrationDlg(JOptionCecilia.getWindowOf(this.getSource()), this.getAppl());
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return false;
        }
        this._dbFolders = dlg.getSelectFolders();
        this._dateModify = dlg.getModifyDate();
        this._isOnlyFreeze = dlg.isOnlyFreeze();
        return true;
    }

    @Override
    protected void firstDo() {
        DAOFactory daoFactory = this.getAppl().getDAOFactory();
        LinkedHashSet<DBFolder> selectFolders = new LinkedHashSet<DBFolder>();
        if (this._dbFolders == null || this._dbFolders.length == 0) {
            DBFolder dBFolder = this.getAppl().getDAOFactory().createFolderDAO().getRootID("ROOT");
            this.findFolderObject_rec(dBFolder, daoFactory, selectFolders);
        } else {
            for (DBFolder dbFolder : this._dbFolders) {
                this.findFolderObject_rec(dbFolder, daoFactory, selectFolders);
            }
        }
        if (selectFolders.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgAdmin.getString("PATCH_NO_SELECT"), ResMsgAdmin.getString("PATCH_MIGRATION_TITLE"), 1);
            return;
        }
        Window window = JOptionCecilia.getWindowOf(this.getSource());
        final DBFoldersDisplayDlg dlg = new DBFoldersDisplayDlg(window){

            @Override
            protected Component createNorthComponent() {
                JLabel explain = new JLabel(ResMsgAdmin.getString("PATCH_MIGRATION_LABEL"));
                explain.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
                return explain;
            }
        }.setFolders(new ArrayList<DBFolder>(selectFolders));
        dlg.setTitle(ResMsgAdmin.getString("PATCH_MIGRATION_TITLE"));
        dlg.setLocationRelativeTo(window);
        dlg.setModal(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    ReplayLimitedMigrationThread cmd = new ReplayLimitedMigrationThread(CorrectorGeneralMigration.this.getAppl(), CorrectorGeneralMigration.this.getSource(), dlg.getFoldersToBeCorrected());
                    cmd.setTitle(ResMsgAdmin.getString("PATCH_MIGRATION_TITLE"));
                    cmd.realiseDo();
                }
            }
        });
    }

    private void findFolderObject_rec(DBFolder dbFolder, DAOFactory daoFactory, Set<DBFolder> selectFolders) {
        List<DBFolder> dbChildren;
        if (selectFolders.contains(dbFolder)) {
            return;
        }
        if (!(dbFolder.getObject() == null || this._isOnlyFreeze && !dbFolder.getObject().isFreeze() || dbFolder.getDateModify().after(this._dateModify))) {
            selectFolders.add(dbFolder);
        }
        if ((dbChildren = dbFolder.getChildren()) == null) {
            dbChildren = daoFactory.createFolderDAO().findChildren(dbFolder);
        }
        if (dbChildren == null) {
            return;
        }
        for (DBFolder dbChild : dbChildren) {
            this.findFolderObject_rec(dbChild, daoFactory, selectFolders);
        }
    }

    class DBFolderSelectMigrationDlg
    extends JDialogCecilia {
        CAppl _application;
        DBFolderPanelSelect _ctrlSelect;
        JCheckBox _ctrlOnlyFreeze;
        JTextField _ctrlModifyDate;

        public DBFolderSelectMigrationDlg(Window owner, CAppl appl) {
            super(owner, ResMsgAdmin.getString("PATCH_MIGRATION_TITLE"));
            this._application = appl;
            this.make(owner);
        }

        private void make(Window owner) {
            this._ctrlSelect = new DBFolderPanelSelect(this._application, null){

                @Override
                protected String getRootName() {
                    return "ROOT";
                }
            };
            this._ctrlSelect.getCtrlTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    DBFolder dbFolder = DBFolderSelectMigrationDlg.this._ctrlSelect.getSelectFolder(false);
                    if (dbFolder == null) {
                        return;
                    }
                    DBFolderSelectMigrationDlg.this.validDialog();
                }
            });
            this._ctrlSelect.getCtrlTree().getSelectionModel().setSelectionMode(4);
            this._ctrlSelect.getCtrlTree().setRootVisible(true);
            this._ctrlOnlyFreeze = new JCheckBox("Select only freeze object");
            this._ctrlModifyDate = new JTextField("31/08/2019", 10);
            JLabel lblModifyDate = new JLabel("Modify date : ");
            lblModifyDate.setToolTipText("Select if modify date is lesser than DD/MM/YYYY");
            JPanel center = new JPanel(new GridBagLayout());
            this._ctrlSelect.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select Folders"));
            center.add((Component)this._ctrlSelect, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 21, 1, new Insets(5, 5, 5, 5), 0, 0));
            center.add((Component)this._ctrlOnlyFreeze, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            center.add((Component)lblModifyDate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            center.add((Component)this._ctrlModifyDate, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)center, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.init();
            this.pack();
            this.setSize(350, 350);
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
            this.setModal(true);
        }

        @Override
        protected boolean verifyParameters() {
            if (this.getModifyDate() == null) {
                this._ctrlModifyDate.requestFocus();
                return false;
            }
            return true;
        }

        public DBFolder[] getSelectFolders() {
            return this._ctrlSelect.getSelectFolders();
        }

        public Date getModifyDate() {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            try {
                String txt = this._ctrlModifyDate.getText();
                Date result = format.parse(txt);
                return result;
            }
            catch (ParseException e) {
                return null;
            }
        }

        public boolean isOnlyFreeze() {
            return this._ctrlOnlyFreeze.isSelected();
        }

        @Override
        public void dispose() {
            this._ctrlSelect.dispose();
            super.dispose();
        }
    }
}

