/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

abstract class DlgCorrectorDBFolderWithMsg
extends DBFolderDlgDisplayError {
    boolean _bSelectedOnly = true;
    ArrayList<DBFolder> _errorFolders;

    public DlgCorrectorDBFolderWithMsg(Window owner, Map<DBFolder, StringBuilder> errorFolders) {
        super(owner);
        this._errorFolders = new ArrayList<DBFolder>(errorFolders.keySet());
        Collections.sort(this._errorFolders, DBFolder.getComparatorWithFamily());
        int size = this._errorFolders.size();
        ArrayList msgs = new ArrayList(size + 1);
        for (int i = 0; i < size; ++i) {
            DBFolder errFolder = this._errorFolders.get(i);
            msgs.add(new GeneralError<DBFolder>(errFolder, errorFolders.get(errFolder).toString()));
        }
        this.setErrors(msgs);
    }

    @Override
    protected Component createSouthComponent() {
        JComponent result = this.createButPanel();
        this._ctrlOK.setText(ResMsgAdmin.getString("PATCH_BUTTON"));
        return result;
    }

    @Override
    protected boolean verifyParameters() {
        int selectedSize = this.getSelectedItems().size();
        if (selectedSize == 0) {
            this._bSelectedOnly = false;
            return true;
        }
        if (selectedSize < this._errorFolders.size()) {
            int result = JOptionPane.showConfirmDialog(this, ResMsgAdmin.getString("PATCH_CONFIRM"), this.getTitle(), 1);
            if (result == 2) {
                return false;
            }
            this._bSelectedOnly = result == 0;
        }
        return true;
    }

    public List<DBFolder> getFoldersToBeCorrected() {
        if (this._bSelectedOnly) {
            return this.getSelectedItems();
        }
        return this._errorFolders;
    }
}

