/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOGlobEvent;
import com.dassault.cecilia.db.dao.DAOGroup;
import com.dassault.cecilia.db.dao.DAOLicense;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.db.dao.DAOPreference;
import com.dassault.cecilia.db.dao.DAOProperty;
import com.dassault.cecilia.db.dao.DAORelation;
import com.dassault.cecilia.db.dao.DAOSession;
import com.dassault.cecilia.db.dao.DAOUser;
import com.dassault.cecilia.db.dao.DAOUtility;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.operator.OperatorDictionary;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.awt.Component;
import java.awt.Window;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReplayLimitedMigrationThread
extends CThread {
    private static Logger _LOG = Logger.getLogger(ReplayLimitedMigrationThread.class.getPackage().getName());
    static final String OLD_TYPE_ENUMERATED = "type.enumerated.51";
    static final String OLD_TYPE_STRUCTURED = "type.structured.51";
    static final String OLD_OPERATOR = "operator.51";
    static final String OLD_COMPONENT = "component.51";
    static final String OLD_EQUIPMENT = "equipment.51";
    static final String OLD_SYSTEM_LOCAL = "system.local.51";
    static final String OLD_TREE_DEF = "tree.def.51";
    CAppl _appl;
    List<DBFolder> _selFolders;
    String _strTitle = null;
    List<GeneralError<DBFolder>> _errorMsgs;

    public ReplayLimitedMigrationThread(CAppl appl, Component c, List<DBFolder> selFolders) {
        super(c);
        this._appl = appl;
        this._selFolders = selFolders;
    }

    public String getTitle() {
        return this._strTitle;
    }

    public ReplayLimitedMigrationThread setTitle(String title) {
        this._strTitle = title;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void firstDo() {
        if (this._selFolders.isEmpty()) {
            return;
        }
        ReplayFactory replayFactory = new ReplayFactory((CECFactory)this._appl.getDAOFactory(), new HashSet<DBFolder>(this._selFolders));
        try {
            replayFactory.createFolderDAO().setCacheLogs(true);
            this._errorMsgs = new ArrayList<GeneralError<DBFolder>>();
            for (DBFolder dbFolder : this._selFolders) {
                if (!dbFolder.isVersion()) continue;
                replayFactory.findOrCreateWrap(dbFolder);
            }
        }
        finally {
            replayFactory.createFolderDAO().setCacheLogs(false);
        }
        this._appl.refreshDAOFolder();
        if (!this._errorMsgs.isEmpty()) {
            Window win = JOptionCecilia.getWindowOf(this.getSource());
            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win);
            String title = this.getTitle();
            if (title != null && !title.isEmpty()) {
                dlg.setTitle(title);
            }
            dlg.setErrors(this._errorMsgs);
            dlg.setLocationRelativeTo(win);
            dlg.setVisible(true);
        }
    }

    private boolean addPatchLog(DBWrap dbWrap) {
        String msg = this.getTitle();
        if (msg != null && !msg.isEmpty()) {
            DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this._appl.getDBUser().getLogin(), dbWrap.getLogs());
            logMng.addLog(DBLogs.DBLevel.FINE, msg);
        }
        return true;
    }

    private class ReplayLogsManager
    implements DBLogs.DBLogsManager {
        DBFolder _dbFolder;
        DBLogs.DBLogsManager _delegator;

        ReplayLogsManager(DBFolder dbFolder, DBLogs.DBLogsManager delegator) {
            this._dbFolder = dbFolder;
            this._delegator = delegator;
        }

        @Override
        public void addLog(DBLogs.Log log) {
            MsgType msgType = this.convertLogLevel(log.getLevel());
            if (msgType != null) {
                ReplayLimitedMigrationThread.this._errorMsgs.add(new GeneralError<DBFolder>(this._dbFolder, log.getMessage(), msgType));
            }
            this._delegator.addLog(log);
        }

        @Override
        public void addLog(DBLogs.DBLevel dbLvl, String msg, boolean bPrivate) {
            MsgType msgType = this.convertLogLevel(dbLvl);
            if (msgType != null) {
                ReplayLimitedMigrationThread.this._errorMsgs.add(new GeneralError<DBFolder>(this._dbFolder, msg, msgType));
            }
            this._delegator.addLog(dbLvl, msg, bPrivate);
        }

        @Override
        public boolean withLogs(DBLogs.DBLevel limit) {
            return this._delegator.withLogs(limit);
        }

        private MsgType convertLogLevel(DBLogs.DBLevel dbLevel) {
            switch (dbLevel) {
                case ERROR: {
                    return MsgType.ERROR;
                }
                case WARNING: {
                    return MsgType.WARNING;
                }
                case FINE: {
                    return MsgType.INFO;
                }
                case INFO: {
                    return MsgType.INFO;
                }
            }
            return null;
        }
    }

    private class ReplayFactory
    implements CECFactory {
        Set<DBFolder> _toConvert;
        CECFactory _daoDelegate;
        boolean _change = true;

        public ReplayFactory(CECFactory delegate, Set<DBFolder> toConvert) {
            this._daoDelegate = delegate;
            this._toConvert = toConvert;
        }

        @Override
        public DBWrap findOrCreateWrap(DBFolder dbFolder) {
            if (this._toConvert.contains(dbFolder)) {
                this._toConvert.remove(dbFolder);
                DBWrap dbWrap = this.doFindOrCreateWrap(dbFolder);
                if (dbWrap != null) {
                    return dbWrap;
                }
                _LOG.warning("ReplayFactory don't read this DBFolder: " + dbFolder.getRefPath());
            }
            return this._daoDelegate.findOrCreateWrap(dbFolder);
        }

        private DBWrap doFindOrCreateWrap(DBFolder dbFolder) {
            _LOG.finer("ApplyPatch:" + dbFolder.getRefPath());
            DAOObject daoObject = this.createObjectDAO();
            if (dbFolder.getObject() == null) {
                return null;
            }
            daoObject.putWrap(dbFolder.getObject(), null);
            DBWrap dbWrap = null;
            switch (dbFolder.getFamily()) {
                case ATTRIBUTE: {
                    dbWrap = null;
                    break;
                }
                case PARAMETER: {
                    dbWrap = null;
                    break;
                }
                case BTP_MODEL: {
                    dbWrap = null;
                    break;
                }
                case CCF_MODEL: {
                    dbWrap = null;
                    break;
                }
                case FMEA_MODEL: {
                    dbWrap = null;
                    break;
                }
                case IMAG: {
                    dbWrap = null;
                    break;
                }
                case TYPE: {
                    if (dbFolder.getFamilyFlag() == 1) {
                        dbWrap = new DBEnum(dbFolder){

                            @Override
                            protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                                return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                            }

                            @Override
                            public boolean readLogs(DAOFactory cecFactory) {
                                return ReplayLimitedMigrationThread.this.addPatchLog(this);
                            }

                            @Override
                            protected String getNature() {
                                if (ReplayFactory.this._change) {
                                    return ReplayLimitedMigrationThread.OLD_TYPE_ENUMERATED;
                                }
                                return super.getNature();
                            }
                        };
                        break;
                    }
                    dbWrap = new DBRecord(dbFolder){

                        @Override
                        protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                            return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                        }

                        @Override
                        public boolean readLogs(DAOFactory cecFactory) {
                            return ReplayLimitedMigrationThread.this.addPatchLog(this);
                        }

                        @Override
                        protected String getNature() {
                            if (ReplayFactory.this._change) {
                                return ReplayLimitedMigrationThread.OLD_TYPE_STRUCTURED;
                            }
                            return super.getNature();
                        }
                    };
                    break;
                }
                case OPERATOR: {
                    dbWrap = new AltaOperator(dbFolder){

                        @Override
                        protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                            return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                        }

                        @Override
                        public boolean readLogs(DAOFactory cecFactory) {
                            return ReplayLimitedMigrationThread.this.addPatchLog(this);
                        }

                        @Override
                        protected String getNature() {
                            if (ReplayFactory.this._change) {
                                return ReplayLimitedMigrationThread.OLD_OPERATOR;
                            }
                            return super.getNature();
                        }
                    };
                    break;
                }
                case COMPONENT: {
                    dbWrap = new AltaComponent(dbFolder){

                        @Override
                        protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                            return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                        }

                        @Override
                        public boolean readLogs(DAOFactory cecFactory) {
                            return ReplayLimitedMigrationThread.this.addPatchLog(this);
                        }

                        @Override
                        protected String getNature() {
                            if (ReplayFactory.this._change) {
                                return ReplayLimitedMigrationThread.OLD_COMPONENT;
                            }
                            return super.getNature();
                        }
                    };
                    break;
                }
                case EQUIPMENT: {
                    dbWrap = new AltaEquipment(dbFolder){

                        @Override
                        protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                            return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                        }

                        @Override
                        public boolean readLogs(DAOFactory cecFactory) {
                            return ReplayLimitedMigrationThread.this.addPatchLog(this);
                        }

                        @Override
                        protected String getNature() {
                            if (ReplayFactory.this._change) {
                                return ReplayLimitedMigrationThread.OLD_EQUIPMENT;
                            }
                            return super.getNature();
                        }
                    };
                    break;
                }
                case PROJECT: {
                    if (dbFolder.isFolder() && dbFolder.getObject() != null) {
                        dbWrap = null;
                        break;
                    }
                    switch (dbFolder.getFamilyFlag()) {
                        case 1: {
                            dbWrap = new AltaSystem(dbFolder){

                                @Override
                                protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                                    return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                                }

                                @Override
                                public boolean readLogs(DAOFactory cecFactory) {
                                    return ReplayLimitedMigrationThread.this.addPatchLog(this);
                                }

                                @Override
                                protected String getNature() {
                                    if (ReplayFactory.this._change) {
                                        return ReplayLimitedMigrationThread.OLD_SYSTEM_LOCAL;
                                    }
                                    return super.getNature();
                                }
                            };
                            break;
                        }
                        case 2: {
                            dbWrap = new FTEquation(dbFolder){

                                @Override
                                protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                                    return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                                }

                                @Override
                                public boolean readLogs(DAOFactory cecFactory) {
                                    return ReplayLimitedMigrationThread.this.addPatchLog(this);
                                }

                                @Override
                                protected String getNature() {
                                    if (ReplayFactory.this._change) {
                                        return ReplayLimitedMigrationThread.OLD_TREE_DEF;
                                    }
                                    return super.getNature();
                                }
                            };
                            break;
                        }
                        case 5: {
                            dbWrap = null;
                            break;
                        }
                        case 3: {
                            dbWrap = new DSFEquation(dbFolder){

                                @Override
                                protected DBLogs.DBLogsManager createReadLogsManager(String login) {
                                    return new ReplayLogsManager(this.getDBFolder(), super.createReadLogsManager(login));
                                }

                                @Override
                                public boolean readLogs(DAOFactory cecFactory) {
                                    return ReplayLimitedMigrationThread.this.addPatchLog(this);
                                }

                                @Override
                                protected String getNature() {
                                    if (ReplayFactory.this._change) {
                                        return "tree.def";
                                    }
                                    return super.getNature();
                                }
                            };
                            break;
                        }
                        case 4: {
                            dbWrap = null;
                        }
                    }
                    if (dbWrap != null) break;
                }
                default: {
                    _LOG.severe("There are no declared wrap for DBFolder: " + dbFolder.getRefPath());
                }
            }
            if (dbWrap != null) {
                this._change = true;
                if (this.readFromDAO(dbWrap)) {
                    this._change = false;
                    this.transformBeforeWrite(dbWrap);
                    this.writeToDAO(dbWrap);
                    return dbWrap;
                }
            }
            return null;
        }

        private boolean readFromDAO(DBWrap dbWrap) {
            boolean successRead = false;
            try {
                successRead = dbWrap.readFromDAO(this);
            }
            catch (Exception ex) {
                _LOG.log(Level.INFO, "Exception non gere lors de la lecture d'un DBFolder", ex);
            }
            if (!successRead) {
                ReplayLimitedMigrationThread.this._errorMsgs.add(new GeneralError<DBFolder>(dbWrap.getDBFolder(), "Error during read data from DAO"));
                _LOG.severe("Error during read data from DAO for DBFolder: " + dbWrap.getRefPath());
            }
            return successRead;
        }

        private void transformBeforeWrite(DBWrap dbWrap) {
            if (!(dbWrap instanceof AltaNode)) {
                return;
            }
            AltaNode node = (AltaNode)dbWrap;
            OperatorDictionary opDic = this.getOperatorDictionary();
            Set<String> names = opDic.findOperators(node.getCode());
            List<AltaOperatorRef> operatorsInNode = node.getUsedOperator();
            if (operatorsInNode.size() != 0) {
                for (int i = operatorsInNode.size() - 1; i >= 0; --i) {
                    AltaOperatorRef operatorId = operatorsInNode.get(i);
                    if (names.remove(operatorId.getName())) continue;
                    operatorsInNode.remove(operatorId);
                }
            }
            if (names.size() != 0) {
                for (String name : names) {
                    DBFolder model;
                    Set<DBFolder> folders = opDic.getOperatorsWithName(name);
                    DBFolder select = null;
                    if (folders.size() >= 1 && (model = folders.iterator().next()).isModel()) {
                        List<DBFolder> children = model.getChildren();
                        if (children == null) {
                            children = this.createFolderDAO().findChildren(model);
                        }
                        select = children.get(children.size() - 1);
                    }
                    if (select == null) {
                        ReplayLimitedMigrationThread.this._errorMsgs.add(new GeneralError<DBFolder>(dbWrap.getDBFolder(), "Utilisation d'un operateur inconnu '" + name + "'", MsgType.INFO));
                        _LOG.log(Level.WARNING, "Utilisation d'un operateur inconnu '" + name + "' au sein de '" + dbWrap.getDBFolder().getRefPath() + "'");
                    }
                    AltaOperatorRef operatorId = new AltaOperatorRef(name, select);
                    operatorsInNode.add(operatorId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeToDAO(DBWrap dbWrap) {
            DBFolder dbFolder = dbWrap.getDBFolder();
            boolean freeze = dbFolder.isFreeze();
            if (freeze) {
                this.createObjectDAO().setFreeze(dbFolder.getObject(), false);
            }
            try {
                if (!dbWrap.writeToDAO(this, null)) {
                    ReplayLimitedMigrationThread.this._errorMsgs.add(new GeneralError<DBFolder>(dbFolder, "Erreur lors de l'ecriture dans la base de donnee"));
                    _LOG.severe("Erreur lors de l'ecriture de '" + dbFolder.getRefPath() + "'");
                }
            }
            catch (Exception e) {
                ReplayLimitedMigrationThread.this._errorMsgs.add(new GeneralError<DBFolder>(dbFolder, "Exception lors de l'ecriture dans la base de donnee"));
                _LOG.log(Level.SEVERE, "Exception lors de l'ecriture de '" + dbFolder.getRefPath() + "'", e);
            }
            finally {
                if (freeze) {
                    this.createObjectDAO().setFreeze(dbFolder.getObject(), true);
                }
            }
        }

        @Override
        public String getUserLogin() {
            return this._daoDelegate.getUserLogin();
        }

        @Override
        public void initConnection() {
        }

        @Override
        public DAOGroup createGroupDAO() {
            return this._daoDelegate.createGroupDAO();
        }

        @Override
        public DAOUser createUserDAO() {
            return this._daoDelegate.createUserDAO();
        }

        @Override
        public DAOSession createSessionDAO() {
            return this._daoDelegate.createSessionDAO();
        }

        @Override
        public DAOPreference createPreferenceDAO() {
            return this._daoDelegate.createPreferenceDAO();
        }

        @Override
        public DAOLicense createLicenseDAO() {
            return this._daoDelegate.createLicenseDAO();
        }

        @Override
        public DAOProperty createPropertyDAO() {
            return this._daoDelegate.createPropertyDAO();
        }

        @Override
        public DAOFolder createFolderDAO() {
            return this._daoDelegate.createFolderDAO();
        }

        @Override
        public DAOObject createObjectDAO() {
            return this._daoDelegate.createObjectDAO();
        }

        @Override
        public DAOObjModel createObjModelDAO() {
            return this._daoDelegate.createObjModelDAO();
        }

        @Override
        public DAORelation createRelationDAO() {
            return this._daoDelegate.createRelationDAO();
        }

        @Override
        public DAOGlobEvent createGlobEventDAO() {
            return this._daoDelegate.createGlobEventDAO();
        }

        @Override
        public DAOUtility createUtilityDAO() {
            return this._daoDelegate.createUtilityDAO();
        }

        @Override
        public DateFormat createDateFormat() {
            return this._daoDelegate.createDateFormat();
        }

        @Override
        public void beginTransaction(boolean cumulatif) throws Exception {
            this._daoDelegate.beginTransaction(cumulatif);
        }

        @Override
        public void endTransaction() throws Exception {
            this._daoDelegate.endTransaction();
        }

        @Override
        public void abortTransaction() throws Exception {
            this._daoDelegate.abortTransaction();
        }

        @Override
        public boolean withExceptionDuringTransaction() {
            return this._daoDelegate.withExceptionDuringTransaction();
        }

        @Override
        public boolean ignoreFreezeState() {
            return this._daoDelegate.ignoreFreezeState();
        }

        @Override
        public void setIgnoreFreezeState(boolean value) {
            this._daoDelegate.setIgnoreFreezeState(value);
        }

        @Override
        public void logStats() {
            this._daoDelegate.logStats();
        }

        @Override
        public CLawManager getLawManager() {
            return this._daoDelegate.getLawManager();
        }

        @Override
        public OperatorDictionary getOperatorDictionary() {
            return this._daoDelegate.getOperatorDictionary();
        }
    }
}

