/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.users;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.user.GroupRenderer;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ValueTextField;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.lib.util.CryptUtility;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UsersEditDlg
extends JDialogCecilia {
    private ValueTextField jTextFieldLogin = new ValueTextField("");
    public JPasswordField jPasswordFieldPassword = new JPasswordField("", 32);
    private ValueTextField jTextFieldNom = new ValueTextField("");
    private ValueTextField jTextFieldDescription = new ValueTextField("");
    private JList jListUserInGroups = new JList();
    private JList jListUserNotInGroups = new JList();
    private JButton jButtonSetUserIntoGroups = new JButton(ResMsgAdmin.getString("LBL_ARROW_LEFT"));
    private JButton jButtonSetUserOutOfGroups = new JButton(ResMsgAdmin.getString("LBL_ARROW_RIGHT"));
    private JLabel jLabelMembresOfGroup = new JLabel(ResMsgAdmin.getString("LBL_USR_GROUPS_IN"));
    private JLabel jLabelNotMembresOfGroup = new JLabel(ResMsgAdmin.getString("LBL_USR_GROUPS_OUT"));
    ArrayList<DBGroup> _groups;
    ArrayList<DBUser> _users;
    Vector<DBGroup> _groupsIn = null;
    Vector<DBGroup> _groupsOut = null;
    Vector<DBGroup> _userThrewGroups = null;
    ArrayList<DBUser> _usersSelected;
    Collection<DBUser> _usersResult;

    public UsersEditDlg(Window owner) {
        super(owner, true);
        this.setTitle("Edition d'un utilisateur");
        this.init();
        JPanel centerPanel = this.makePanel();
        this.usersActionListeners();
        this.setLayout(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.createButPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    public void setUsersAndGroups(Collection<DBUser> users, Collection<DBGroup> groups) {
        this._groups = new ArrayList<DBGroup>(groups);
        Collections.sort(this._groups, DBGroup.getComparatorName());
        this._users = new ArrayList<DBUser>(users);
        Collections.sort(this._users, DBUser.getComparatorLogin());
    }

    public void setSelected(Collection<DBUser> users) {
        this._usersSelected = new ArrayList<DBUser>(users);
        switch (this._usersSelected.size()) {
            case 0: {
                this.setTitle("Cr\u00e9ation d'un utilisateur");
                this._groupsIn = new Vector();
                this._groupsOut = new Vector<DBGroup>(this._groups);
                this.jListUserInGroups.setListData(this._groupsIn);
                this.jListUserNotInGroups.setListData(this._groupsOut);
                break;
            }
            case 1: {
                this.setTitle("Modification d'un utilisateur");
                DBUser usr = this._usersSelected.get(0);
                this.jTextFieldLogin.setText(usr.getLogin());
                this.jTextFieldNom.setText(usr.getName());
                this.jPasswordFieldPassword.setText(CryptUtility.decryptData((String)usr.getPassword()));
                if (usr.isMasterAdmin()) {
                    this.jTextFieldLogin.setEditable(false);
                    this.jTextFieldLogin.setEnabled(false);
                }
                this.jTextFieldDescription.setText(usr.getDescription());
                this._groupsIn = new Vector();
                this._groupsOut = new Vector<DBGroup>(this._groups);
                for (IGroup guser : usr.getGroups()) {
                    Iterator<DBGroup> iGrp = this._groupsOut.iterator();
                    while (iGrp.hasNext()) {
                        DBGroup grp = iGrp.next();
                        if (!grp.equals(guser)) continue;
                        this.addInAlphabeticOrder(this._groupsIn, grp);
                        iGrp.remove();
                    }
                }
                this.jListUserInGroups.setListData(this._groupsIn);
                this.jListUserNotInGroups.setListData(this._groupsOut);
                break;
            }
            default: {
                this.setTitle("Modification de plusieurs utilisateurs");
                this.jTextFieldLogin.setEditable(false);
                this.jTextFieldLogin.setEnabled(false);
                this.jTextFieldNom.setEditable(false);
                this.jTextFieldNom.setEnabled(false);
                this.jTextFieldDescription.setEditable(false);
                this.jTextFieldDescription.setEnabled(false);
                this.jPasswordFieldPassword.setEditable(false);
                this.jPasswordFieldPassword.setEnabled(false);
                this._groupsIn = new Vector();
                this._groupsOut = new Vector<DBGroup>(this._groups);
                ArrayList<IGroup> resultIn = new ArrayList<IGroup>(this._usersSelected.get(0).getGroups());
                for (int i = 1; i < this._usersSelected.size(); ++i) {
                    DBUser usr = this._usersSelected.get(i);
                    resultIn.retainAll(usr.getGroups());
                }
                for (IGroup guser : resultIn) {
                    Iterator<DBGroup> iGrp = this._groupsOut.iterator();
                    while (iGrp.hasNext()) {
                        DBGroup grp = iGrp.next();
                        if (!grp.equals(guser)) continue;
                        this.addInAlphabeticOrder(this._groupsIn, grp);
                        iGrp.remove();
                    }
                }
                this.jListUserInGroups.setListData(this._groupsIn);
                this.jListUserNotInGroups.setListData(this._groupsOut);
            }
        }
    }

    public Collection<DBUser> getSelected() {
        return this._usersResult;
    }

    protected boolean verifyField(String name, String login, String passwd, String desc, Set<? extends IGroup> groups, DBUser usr) {
        if (name.length() == 0) {
            return false;
        }
        if (name.length() > 248) {
            return false;
        }
        for (DBUser dbUser : this._users) {
            if (dbUser.equals(usr) || !name.equals(dbUser.getName())) continue;
            return false;
        }
        if (login.length() == 0) {
            return false;
        }
        if (login.length() > 255) {
            return false;
        }
        for (DBUser dbUser : this._users) {
            if (dbUser.equals(usr) || !login.equals(dbUser.getLogin())) continue;
            return false;
        }
        if (passwd.length() > 64) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UsersEditDlg.this.jPasswordFieldPassword.requestFocus();
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(UsersEditDlg.this.jPasswordFieldPassword), ResMsgAdmin.getString("MSG_USR_ERR_PASSWD"), UsersEditDlg.this.getTitle(), 0);
                }
            });
            return false;
        }
        if (desc.length() > 1023) {
            return false;
        }
        return groups.size() != 0;
    }

    @Override
    protected boolean verifyParameters() {
        ArrayList<DBUser> users = new ArrayList<DBUser>();
        switch (this._usersSelected.size()) {
            case 0: {
                String name = this.jTextFieldNom.getText().trim();
                String login = this.jTextFieldLogin.getText().trim();
                String passwd = new String(this.jPasswordFieldPassword.getPassword());
                String desc = this.jTextFieldDescription.getText();
                LinkedHashSet<IGroup> groups = new LinkedHashSet<IGroup>(this._groupsIn);
                if (!this.verifyField(name, login, passwd, desc, groups, null)) {
                    return false;
                }
                DBGroup defGroup = this._groupsIn.firstElement();
                DBUser usr = new DBUser();
                usr.setLogin(login);
                usr.setName(name);
                usr.setPassword(CryptUtility.cryptData((String)passwd));
                usr.setDescription(desc);
                usr.setDefaultGroup(defGroup);
                usr.setGroups(groups);
                users.add(usr);
                break;
            }
            case 1: {
                DBUser usr = this._usersSelected.get(0);
                String name = this.jTextFieldNom.getText().trim();
                String login = this.jTextFieldLogin.getText().trim();
                String passwd = new String(this.jPasswordFieldPassword.getPassword());
                String desc = this.jTextFieldDescription.getText();
                LinkedHashSet<IGroup> groups = new LinkedHashSet<IGroup>(this._groupsIn);
                if (!this.verifyField(name, login, passwd, desc, groups, usr)) {
                    return false;
                }
                IGroup defGroup = usr.getDefaultGroup();
                if (defGroup == null || !groups.contains(defGroup)) {
                    defGroup = this._groupsIn.firstElement();
                }
                usr.setLogin(login);
                usr.setName(name);
                usr.setPassword(CryptUtility.cryptData((String)passwd));
                usr.setDescription(desc);
                usr.setDefaultGroup(defGroup);
                usr.setGroups(groups);
                users.add(usr);
                break;
            }
            default: {
                LinkedHashSet<IGroup> groups = new LinkedHashSet<IGroup>(this._groupsIn);
                if (groups.size() == 0) {
                    return false;
                }
                for (int i = 0; i < this._usersSelected.size(); ++i) {
                    DBUser usr = this._usersSelected.get(i);
                    IGroup defGroup = usr.getDefaultGroup();
                    if (defGroup == null || !groups.contains(defGroup)) {
                        defGroup = this._groupsIn.firstElement();
                    }
                    usr.setDefaultGroup(defGroup);
                    usr.setGroups(groups);
                    users.add(usr);
                }
            }
        }
        this._usersResult = users;
        return true;
    }

    private boolean isGroupEnable(DBGroup grp) {
        return this._usersSelected.size() != 1 || !this._usersSelected.get(0).isMasterAdmin() || !grp.isAdmin();
    }

    private JPanel makePanel() {
        JPanel resultPanel = new JPanel(new GridBagLayout());
        resultPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_LOGIN")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_PASSWORD")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_NAME")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)this.jTextFieldLogin, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)this.jPasswordFieldPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)this.jTextFieldNom, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)this.jTextFieldDescription, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jTextFieldLogin.setStringFormat(255);
        this.jTextFieldNom.setStringFormat(248);
        this.jTextFieldDescription.setStringFormat(1023);
        this.jListUserInGroups.setFixedCellWidth(100);
        this.jListUserNotInGroups.setFixedCellWidth(100);
        this.jListUserInGroups.setFixedCellHeight(15);
        this.jListUserNotInGroups.setFixedCellHeight(15);
        this.jListUserInGroups.setCellRenderer(new GroupRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean enabled = UsersEditDlg.this.isGroupEnable((DBGroup)value);
                super.getListCellRendererComponent(list, value, index, enabled && isSelected, cellHasFocus);
                this.setEnabled(enabled);
                return this;
            }
        });
        this.jListUserNotInGroups.setCellRenderer(new GroupRenderer());
        this.jListUserInGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                UsersEditDlg.this.setUserOutOfGroups();
            }
        });
        this.jListUserNotInGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                UsersEditDlg.this.setUserIntoGroups();
            }
        });
        JPanel panelGroups = new JPanel(new GridBagLayout());
        panelGroups.add((Component)this.jLabelMembresOfGroup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelGroups.add((Component)new JScrollPane(this.jListUserInGroups), new GridBagConstraints(1, 3, 4, 4, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelGroups.add((Component)this.jButtonSetUserIntoGroups, new GridBagConstraints(5, 3, 1, 1, 0.0, 1.0, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelGroups.add((Component)this.jButtonSetUserOutOfGroups, new GridBagConstraints(5, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelGroups.add((Component)this.jLabelNotMembresOfGroup, new GridBagConstraints(6, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelGroups.add((Component)new JScrollPane(this.jListUserNotInGroups), new GridBagConstraints(6, 3, 4, 4, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.add((Component)new JScrollPane(panelGroups), new GridBagConstraints(0, 6, 12, 7, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        resultPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jButtonSetUserIntoGroups.setEnabled(false);
        this.jButtonSetUserOutOfGroups.setEnabled(false);
        return resultPanel;
    }

    private int addInAlphabeticOrder(Vector<DBGroup> list, DBGroup group) {
        if (list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (group.getName().compareTo(list.elementAt(i).getName()) >= 0) continue;
                list.insertElementAt(group, i);
                return i;
            }
            list.addElement(group);
            return -1;
        }
        list.addElement(group);
        return 0;
    }

    private void setUserIntoGroups() {
        int j;
        int[] sels = this.jListUserNotInGroups.getSelectedIndices();
        for (j = 0; j < sels.length; ++j) {
            this.addInAlphabeticOrder(this._groupsIn, this._groupsOut.elementAt(sels[j]));
        }
        for (j = 0; j < this._groupsIn.size(); ++j) {
            for (int k = 0; k < this._groupsOut.size(); ++k) {
                if (this._groupsIn.elementAt(j) != this._groupsOut.elementAt(k)) continue;
                this._groupsOut.removeElementAt(k);
            }
        }
        this.jListUserInGroups.removeAll();
        this.jListUserNotInGroups.removeAll();
        this.jListUserInGroups.setListData(this._groupsIn);
        this.jListUserNotInGroups.setListData(this._groupsOut);
    }

    private void setUserOutOfGroups() {
        int j;
        int[] sels = this.jListUserInGroups.getSelectedIndices();
        for (j = 0; j < sels.length; ++j) {
            DBGroup grp = this._groupsIn.elementAt(sels[j]);
            if (!this.isGroupEnable(grp)) continue;
            this.addInAlphabeticOrder(this._groupsOut, grp);
        }
        this._userThrewGroups = new Vector();
        for (j = 0; j < this._groupsOut.size(); ++j) {
            for (int k = 0; k < this._groupsIn.size(); ++k) {
                if (this._groupsOut.elementAt(j) != this._groupsIn.elementAt(k)) continue;
                this._userThrewGroups.addElement(this._groupsIn.elementAt(k));
                this._groupsIn.removeElementAt(k);
            }
        }
        this.jListUserInGroups.removeAll();
        this.jListUserNotInGroups.removeAll();
        this.jListUserInGroups.setListData(this._groupsIn);
        this.jListUserNotInGroups.setListData(this._groupsOut);
    }

    private void usersActionListeners() {
        this.jButtonSetUserIntoGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UsersEditDlg.this.setUserIntoGroups();
            }
        });
        this.jButtonSetUserOutOfGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UsersEditDlg.this.setUserOutOfGroups();
            }
        });
        this.jListUserInGroups.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean enabled = false;
                int[] sels = UsersEditDlg.this.jListUserInGroups.getSelectedIndices();
                for (int i = 0; i < sels.length && !enabled; ++i) {
                    if (UsersEditDlg.this.isGroupEnable(UsersEditDlg.this._groupsIn.elementAt(sels[i]))) {
                        enabled = true;
                        continue;
                    }
                    final int removeSel = sels[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UsersEditDlg.this.jListUserInGroups.removeSelectionInterval(removeSel, removeSel);
                        }
                    });
                }
                UsersEditDlg.this.jButtonSetUserOutOfGroups.setEnabled(enabled);
            }
        });
        this.jListUserNotInGroups.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UsersEditDlg.this.jButtonSetUserIntoGroups.setEnabled(UsersEditDlg.this.jListUserNotInGroups.getSelectedIndex() != -1);
            }
        });
    }
}

