/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.view;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.cecilia.user.UserRenderer;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ListComboBoxModel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOSession;
import com.dassault.cecilia.db.dao.DAOUser;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.view.DBFolderDebugPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DBFolderDebugWindows
extends JDialog
implements CApplInit.CloseableAction {
    CAppl _application;
    DBUser _dbUser;
    DBSession _dbSession;
    DBFolderDebugPanel _panel;

    public static void createAndDisplay(Window owner, CAppl appl) {
        DAOUser daoUser = appl.getDAOFactory().createUserDAO();
        ListComboBoxModel<? super IUser> model = new ListComboBoxModel<IUser>(DBUser.getComparatorLogin());
        model.setList(daoUser.findAll());
        if (model.getSize() == 0) {
            return;
        }
        JComboBox<? super IUser> ctrlUsers = new JComboBox<IUser>(model);
        ctrlUsers.setRenderer(new UserRenderer());
        ctrlUsers.setSelectedIndex(model.getSize() > 2 ? 2 : 0);
        int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(owner), ctrlUsers, ResMsgAdmin.getString("MSG_FOL_SELECT_USER"), 2);
        if (result != 0) {
            return;
        }
        DBUser select = (DBUser)ctrlUsers.getSelectedItem();
        if (select == null) {
            return;
        }
        DBFolderDebugWindows dlg = new DBFolderDebugWindows(owner, appl);
        dlg.setUser(select);
        dlg.make();
        dlg.setVisible(true);
    }

    DBFolderDebugWindows(Window owner, CAppl appl) {
        super(owner);
        this._application = appl;
        this.setModal(false);
    }

    DBFolderDebugWindows setUser(DBUser dbUser) {
        this._dbUser = dbUser;
        return this;
    }

    void make() {
        this.setTitle(ResMsgAdmin.msgFormat("TITLE_USER_TREE_VIEW", this._dbUser.getLogin()));
        DAOSession daoSession = this._application.getDAOFactory().createSessionDAO();
        DBSession session = new DBSession().setModule("READERS").setUser(this._dbUser);
        this._dbSession = daoSession.create(session);
        this._application.addCloseableAction(this);
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DBFolder root = daoFolder.getRootID("ROOT");
        List<DBFolder> roots = root.getChildren();
        if (roots == null) {
            roots = daoFolder.findChildren(root);
        }
        this._panel = new DBFolderDebugPanel(this._application, this._dbUser, roots);
        this.add((Component)this._panel, "Center");
        this.pack();
        Dimension size = this.getSize();
        size.width *= 2;
        this.setSize(size);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DBFolderDebugWindows.this._panel.parentWindowClosing();
                DBFolderDebugWindows.this._application.removeCloseableAction(DBFolderDebugWindows.this);
                DBFolderDebugWindows.this.callClose();
            }
        });
    }

    @Override
    public void callClose() {
        DAOSession daoSession = this._application.getDAOFactory().createSessionDAO();
        daoSession.delete(this._dbSession);
    }
}

