/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.BanInferencePlugin;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginInference;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PluginCmdIVerify
extends PluginInference
implements PluginMAction {
    public static final String OPT_WARNING = PluginCmdIVerify.class.getName() + "#Warning";
    public static final String OPT_VERIFY_ASSERT = PluginCmdIVerify.class.getName() + "#VerifyAssert";
    public static final String OPT_TIME = PluginCmdIVerify.class.getName() + "#Time";
    IVerifyOptsPanel _opts = null;

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_CMD_VERIFY_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_CMD_VERIFY_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("sub-type")) {
            return "PluginActionControl";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-08.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new IVerifyOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(Plugable launcher, Object params) {
        if (this.verifyPluginTranslator(launcher) == null) {
            return;
        }
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        final File resFile = this.createFile(launcher);
        if (resFile == null) {
            return;
        }
        BanInferencePlugin plugInf = new BanInferencePlugin(model){

            @Override
            protected void prepareBanEntry(Plugable launch, Object ... objects) {
                super.prepareBanEntry(launch, objects);
                BanEntry ban = this.getBanEntry();
                ban.setUserProperty("altr.input", this.getModel().getFile().getAbsolutePath());
                ban.setUserProperty("altr.main", this.getModel().getName());
                ban.setUserProperty("action.stepper", "false");
                ban.setUserProperty("action.translate", "false");
                ban.setUserProperty("action.syntax", "true");
                ban.setUserProperty("action.verify", "true");
                ban.setUserProperty("iverify.outtput", resFile.getAbsolutePath());
                ban.setUserProperty("iverify.warning", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_WARNING, (boolean)true)));
                ban.setUserProperty("iverify.time", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_TIME, (boolean)true)));
                ban.setUserProperty("iverify.assert", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_VERIFY_ASSERT, (boolean)true)));
            }
        };
        try {
            BanEntry ban = plugInf.banExecute(launcher, null, new Object[0]);
            if (ban == null) {
                return;
            }
            try {
                AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                    protected String getLabel() {
                        return ResCStep.getString("PRV_CMD_VERIFY_LBL");
                    }

                    public String getInfo(String key) {
                        if (key.equals("ppanel.title")) {
                            return ResCStep.getString("PRV_CMD_VERIFY_TITLE");
                        }
                        if (key.equals("ppanel.default.width")) {
                            return "600";
                        }
                        if (key.equals("ppanel.default.height")) {
                            return "480";
                        }
                        String res = super.getInfo(key);
                        if (res == null) {
                            return PluginCmdIVerify.this.getInfo(key);
                        }
                        return res;
                    }
                };
                pPane.load(resFile);
                launcher.addPanel((PlugPanel)pPane, model.getUID());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), "Display result file : " + e1.getMessage(), ResCStep.getString("DEF_TITLE"), 0);
            }
        }
        finally {
            if (!resFile.delete()) {
                resFile.deleteOnExit();
            }
        }
    }

    class IVerifyOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlWarning;
        JCheckBox _ctrlTime;
        JCheckBox _ctrlVerify;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlWarning.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_WARNING, (boolean)true));
            this._ctrlVerify.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_VERIFY_ASSERT, (boolean)true));
            this._ctrlTime.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_TIME, (boolean)true));
        }

        public IVerifyOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            Box root = Box.createVerticalBox();
            root.setBorder(BorderFactory.createTitledBorder(ResCStep.getString("DLG_OPT_VERIFY")));
            this._ctrlWarning = new JCheckBox(ResCStep.getString("DLG_OPT_VERIFY_WARNING"));
            this._ctrlWarning.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IVerifyOptsPanel.this._launcher.setOption(OPT_WARNING, IVerifyOptsPanel.this._ctrlWarning.isSelected() ? "true" : "false");
                }
            });
            root.add(this._ctrlWarning);
            this._ctrlTime = new JCheckBox(ResCStep.getString("DLG_OPT_VERIFY_TIME"));
            this._ctrlTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IVerifyOptsPanel.this._launcher.setOption(OPT_TIME, IVerifyOptsPanel.this._ctrlTime.isSelected() ? "true" : "false");
                }
            });
            root.add(this._ctrlTime);
            this._ctrlVerify = new JCheckBox(ResCStep.getString("DLG_OPT_VERIFY_ASSERT"));
            this._ctrlVerify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IVerifyOptsPanel.this._launcher.setOption(OPT_VERIFY_ASSERT, IVerifyOptsPanel.this._ctrlVerify.isSelected() ? "true" : "false");
                }
            });
            root.add(this._ctrlVerify);
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdIVerify.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

